/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jpt.sun.source.tree.BindingPatternTree;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IfTree;
import jpt.sun.source.tree.InstanceOfTree;
import jpt.sun.source.tree.ParenthesizedTree;
import jpt.sun.source.tree.PatternTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.RecordComponentElement;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CodeStyleUtils;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.java.hints.Feature;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.MatcherUtilities;

public class ConvertToRecordPattern {
    public static ErrorDescription trivial(final HintContext ctx) {
        if (!Feature.RECORD_PATTERN.isEnabled(ctx.getInfo())) {
            return null;
        }
        ElementKind kind = ctx.getInfo().getTrees().getElement(ctx.getVariables().get("$typeI0")).getKind();
        if (kind == ElementKind.RECORD) {
            final HashSet<TreePath> convertPath = new HashSet<TreePath>();
            final HashSet<String> localVarList = new HashSet<String>();
            localVarList.add(ctx.getInfo().getTrees().getElement(ctx.getVariables().get("$expr")).getSimpleName().toString());
            final HashMap<String, String> varNames = new HashMap<String, String>();
            new CancellableTreePathScanner<Void, Void>(){
                String variableName = null;

                @Override
                public Void visitVariable(VariableTree node, Void p) {
                    if (this.variableName == null) {
                        this.variableName = node.getName().toString();
                    }
                    localVarList.add(node.getName().toString());
                    HashMap<String, TreePath> outerVariables = new HashMap<String, TreePath>();
                    HashMap<String, String> innerVariables = new HashMap<String, String>();
                    boolean match = MatcherUtilities.matches(ctx, this.getCurrentPath(), "$type $var1 = $expr3.$meth1()", outerVariables, new HashMap<String, Collection<? extends TreePath>>(), innerVariables);
                    if (match && ((TreePath)outerVariables.get("$expr3")).getLeaf().toString().equals(this.variableName)) {
                        varNames.put((String)innerVariables.get("$meth1"), (String)innerVariables.get("$var1"));
                        convertPath.add(this.getCurrentPath());
                    }
                    return (Void)super.visitVariable(node, p);
                }

                @Override
                protected boolean isCanceled() {
                    return ctx.isCanceled();
                }
            }.scan(ctx.getPath(), (Void)null);
            TypeElement type = (TypeElement)ctx.getInfo().getTrees().getElement(ctx.getVariables().get("$typeI0"));
            List<? extends RecordComponentElement> recordSig = type.getRecordComponents();
            if (!convertPath.isEmpty()) {
                Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath(), convertPath, recordSig, varNames, localVarList).toEditorFix();
                return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_ConvertToRecordPattern(), fix);
            }
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        private final Set<TreePathHandle> replaceOccurrences;
        private final List<? extends ElementHandle> recordSig;
        private final Map<String, String> varNames;
        private final Set<String> localVarList;

        public FixImpl(CompilationInfo info, TreePath main, Set<TreePath> replaceOccurrences, List<? extends RecordComponentElement> recordSig, Map<String, String> varNames, Set<String> localVarList) {
            super(info, main);
            this.recordSig = recordSig.stream().map(elem -> ElementHandle.create(elem)).toList();
            this.varNames = varNames;
            this.replaceOccurrences = replaceOccurrences.stream().map(tp -> TreePathHandle.create(tp, info)).collect(Collectors.toSet());
            this.localVarList = new HashSet<String>(localVarList);
        }

        @Override
        protected String getText() {
            return Bundle.FIX_ConvertToRecordPattern();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath main = ctx.getPath();
            IfTree it = (IfTree)main.getLeaf();
            InstanceOfTree iot = (InstanceOfTree)((ParenthesizedTree)it.getCondition()).getExpression();
            BindingPatternTree pattern = (BindingPatternTree)iot.getPattern();
            StatementTree bt = it.getThenStatement();
            ArrayList<PatternTree> bindTree = new ArrayList<PatternTree>();
            ArrayList recordSignature = new ArrayList();
            this.recordSig.stream().map(elem -> elem.resolve(wc)).forEach(elem -> recordSignature.add((RecordComponentElement)elem));
            HashSet<String> localVars = new HashSet<String>(this.localVarList);
            for (RecordComponentElement recordComponent : recordSignature) {
                String compName = recordComponent.getSimpleName().toString();
                String name = null;
                String returnType = null;
                if (this.varNames.containsKey(compName)) {
                    name = this.varNames.get(compName);
                } else {
                    int cnt = 1;
                    name = compName;
                    while (SourceVersion.isKeyword(name) || localVars.contains(name)) {
                        name = CodeStyleUtils.addPrefixSuffix(compName + cnt++, "", "");
                    }
                    localVars.add(name);
                }
                returnType = recordComponent.getAccessor().getReturnType().toString();
                returnType = returnType.substring(returnType.lastIndexOf(".") + 1);
                bindTree.add((BindingPatternTree)wc.getTreeMaker().BindingPattern(wc.getTreeMaker().Variable(wc.getTreeMaker().Modifiers(EnumSet.noneOf(Modifier.class)), name, wc.getTreeMaker().Identifier(returnType), null)));
            }
            InstanceOfTree cond = wc.getTreeMaker().InstanceOf(iot.getExpression(), wc.getTreeMaker().RecordPattern((ExpressionTree)pattern.getVariable().getType(), bindTree, pattern.getVariable()));
            for (TreePathHandle tph : this.replaceOccurrences) {
                StatementTree st = (StatementTree)tph.resolve(wc).getLeaf();
                bt = wc.getTreeMaker().removeBlockStatement((BlockTree)bt, st);
            }
            wc.rewrite(it, wc.getTreeMaker().If(wc.getTreeMaker().Parenthesized(cond), bt, it.getElseStatement()));
        }
    }
}

