/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalFrozenNode;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionItemImpl;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

class InternalVersionImpl
extends InternalVersionItemImpl
implements InternalVersion {
    private Calendar created;
    private HashSet labelCache = null;
    private final boolean isRoot;
    private final Name name;
    private final InternalVersionHistory versionHistory;

    public InternalVersionImpl(InternalVersionHistoryImpl vh, NodeStateEx node, Name name) {
        super(vh.getVersionManager(), node);
        this.versionHistory = vh;
        this.name = name;
        InternalValue[] values = node.getPropertyValues(NameConstants.JCR_CREATED);
        if (values != null) {
            this.created = values[0].getDate();
        }
        this.isRoot = name.equals(NameConstants.JCR_ROOTVERSION);
    }

    public NodeId getId() {
        return this.node.getNodeId();
    }

    public InternalVersionItem getParent() {
        return this.versionHistory;
    }

    public Name getName() {
        return this.name;
    }

    public InternalFrozenNode getFrozenNode() {
        try {
            return (InternalFrozenNode)this.vMgr.getItem(this.getFrozenNodeId());
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("unable to retrieve frozen node: " + (Object)((Object)e));
        }
    }

    public NodeId getFrozenNodeId() {
        ChildNodeEntry entry = this.node.getState().getChildNodeEntry(NameConstants.JCR_FROZENNODE, 1);
        if (entry == null) {
            throw new InternalError("version has no frozen node: " + this.getId());
        }
        return entry.getId();
    }

    public Calendar getCreated() {
        return this.created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalVersion[] getSuccessors() {
        this.vMgr.acquireReadLock();
        try {
            InternalValue[] values = this.node.getPropertyValues(NameConstants.JCR_SUCCESSORS);
            if (values != null) {
                InternalVersion[] versions = new InternalVersion[values.length];
                for (int i = 0; i < values.length; ++i) {
                    NodeId vId = new NodeId(values[i].getUUID());
                    versions[i] = this.versionHistory.getVersion(vId);
                }
                InternalVersion[] internalVersionArray = versions;
                return internalVersionArray;
            }
            InternalVersion[] internalVersionArray = new InternalVersion[]{};
            return internalVersionArray;
        }
        finally {
            this.vMgr.releaseReadLock();
        }
    }

    public InternalVersion[] getPredecessors() {
        InternalValue[] values = this.node.getPropertyValues(NameConstants.JCR_PREDECESSORS);
        if (values != null) {
            InternalVersion[] versions = new InternalVersion[values.length];
            for (int i = 0; i < values.length; ++i) {
                NodeId vId = new NodeId(values[i].getUUID());
                versions[i] = this.versionHistory.getVersion(vId);
            }
            return versions;
        }
        return new InternalVersion[0];
    }

    public boolean isMoreRecent(InternalVersion v) {
        InternalVersion[] preds = this.getPredecessors();
        for (int i = 0; i < preds.length; ++i) {
            InternalVersion pred = preds[i];
            if (!pred.equals(v) && !pred.isMoreRecent(v)) continue;
            return true;
        }
        return false;
    }

    public InternalVersionHistory getVersionHistory() {
        return this.versionHistory;
    }

    public boolean hasLabel(Name label) {
        return this.internalHasLabel(label);
    }

    public Name[] getLabels() {
        return this.internalGetLabels();
    }

    public boolean isRootVersion() {
        return this.isRoot;
    }

    void clear() {
        this.labelCache = null;
    }

    private void storeXCessors(List cessors, Name propname, boolean store) throws RepositoryException {
        InternalValue[] values = new InternalValue[cessors.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = InternalValue.create(((InternalVersion)cessors.get(i)).getId().getUUID());
        }
        this.node.setPropertyValues(propname, 1, values);
        if (store) {
            this.node.store();
        }
    }

    void internalDetach() throws RepositoryException {
        InternalVersion[] succ = this.getSuccessors();
        for (int i = 0; i < succ.length; ++i) {
            ((InternalVersionImpl)succ[i]).internalDetachPredecessor(this, true);
        }
        InternalVersion[] preds = this.getPredecessors();
        for (int i = 0; i < preds.length; ++i) {
            ((InternalVersionImpl)preds[i]).internalDetachSuccessor(this, true);
        }
        this.clear();
    }

    void internalAttach() throws RepositoryException {
        InternalVersion[] preds = this.getPredecessors();
        for (int i = 0; i < preds.length; ++i) {
            ((InternalVersionImpl)preds[i]).internalAddSuccessor(this, true);
        }
    }

    private void internalAddSuccessor(InternalVersionImpl succ, boolean store) throws RepositoryException {
        ArrayList<InternalVersion> l = new ArrayList<InternalVersion>(Arrays.asList(this.getSuccessors()));
        if (!l.contains(succ)) {
            l.add(succ);
            this.storeXCessors(l, NameConstants.JCR_SUCCESSORS, store);
        }
    }

    private void internalDetachPredecessor(InternalVersionImpl v, boolean store) throws RepositoryException {
        ArrayList<InternalVersion> l = new ArrayList<InternalVersion>(Arrays.asList(this.getPredecessors()));
        l.remove(v);
        l.addAll(Arrays.asList(v.getPredecessors()));
        this.storeXCessors(l, NameConstants.JCR_PREDECESSORS, store);
    }

    private void internalDetachSuccessor(InternalVersionImpl v, boolean store) throws RepositoryException {
        ArrayList<InternalVersion> l = new ArrayList<InternalVersion>(Arrays.asList(this.getSuccessors()));
        l.remove(v);
        l.addAll(Arrays.asList(v.getSuccessors()));
        this.storeXCessors(l, NameConstants.JCR_SUCCESSORS, store);
    }

    boolean internalAddLabel(Name label) {
        if (this.labelCache == null) {
            this.labelCache = new HashSet();
        }
        return this.labelCache.add(label);
    }

    boolean internalRemoveLabel(Name label) {
        if (this.labelCache == null) {
            return false;
        }
        return this.labelCache.remove(label);
    }

    boolean internalHasLabel(Name label) {
        if (this.labelCache == null) {
            return false;
        }
        return this.labelCache.contains(label);
    }

    Name[] internalGetLabels() {
        if (this.labelCache == null) {
            return new Name[0];
        }
        return this.labelCache.toArray(new Name[this.labelCache.size()]);
    }

    void invalidate() {
        this.node.getState().discard();
    }

    void legacyResolveSuccessors() throws RepositoryException {
        InternalValue[] values = this.node.getPropertyValues(NameConstants.JCR_PREDECESSORS);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                NodeId vId = new NodeId(values[i].getUUID());
                InternalVersionImpl v = (InternalVersionImpl)this.versionHistory.getVersion(vId);
                v.internalAddSuccessor(this, false);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InternalVersionImpl) {
            InternalVersionImpl v = (InternalVersionImpl)obj;
            return v.getId().equals(this.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

