/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdf.model;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hdf.event.HDFLowLevelParsingListener;
import org.apache.poi.hdf.model.HDFObjectModel;
import org.apache.poi.hdf.model.hdftypes.CHPFormattedDiskPage;
import org.apache.poi.hdf.model.hdftypes.ChpxNode;
import org.apache.poi.hdf.model.hdftypes.DocumentProperties;
import org.apache.poi.hdf.model.hdftypes.FileInformationBlock;
import org.apache.poi.hdf.model.hdftypes.FontTable;
import org.apache.poi.hdf.model.hdftypes.FormattedDiskPage;
import org.apache.poi.hdf.model.hdftypes.ListTables;
import org.apache.poi.hdf.model.hdftypes.PAPFormattedDiskPage;
import org.apache.poi.hdf.model.hdftypes.PapxNode;
import org.apache.poi.hdf.model.hdftypes.PlexOfCps;
import org.apache.poi.hdf.model.hdftypes.SepxNode;
import org.apache.poi.hdf.model.hdftypes.StyleSheet;
import org.apache.poi.hdf.model.hdftypes.TextPiece;
import org.apache.poi.hdf.model.util.ParsingState;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;

public class HDFObjectFactory {
    private POIFSFileSystem _filesystem;
    private FileInformationBlock _fib;
    private HDFLowLevelParsingListener _listener;
    private ParsingState _charParsingState;
    private ParsingState _parParsingState;
    byte[] _mainDocument;
    byte[] _tableBuffer;

    public static void main(String[] args) {
        try {
            HDFObjectFactory f = new HDFObjectFactory(new FileInputStream("c:\\test.doc"));
            boolean bl = false;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected HDFObjectFactory(InputStream istream, HDFLowLevelParsingListener l) throws IOException {
        this._listener = l == null ? new HDFObjectModel() : l;
        this._filesystem = new POIFSFileSystem(istream);
        DocumentEntry headerProps = (DocumentEntry)this._filesystem.getRoot().getEntry("WordDocument");
        this._mainDocument = new byte[headerProps.getSize()];
        this._filesystem.createDocumentInputStream("WordDocument").read(this._mainDocument);
        this._fib = new FileInformationBlock(this._mainDocument);
        this.initTableStream();
        this.initTextPieces();
        this.initFormattingProperties();
    }

    public HDFObjectFactory(InputStream istream) throws IOException {
        this(istream, null);
    }

    public static List getTypes(InputStream istream) throws IOException {
        ArrayList<FileInformationBlock> results = new ArrayList<FileInformationBlock>(1);
        POIFSFileSystem filesystem = new POIFSFileSystem(istream);
        DocumentEntry headerProps = (DocumentEntry)filesystem.getRoot().getEntry("WordDocument");
        byte[] mainDocument = new byte[headerProps.getSize()];
        filesystem.createDocumentInputStream("WordDocument").read(mainDocument);
        FileInformationBlock fib = new FileInformationBlock(mainDocument);
        results.add(fib);
        return results;
    }

    private void initTableStream() throws IOException {
        String tablename = null;
        tablename = this._fib.isFWhichTblStm() ? "1Table" : "0Table";
        DocumentEntry tableEntry = (DocumentEntry)this._filesystem.getRoot().getEntry(tablename);
        int size = tableEntry.getSize();
        this._tableBuffer = new byte[size];
        this._filesystem.createDocumentInputStream(tablename).read(this._tableBuffer);
    }

    private void initTextPieces() throws IOException {
        int pos = this._fib.getFcClx();
        while (this._tableBuffer[pos] == 1) {
            short skip = LittleEndian.getShort((byte[])this._tableBuffer, (int)(++pos));
            pos += 2 + skip;
        }
        if (this._tableBuffer[pos] != 2) {
            throw new IOException("The text piece table is corrupted");
        }
        int pieceTableSize = LittleEndian.getInt((byte[])this._tableBuffer, (int)(++pos));
        pos += 4;
        int pieces = (pieceTableSize - 4) / 12;
        for (int x = 0; x < pieces; ++x) {
            int filePos = LittleEndian.getInt((byte[])this._tableBuffer, (int)(pos + (pieces + 1) * 4 + x * 8 + 2));
            boolean unicode = false;
            if ((filePos & 0x40000000) == 0) {
                unicode = true;
            } else {
                unicode = false;
                filePos &= 0xBFFFFFFF;
                filePos /= 2;
            }
            int totLength = LittleEndian.getInt((byte[])this._tableBuffer, (int)(pos + (x + 1) * 4)) - LittleEndian.getInt((byte[])this._tableBuffer, (int)(pos + x * 4));
            TextPiece piece = new TextPiece(filePos, totLength, unicode);
            this._listener.text(piece);
        }
    }

    private void initFormattingProperties() {
        this.createStyleSheet();
        this.createListTables();
        this.createFontTable();
        this.initDocumentProperties();
        this.initSectionProperties();
    }

    private void initCharacterProperties(int charOffset, PlexOfCps charPlcf, int start, int end) {
        int charPlcfLen = charPlcf.length();
        int currentPageIndex = this._charParsingState.getCurrentPageIndex();
        FormattedDiskPage fkp = this._charParsingState.getFkp();
        int currentChpxIndex = this._charParsingState.getCurrentPropIndex();
        int currentArraySize = fkp.size();
        int charStart = 0;
        int charEnd = 0;
        do {
            if (currentChpxIndex < currentArraySize) {
                charStart = fkp.getStart(currentChpxIndex);
                charEnd = fkp.getEnd(currentChpxIndex);
                byte[] chpx = fkp.getGrpprl(currentChpxIndex);
                this._listener.characterRun(new ChpxNode(Math.max(charStart, start), Math.min(charEnd, end), chpx));
                if (charEnd < end) {
                    ++currentChpxIndex;
                    continue;
                }
                this._charParsingState.setState(currentPageIndex, fkp, currentChpxIndex);
                break;
            }
            int currentCharPage = LittleEndian.getInt((byte[])this._tableBuffer, (int)(charOffset + charPlcf.getStructOffset(++currentPageIndex)));
            byte[] byteFkp = new byte[512];
            System.arraycopy(this._mainDocument, currentCharPage * 512, byteFkp, 0, 512);
            fkp = new CHPFormattedDiskPage(byteFkp);
            currentChpxIndex = 0;
            currentArraySize = fkp.size();
        } while (currentPageIndex < charPlcfLen);
    }

    private void initParagraphProperties(int parOffset, PlexOfCps parPlcf, int charOffset, PlexOfCps charPlcf, int start, int end) {
        int parPlcfLen = parPlcf.length();
        int currentPageIndex = this._parParsingState.getCurrentPageIndex();
        FormattedDiskPage fkp = this._parParsingState.getFkp();
        int currentPapxIndex = this._parParsingState.getCurrentPropIndex();
        int currentArraySize = fkp.size();
        do {
            if (currentPapxIndex < currentArraySize) {
                int parStart = fkp.getStart(currentPapxIndex);
                int parEnd = fkp.getEnd(currentPapxIndex);
                byte[] papx = fkp.getGrpprl(currentPapxIndex);
                this._listener.paragraph(new PapxNode(Math.max(parStart, start), Math.min(parEnd, end), papx));
                this.initCharacterProperties(charOffset, charPlcf, Math.max(start, parStart), Math.min(parEnd, end));
                if (parEnd < end) {
                    ++currentPapxIndex;
                    continue;
                }
                this._parParsingState.setState(currentPageIndex, fkp, currentPapxIndex);
                break;
            }
            int currentParPage = LittleEndian.getInt((byte[])this._tableBuffer, (int)(parOffset + parPlcf.getStructOffset(++currentPageIndex)));
            byte[] byteFkp = new byte[512];
            System.arraycopy(this._mainDocument, currentParPage * 512, byteFkp, 0, 512);
            fkp = new PAPFormattedDiskPage(byteFkp);
            currentPapxIndex = 0;
            currentArraySize = fkp.size();
        } while (currentPageIndex < parPlcfLen);
    }

    private void initParagraphProperties() {
        int parOffset = this._fib.getFcPlcfbtePapx();
        int parPlcSize = this._fib.getLcbPlcfbtePapx();
        int charOffset = this._fib.getFcPlcfbteChpx();
        int charPlcSize = this._fib.getLcbPlcfbteChpx();
        PlexOfCps charPlcf = new PlexOfCps(charPlcSize, 4);
        PlexOfCps parPlcf = new PlexOfCps(parPlcSize, 4);
        int currentCharPage = LittleEndian.getInt((byte[])this._tableBuffer, (int)(charOffset + charPlcf.getStructOffset(0)));
        int charPlcfLen = charPlcf.length();
        int currentPageIndex = 0;
        byte[] fkp = new byte[512];
        System.arraycopy(this._mainDocument, currentCharPage * 512, fkp, 0, 512);
        CHPFormattedDiskPage cfkp = new CHPFormattedDiskPage(fkp);
        int currentChpxIndex = 0;
        int currentArraySize = cfkp.size();
        int arraySize = parPlcf.length();
        for (int x = 0; x < arraySize; ++x) {
            int PN = LittleEndian.getInt((byte[])this._tableBuffer, (int)(parOffset + parPlcf.getStructOffset(x)));
            fkp = new byte[512];
            System.arraycopy(this._mainDocument, PN * 512, fkp, 0, 512);
            PAPFormattedDiskPage pfkp = new PAPFormattedDiskPage(fkp);
            int crun = pfkp.size();
            block1: for (int y = 0; y < crun; ++y) {
                int fcStart = pfkp.getStart(y);
                int fcEnd = pfkp.getEnd(y);
                byte[] papx = pfkp.getGrpprl(y);
                this._listener.paragraph(new PapxNode(fcStart, fcEnd, papx));
                int charStart = 0;
                int charEnd = 0;
                do {
                    if (currentChpxIndex < currentArraySize) {
                        charStart = cfkp.getStart(currentChpxIndex);
                        charEnd = cfkp.getEnd(currentChpxIndex);
                        byte[] chpx = cfkp.getGrpprl(currentChpxIndex);
                        this._listener.characterRun(new ChpxNode(charStart, charEnd, chpx));
                        if (charEnd >= fcEnd) continue block1;
                        ++currentChpxIndex;
                        continue;
                    }
                    currentCharPage = LittleEndian.getInt((byte[])this._tableBuffer, (int)(charOffset + charPlcf.getStructOffset(++currentPageIndex)));
                    fkp = new byte[512];
                    System.arraycopy(this._mainDocument, currentCharPage * 512, fkp, 0, 512);
                    cfkp = new CHPFormattedDiskPage(fkp);
                    currentChpxIndex = 0;
                    currentArraySize = cfkp.size();
                } while (currentCharPage <= charPlcfLen + 1);
            }
        }
    }

    private void initParsingStates(int parOffset, PlexOfCps parPlcf, int charOffset, PlexOfCps charPlcf) {
        int currentCharPage = LittleEndian.getInt((byte[])this._tableBuffer, (int)(charOffset + charPlcf.getStructOffset(0)));
        byte[] fkp = new byte[512];
        System.arraycopy(this._mainDocument, currentCharPage * 512, fkp, 0, 512);
        CHPFormattedDiskPage cfkp = new CHPFormattedDiskPage(fkp);
        this._charParsingState = new ParsingState(currentCharPage, cfkp);
        int currentParPage = LittleEndian.getInt((byte[])this._tableBuffer, (int)(parOffset + parPlcf.getStructOffset(0)));
        fkp = new byte[512];
        System.arraycopy(this._mainDocument, currentParPage * 512, fkp, 0, 512);
        PAPFormattedDiskPage pfkp = new PAPFormattedDiskPage(fkp);
        this._parParsingState = new ParsingState(currentParPage, pfkp);
    }

    private void initSectionProperties() {
        SepxNode node;
        byte[] sepx;
        short sepxSize;
        int sepxStart;
        int sectionStart;
        int x;
        int ccpText = this._fib.getCcpText();
        int ccpFtn = this._fib.getCcpFtn();
        int fcMin = this._fib.getFcMin();
        int plcfsedFC = this._fib.getFcPlcfsed();
        int plcfsedSize = this._fib.getLcbPlcfsed();
        int parOffset = this._fib.getFcPlcfbtePapx();
        int parPlcSize = this._fib.getLcbPlcfbtePapx();
        int charOffset = this._fib.getFcPlcfbteChpx();
        int charPlcSize = this._fib.getLcbPlcfbteChpx();
        PlexOfCps charPlcf = new PlexOfCps(charPlcSize, 4);
        PlexOfCps parPlcf = new PlexOfCps(parPlcSize, 4);
        this.initParsingStates(parOffset, parPlcf, charOffset, charPlcf);
        PlexOfCps plcfsed = new PlexOfCps(plcfsedSize, 12);
        int arraySize = plcfsed.length();
        int start = fcMin;
        int end = fcMin + ccpText;
        int sectionEnd = 0;
        for (x = 0; x < arraySize; ++x) {
            sectionStart = LittleEndian.getInt((byte[])this._tableBuffer, (int)(plcfsedFC + plcfsed.getIntOffset(x))) + fcMin;
            sectionEnd = LittleEndian.getInt((byte[])this._tableBuffer, (int)(plcfsedFC + plcfsed.getIntOffset(x + 1))) + fcMin;
            sepxStart = LittleEndian.getInt((byte[])this._tableBuffer, (int)(plcfsedFC + plcfsed.getStructOffset(x) + 2));
            sepxSize = LittleEndian.getShort((byte[])this._mainDocument, (int)sepxStart);
            sepx = new byte[sepxSize];
            System.arraycopy(this._mainDocument, sepxStart + 2, sepx, 0, sepxSize);
            node = new SepxNode(x + 1, sectionStart, sectionEnd, sepx);
            this._listener.bodySection(node);
            this.initParagraphProperties(parOffset, parPlcf, charOffset, charPlcf, sectionStart, Math.min(end, sectionEnd));
            if (sectionEnd > end) break;
        }
        while (x < arraySize) {
            sectionStart = LittleEndian.getInt((byte[])this._tableBuffer, (int)(plcfsedFC + plcfsed.getIntOffset(x))) + fcMin;
            sectionEnd = LittleEndian.getInt((byte[])this._tableBuffer, (int)(plcfsedFC + plcfsed.getIntOffset(x + 1))) + fcMin;
            sepxStart = LittleEndian.getInt((byte[])this._tableBuffer, (int)(plcfsedFC + plcfsed.getStructOffset(x) + 2));
            sepxSize = LittleEndian.getShort((byte[])this._mainDocument, (int)sepxStart);
            sepx = new byte[sepxSize];
            System.arraycopy(this._mainDocument, sepxStart + 2, sepx, 0, sepxSize);
            node = new SepxNode(x + 1, sectionStart, sectionEnd, sepx);
            this._listener.hdrSection(node);
            this.initParagraphProperties(parOffset, parPlcf, charOffset, charPlcf, Math.max(sectionStart, end), sectionEnd);
            ++x;
        }
        this._listener.endSections();
    }

    private void initDocumentProperties() {
        int pos = this._fib.getFcDop();
        int size = this._fib.getLcbDop();
        byte[] dopArray = new byte[size];
        System.arraycopy(this._tableBuffer, pos, dopArray, 0, size);
        this._listener.document(new DocumentProperties(dopArray));
    }

    private void createStyleSheet() {
        int stshIndex = this._fib.getFcStshf();
        int stshSize = this._fib.getLcbStshf();
        byte[] stsh = new byte[stshSize];
        System.arraycopy(this._tableBuffer, stshIndex, stsh, 0, stshSize);
        this._listener.styleSheet(new StyleSheet(stsh));
    }

    private void createListTables() {
        int lfoOffset = this._fib.getFcPlfLfo();
        int lfoSize = this._fib.getLcbPlfLfo();
        byte[] plflfo = new byte[lfoSize];
        System.arraycopy(this._tableBuffer, lfoOffset, plflfo, 0, lfoSize);
        int lstOffset = this._fib.getFcPlcfLst();
        int lstSize = this._fib.getLcbPlcfLst();
        if (lstOffset > 0 && lstSize > 0) {
            lstSize = lfoOffset - lstOffset;
            byte[] plcflst = new byte[lstSize];
            System.arraycopy(this._tableBuffer, lstOffset, plcflst, 0, lstSize);
            this._listener.lists(new ListTables(plcflst, plflfo));
        }
    }

    private void createFontTable() {
        int fontTableIndex = this._fib.getFcSttbfffn();
        int fontTableSize = this._fib.getLcbSttbfffn();
        byte[] fontTable = new byte[fontTableSize];
        System.arraycopy(this._tableBuffer, fontTableIndex, fontTable, 0, fontTableSize);
        this._listener.fonts(new FontTable(fontTable));
    }
}

