/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.mina;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.vysper.mina.StanzaLoggingFilter;
import org.apache.vysper.mina.XmppIoHandlerAdapter;
import org.apache.vysper.mina.codec.XMPPProtocolCodecFactory;
import org.apache.vysper.xmpp.server.Endpoint;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;

public class TCPEndpoint
implements Endpoint {
    private ServerRuntimeContext serverRuntimeContext;
    private int port = 5222;
    private SocketAcceptor acceptor;
    private DefaultIoFilterChainBuilder filterChainBuilder;

    public DefaultIoFilterChainBuilder getFilterChainBuilder() {
        return this.filterChainBuilder;
    }

    public void setServerRuntimeContext(ServerRuntimeContext serverRuntimeContext) {
        this.serverRuntimeContext = serverRuntimeContext;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void start() throws IOException {
        NioSocketAcceptor acceptor = new NioSocketAcceptor();
        DefaultIoFilterChainBuilder filterChainBuilder = new DefaultIoFilterChainBuilder();
        filterChainBuilder.addLast("xmppCodec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new XMPPProtocolCodecFactory()));
        filterChainBuilder.addLast("loggingFilter", (IoFilter)new StanzaLoggingFilter());
        acceptor.setFilterChainBuilder((IoFilterChainBuilder)filterChainBuilder);
        XmppIoHandlerAdapter adapter = new XmppIoHandlerAdapter();
        adapter.setServerRuntimeContext(this.serverRuntimeContext);
        acceptor.setHandler((IoHandler)adapter);
        acceptor.setReuseAddress(true);
        acceptor.bind((SocketAddress)new InetSocketAddress(this.port));
        this.acceptor = acceptor;
    }

    public void stop() {
        this.acceptor.unbind();
        this.acceptor.dispose();
    }
}

