/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.compound;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.compound.CopyStrategy;
import net.sf.ehcache.store.compound.ElementSubstituteFilter;
import net.sf.ehcache.store.compound.HashEntry;
import net.sf.ehcache.store.compound.IdentityElementSubstituteFactory;
import net.sf.ehcache.store.compound.InternalElementSubstituteFactory;
import net.sf.ehcache.store.compound.Segment;
import net.sf.ehcache.writer.CacheWriterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompoundStore
extends AbstractStore {
    private static final int FFFFCD7D = -12931;
    private static final int FIFTEEN = 15;
    private static final int TEN = 10;
    private static final int THREE = 3;
    private static final int SIX = 6;
    private static final int FOURTEEN = 14;
    private static final int SIXTEEN = 16;
    private static final int MAXIMUM_CAPACITY = Integer.highestOneBit(Integer.MAX_VALUE);
    private static final int RETRIES_BEFORE_LOCK = 2;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int DEFAULT_SEGMENT_COUNT = 64;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final InternalElementSubstituteFactory<?> primary;
    private final Random rndm = new Random();
    private final Segment[] segments;
    private final int segmentShift;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.STATUS_UNINITIALISED);
    private volatile CacheLockProvider lockProvider;
    private volatile Set<Object> keySet;

    public CompoundStore(InternalElementSubstituteFactory<?> primary, boolean copyOnRead, boolean copyOnWrite, CopyStrategy copyStrategy) {
        this(primary, primary instanceof IdentityElementSubstituteFactory ? (IdentityElementSubstituteFactory)primary : null, copyOnRead, copyOnWrite, copyStrategy);
    }

    public CompoundStore(InternalElementSubstituteFactory<?> primary, IdentityElementSubstituteFactory identity) {
        this(primary, identity, false, false, null);
    }

    public CompoundStore(InternalElementSubstituteFactory<?> primary, IdentityElementSubstituteFactory identity, boolean copyOnRead, boolean copyOnWrite, CopyStrategy copyStrategy) {
        this.segments = new Segment[64];
        this.segmentShift = Integer.numberOfLeadingZeros(this.segments.length - 1);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(16, 0.75f, primary, identity, copyOnRead, copyOnWrite, copyStrategy);
        }
        this.primary = primary;
        primary.bind(this);
        this.status.set(Status.STATUS_ALIVE);
    }

    @Override
    public boolean put(Element element) {
        if (element == null) {
            return false;
        }
        Object key = element.getObjectKey();
        int hash = CompoundStore.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, element, false) == null;
    }

    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) {
        boolean result = this.put(element);
        if (writerManager != null) {
            writerManager.put(element);
        }
        return result;
    }

    @Override
    public Element get(Object key) {
        if (key == null) {
            return null;
        }
        int hash = CompoundStore.hash(key.hashCode());
        return this.segmentFor(hash).get(key, hash);
    }

    @Override
    public Element getQuiet(Object key) {
        return this.get(key);
    }

    public Object unretrievedGet(Object key) {
        if (key == null) {
            return null;
        }
        int hash = CompoundStore.hash(key.hashCode());
        return this.segmentFor(hash).unretrievedGet(key, hash);
    }

    public boolean putRawIfAbsent(Object key, Object encoded) {
        int hash = CompoundStore.hash(key.hashCode());
        return this.segmentFor(hash).putRawIfAbsent(key, hash, encoded);
    }

    @Override
    public Object[] getKeyArray() {
        return this.keySet().toArray();
    }

    public Set<Object> keySet() {
        if (this.keySet != null) {
            return this.keySet;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    @Override
    public Element remove(Object key) {
        if (key == null) {
            return null;
        }
        int hash = CompoundStore.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, null);
    }

    @Override
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) {
        Element removed = this.remove(key);
        if (writerManager != null) {
            writerManager.remove(new CacheEntry(key, removed));
        }
        return removed;
    }

    @Override
    public void removeAll() {
        for (Segment s : this.segments) {
            s.clear();
        }
    }

    @Override
    public void dispose() {
        if (this.status.compareAndSet(Status.STATUS_ALIVE, Status.STATUS_SHUTDOWN)) {
            this.primary.unbind(this);
        }
    }

    @Override
    public int getSize() {
        Segment[] segs = this.segments;
        long size = -1L;
        for (int k = 0; k < 2 && (size = CompoundStore.volatileSize(segs)) < 0L; ++k) {
        }
        if (size < 0L) {
            size = CompoundStore.lockedSize(segs);
        }
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    private static long volatileSize(Segment[] segs) {
        int i;
        int[] mc = new int[segs.length];
        long check = 0L;
        long sum = 0L;
        int mcsum = 0;
        for (i = 0; i < segs.length; ++i) {
            sum += (long)segs[i].count;
            mc[i] = segs[i].modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segs.length; ++i) {
                check += (long)segs[i].count;
                if (mc[i] == segs[i].modCount) continue;
                return -1L;
            }
        }
        if (check == sum) {
            return sum;
        }
        return -1L;
    }

    private static long lockedSize(Segment[] segs) {
        int i;
        long size = 0L;
        for (i = 0; i < segs.length; ++i) {
            segs[i].readLock().lock();
        }
        for (i = 0; i < segs.length; ++i) {
            size += (long)segs[i].count;
        }
        for (i = 0; i < segs.length; ++i) {
            segs[i].readLock().unlock();
        }
        return size;
    }

    @Override
    public Status getStatus() {
        return this.status.get();
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = CompoundStore.hash(key.hashCode());
        return this.segmentFor(hash).containsKey(key, hash);
    }

    @Override
    public Object getInternalContext() {
        if (this.lockProvider != null) {
            return this.lockProvider;
        }
        this.lockProvider = new LockProvider();
        return this.lockProvider;
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        Object key = element.getObjectKey();
        int hash = CompoundStore.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, element, true);
    }

    @Override
    public Element removeElement(Element element) throws NullPointerException {
        Object key = element.getObjectKey();
        int hash = CompoundStore.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, element);
    }

    @Override
    public boolean replace(Element old, Element element) throws NullPointerException, IllegalArgumentException {
        Object key = element.getObjectKey();
        int hash = CompoundStore.hash(key.hashCode());
        return this.segmentFor(hash).replace(key, hash, old, element);
    }

    @Override
    public Element replace(Element element) throws NullPointerException {
        Object key = element.getObjectKey();
        int hash = CompoundStore.hash(key.hashCode());
        return this.segmentFor(hash).replace(key, hash, element);
    }

    public boolean fault(Object key, Object expect, Object fault) {
        int hash = CompoundStore.hash(key.hashCode());
        return this.segmentFor(hash).fault(key, hash, expect, fault);
    }

    public boolean evict(Object key, Object substitute) {
        int hash = CompoundStore.hash(key.hashCode());
        return this.segmentFor(hash).evict(key, hash, substitute);
    }

    public <T> List<T> getRandomSample(ElementSubstituteFilter<T> factory, int sampleSize, Object keyHint) {
        ArrayList sampled = new ArrayList(sampleSize);
        int randomHash = this.rndm.nextInt();
        int segmentStart = keyHint == null ? randomHash >>> this.segmentShift : CompoundStore.hash(keyHint.hashCode()) >>> this.segmentShift;
        int segmentIndex = segmentStart;
        do {
            this.segments[segmentIndex].addRandomSample(factory, sampleSize, sampled, randomHash);
        } while (sampled.size() < sampleSize && (segmentIndex = segmentIndex + 1 & this.segments.length - 1) != segmentStart);
        return sampled;
    }

    private static int hash(int hash) {
        int spread = hash;
        spread += spread << 15 ^ 0xFFFFCD7D;
        spread ^= spread >>> 10;
        spread += spread << 3;
        spread ^= spread >>> 6;
        spread += (spread << 2) + (spread << 14);
        return spread ^ spread >>> 16;
    }

    private Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift];
    }

    private static final class ReadWriteLockSync
    implements Sync {
        private final ReentrantReadWriteLock lock;

        private ReadWriteLockSync(ReentrantReadWriteLock lock) {
            this.lock = lock;
        }

        public void lock(LockType type) {
            switch (type) {
                case READ: {
                    this.lock.readLock().lock();
                    break;
                }
                case WRITE: {
                    this.lock.writeLock().lock();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("We don't support any other lock type than READ or WRITE!");
                }
            }
        }

        public boolean tryLock(LockType type, long msec) throws InterruptedException {
            switch (type) {
                case READ: {
                    return this.lock.readLock().tryLock(msec, TimeUnit.MILLISECONDS);
                }
                case WRITE: {
                    return this.lock.writeLock().tryLock(msec, TimeUnit.MILLISECONDS);
                }
            }
            throw new IllegalArgumentException("We don't support any other lock type than READ or WRITE!");
        }

        public void unlock(LockType type) {
            switch (type) {
                case READ: {
                    this.lock.readLock().unlock();
                    break;
                }
                case WRITE: {
                    this.lock.writeLock().unlock();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("We don't support any other lock type than READ or WRITE!");
                }
            }
        }

        public boolean isHeldByCurrentThread(LockType type) {
            switch (type) {
                case READ: {
                    throw new UnsupportedOperationException("Querying of read lock is not supported.");
                }
                case WRITE: {
                    return this.lock.isWriteLockedByCurrentThread();
                }
            }
            throw new IllegalArgumentException("We don't support any other lock type than READ or WRITE!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyIterator
    extends HashIterator
    implements Iterator<Object> {
        private KeyIterator() {
        }

        @Override
        public Object next() {
            return super.nextEntry().key;
        }
    }

    abstract class HashIterator {
        private int nextSegmentIndex;
        private Iterator<HashEntry> currentIterator;

        HashIterator() {
            this.nextSegmentIndex = CompoundStore.this.segments.length;
            while (this.nextSegmentIndex > 0) {
                --this.nextSegmentIndex;
                this.currentIterator = CompoundStore.this.segments[this.nextSegmentIndex].hashIterator();
                if (!this.currentIterator.hasNext()) continue;
                return;
            }
        }

        public boolean hasNext() {
            if (this.currentIterator == null) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            while (this.nextSegmentIndex > 0) {
                --this.nextSegmentIndex;
                this.currentIterator = CompoundStore.this.segments[this.nextSegmentIndex].hashIterator();
                if (!this.currentIterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        protected HashEntry nextEntry() {
            Object item = null;
            if (this.currentIterator == null) {
                return null;
            }
            if (this.currentIterator.hasNext()) {
                return this.currentIterator.next();
            }
            while (this.nextSegmentIndex > 0) {
                --this.nextSegmentIndex;
                this.currentIterator = CompoundStore.this.segments[this.nextSegmentIndex].hashIterator();
                if (!this.currentIterator.hasNext()) continue;
                return this.currentIterator.next();
            }
            return null;
        }

        public void remove() {
            this.currentIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LockProvider
    implements CacheLockProvider {
        private LockProvider() {
        }

        @Override
        public Sync[] getAndWriteLockAllSyncForKeys(Object ... keys) {
            Map<Segment, AtomicInteger> segs = this.getSegmentsFor(keys);
            ArrayList<ReadWriteLockSync> ordered = new ArrayList<ReadWriteLockSync>();
            for (Segment s : CompoundStore.this.segments) {
                if (!segs.containsKey(s)) continue;
                AtomicInteger counter = segs.get(s);
                while (counter.getAndDecrement() > 0) {
                    s.writeLock().lock();
                }
                ordered.add(new ReadWriteLockSync(s));
            }
            return ordered.toArray(new Sync[ordered.size()]);
        }

        @Override
        public Sync[] getAndWriteLockAllSyncForKeys(long timeout, Object ... keys) throws TimeoutException {
            Map<Segment, AtomicInteger> segs = this.getSegmentsFor(keys);
            ArrayList<ReentrantReadWriteLock.WriteLock> acquiredLocks = new ArrayList<ReentrantReadWriteLock.WriteLock>();
            ReentrantReadWriteLock.WriteLock unheldLock = null;
            ArrayList<ReadWriteLockSync> ordered = new ArrayList<ReadWriteLockSync>();
            for (Segment s : CompoundStore.this.segments) {
                boolean lockHeld;
                if (!segs.containsKey(s)) continue;
                try {
                    ReentrantReadWriteLock.WriteLock writeLock = s.writeLock();
                    lockHeld = writeLock.tryLock(timeout, TimeUnit.MILLISECONDS);
                    if (lockHeld) {
                        AtomicInteger counter = segs.get(s);
                        while (counter.decrementAndGet() > 0) {
                            s.writeLock().lock();
                            acquiredLocks.add(writeLock);
                        }
                        acquiredLocks.add(writeLock);
                    } else {
                        unheldLock = writeLock;
                    }
                }
                catch (InterruptedException e) {
                    lockHeld = false;
                }
                if (!lockHeld) {
                    for (int i = acquiredLocks.size() - 1; i >= 0; --i) {
                        ReentrantReadWriteLock.WriteLock writeLock = (ReentrantReadWriteLock.WriteLock)acquiredLocks.get(i);
                        writeLock.unlock();
                    }
                    throw new TimeoutException("could not acquire all locks in " + timeout + " ms - did not get " + unheldLock);
                }
                ordered.add(new ReadWriteLockSync(s));
            }
            return ordered.toArray(new Sync[ordered.size()]);
        }

        @Override
        public Sync getSyncForKey(Object key) {
            int hash = key == null ? 0 : CompoundStore.hash(key.hashCode());
            return new ReadWriteLockSync(CompoundStore.this.segmentFor(hash));
        }

        @Override
        public void unlockWriteLockForAllKeys(Object ... keys) {
            for (Map.Entry<Segment, AtomicInteger> entry : this.getSegmentsFor(keys).entrySet()) {
                while (entry.getValue().getAndDecrement() > 0) {
                    entry.getKey().writeLock().unlock();
                }
            }
        }

        private Map<Segment, AtomicInteger> getSegmentsFor(Object ... keys) {
            HashMap<Segment, AtomicInteger> segs = new HashMap<Segment, AtomicInteger>();
            for (Object k : keys) {
                Segment key = CompoundStore.this.segmentFor(CompoundStore.hash(k.hashCode()));
                if (segs.containsKey(key)) {
                    ((AtomicInteger)segs.get(key)).getAndIncrement();
                    continue;
                }
                segs.put(key, new AtomicInteger(1));
            }
            return segs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeySet
    extends AbstractSet<Object> {
        KeySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return CompoundStore.this.getSize();
        }

        @Override
        public boolean contains(Object o) {
            return CompoundStore.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return CompoundStore.this.remove(o) != null;
        }

        @Override
        public void clear() {
            CompoundStore.this.removeAll();
        }

        @Override
        public Object[] toArray() {
            ArrayList<Object> c = new ArrayList<Object>();
            for (Object object : this) {
                c.add(object);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList<Object> c = new ArrayList<Object>();
            for (Object object : this) {
                c.add(object);
            }
            return c.toArray(a);
        }
    }
}

