/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.monitor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ClouderaManagerClusterConfigurationMonitor;

public abstract class AbstractConfigurationStore {
    static final String CLUSTERS_DATA_DIR_NAME = ClouderaManagerClusterConfigurationMonitor.getType().toLowerCase(Locale.ROOT) + "-clusters";
    protected static final ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);
    protected GatewayConfig gatewayConfig;

    public AbstractConfigurationStore(GatewayConfig gatewayConfig) {
        this.gatewayConfig = gatewayConfig;
    }

    public void remove(String address, String cluster) {
        File persisted = this.getPersistenceFile(address, cluster);
        if (persisted.exists() && !persisted.delete()) {
            log.failedToRemovPersistedClusterMonitorData(ClouderaManagerClusterConfigurationMonitor.getType(), persisted.getAbsolutePath());
        }
    }

    protected abstract File getPersistenceFile(String var1, String var2);

    protected String getMonitorType() {
        return ClouderaManagerClusterConfigurationMonitor.getType();
    }

    protected File getPersistenceFile(String address, String clusterName, String ext) {
        String fileName = address.replace(":", "_").replace("/", "_") + "-" + clusterName + "." + ext;
        return this.getPersistenceDir().resolve(fileName).toFile();
    }

    protected Path getPersistenceDir() {
        Path persistenceDir = null;
        Path dataDir = Paths.get(this.gatewayConfig.getGatewayDataDir(), new String[0]);
        if (Files.exists(dataDir, new LinkOption[0])) {
            Path clustersDir = dataDir.resolve(CLUSTERS_DATA_DIR_NAME);
            if (Files.notExists(clustersDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(clustersDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    log.failedToCreatePersistenceDirectory(clustersDir.toAbsolutePath().toString());
                }
            }
            persistenceDir = clustersDir;
        }
        return persistenceDir;
    }
}

