/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.identityasserter.hadoop.groups.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.identityasserter.common.filter.AbstractIdentityAsserterDeploymentContributor;
import org.apache.knox.gateway.identityasserter.hadoop.groups.filter.HadoopGroupProviderFilter;
import org.apache.knox.gateway.identityasserter.hadoop.groups.filter.HadoopGroupProviderMessages;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;

public class HadoopGroupProviderDeploymentContributor
extends AbstractIdentityAsserterDeploymentContributor {
    public static final String HADOOP_GROUP_PROVIDER = "HadoopGroupProvider";
    private static final HadoopGroupProviderMessages LOG = (HadoopGroupProviderMessages)MessagesFactory.get(HadoopGroupProviderMessages.class);
    static final String CENTRAL_GROUP_CONFIG_PREFIX_PARAM_NAME = "CENTRAL_GROUP_CONFIG_PREFIX";

    public String getName() {
        return HADOOP_GROUP_PROVIDER;
    }

    protected String getFilterClassname() {
        return HadoopGroupProviderFilter.class.getName();
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        ArrayList<FilterParamDescriptor> filterParams = params == null ? new ArrayList<FilterParamDescriptor>() : new ArrayList<FilterParamDescriptor>(params);
        List<FilterParamDescriptor> groupMappingParamsList = this.getParamsFromGatewaySiteWithCentralGroupConfigPrefix(provider, context, resource);
        filterParams.addAll(groupMappingParamsList);
        provider.getParams().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith(CENTRAL_GROUP_CONFIG_PREFIX_PARAM_NAME)).forEach(entry -> {
            filterParams.removeIf(filterParam -> filterParam.name().equals(entry.getKey()));
            filterParams.add(this.createFilterParam(resource, (String)entry.getKey(), (String)entry.getValue()));
        });
        resource.addFilter().name(this.getName()).role(this.getRole()).impl(this.getFilterClassname()).params(filterParams);
    }

    private FilterParamDescriptor createFilterParam(ResourceDescriptor resource, String name, String value) {
        return resource.createFilterParam().name(name.toLowerCase(Locale.ROOT)).value(value);
    }

    private List<FilterParamDescriptor> getParamsFromGatewaySiteWithCentralGroupConfigPrefix(Provider provider, DeploymentContext context, ResourceDescriptor resource) {
        ArrayList<FilterParamDescriptor> groupMappingParamsList = new ArrayList<FilterParamDescriptor>();
        Map providerParams = provider.getParams();
        String prefix = (String)providerParams.get(CENTRAL_GROUP_CONFIG_PREFIX_PARAM_NAME);
        if (prefix != null && !prefix.isEmpty()) {
            GatewayConfig gatewayConfig;
            Map groupMappingParams;
            if (!prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            Map map = groupMappingParams = (gatewayConfig = context.getGatewayConfig()) == null ? null : ((Configuration)gatewayConfig).getPropsWithPrefix(prefix);
            if (groupMappingParams != null && !groupMappingParams.isEmpty()) {
                LOG.groupMappingFound();
                for (Map.Entry entry : groupMappingParams.entrySet()) {
                    groupMappingParamsList.add(this.createFilterParam(resource, (String)entry.getKey(), (String)entry.getValue()));
                }
            }
        }
        return groupMappingParamsList;
    }

    public List<FilterParamDescriptor> buildFilterInitParms(Provider provider, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        ArrayList<FilterParamDescriptor> filterInitParams = params == null ? new ArrayList<FilterParamDescriptor>() : new ArrayList<FilterParamDescriptor>(params);
        provider.getParams().forEach((paramName, paramValue) -> filterInitParams.add(this.createFilterParam(resource, (String)paramName, (String)paramValue)));
        return filterInitParams;
    }
}

