/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa.commands;

import net.sf.ehcache.Element;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.SoftLock;
import net.sf.ehcache.transaction.SoftLockID;
import net.sf.ehcache.transaction.SoftLockManager;
import net.sf.ehcache.transaction.xa.OptimisticLockFailureException;
import net.sf.ehcache.transaction.xa.XidTransactionID;
import net.sf.ehcache.transaction.xa.commands.Command;

public abstract class AbstractStoreCommand
implements Command {
    private final Element oldElement;
    private final Element newElement;
    private Element softLockedElement;

    public AbstractStoreCommand(Element oldElement, Element newElement) {
        this.newElement = newElement;
        this.oldElement = oldElement;
    }

    protected Element getOldElement() {
        return this.oldElement;
    }

    protected Element getNewElement() {
        return this.newElement;
    }

    @Override
    public boolean prepare(Store store, SoftLockManager softLockManager, XidTransactionID transactionId, ElementValueComparator comparator) {
        Object objectKey = this.getObjectKey();
        boolean wasPinned = store.isPinned(objectKey);
        SoftLockID softLockId = softLockManager.createSoftLockID(transactionId, objectKey, this.newElement, this.oldElement, wasPinned);
        SoftLock softLock = softLockManager.findSoftLockById(softLockId);
        this.softLockedElement = this.createElement(objectKey, softLockId, store, wasPinned);
        softLock.lock();
        softLock.freeze();
        if (this.oldElement == null) {
            Element previousElement = store.putIfAbsent(this.softLockedElement);
            if (previousElement != null) {
                softLock.unfreeze();
                softLock.unlock();
                this.softLockedElement = null;
                if (!wasPinned) {
                    store.setPinned(softLockId.getKey(), false);
                }
                throw new OptimisticLockFailureException();
            }
        } else {
            boolean replaced = store.replace(this.oldElement, this.softLockedElement, comparator);
            if (!replaced) {
                softLock.unfreeze();
                softLock.unlock();
                this.softLockedElement = null;
                if (!wasPinned) {
                    store.setPinned(softLockId.getKey(), false);
                }
                throw new OptimisticLockFailureException();
            }
        }
        return true;
    }

    @Override
    public void rollback(Store underlyingStore, SoftLockManager softLockManager, ElementValueComparator comparator) {
        SoftLockID softLockId = (SoftLockID)this.softLockedElement.getObjectValue();
        if (!softLockId.wasPinned()) {
            underlyingStore.setPinned(softLockId.getKey(), false);
        }
        if (this.oldElement == null) {
            underlyingStore.removeElement(this.softLockedElement, comparator);
        } else {
            underlyingStore.replace(this.softLockedElement, this.oldElement, comparator);
        }
        SoftLock softLock = softLockManager.findSoftLockById(softLockId);
        softLock.unfreeze();
        softLock.unlock();
        this.softLockedElement = null;
    }

    private Element createElement(Object key, SoftLockID softLockId, Store store, boolean wasPinned) {
        Element element = new Element(key, (Object)softLockId);
        element.setEternal(true);
        if (!wasPinned) {
            store.setPinned(key, true);
        }
        return element;
    }
}

