/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.svcregfunc.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;
import org.apache.knox.gateway.svcregfunc.api.ServiceAddressFunctionDescriptor;
import org.apache.knox.gateway.svcregfunc.impl.ServiceRegistryFunctionProcessorBase;
import org.apache.knox.gateway.util.urltemplate.Host;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Port;
import org.apache.knox.gateway.util.urltemplate.Template;

public class ServiceAddressFunctionProcessor
extends ServiceRegistryFunctionProcessorBase<ServiceAddressFunctionDescriptor>
implements UrlRewriteFunctionProcessor<ServiceAddressFunctionDescriptor> {
    public String name() {
        return "serviceAddr";
    }

    public List<String> resolve(UrlRewriteContext context, List<String> parameters) throws Exception {
        ArrayList<String> results = null;
        if (parameters != null) {
            results = new ArrayList<String>(parameters.size());
            for (String parameter : parameters) {
                parameter = this.resolve(parameter);
                results.add(parameter);
            }
        }
        return results;
    }

    public String resolve(String parameter) throws Exception {
        String addr = parameter;
        String url = this.lookupServiceUrl(parameter);
        if (url != null) {
            Template template = Parser.parseLiteral((String)url);
            Host host = template.getHost();
            String hostStr = null;
            if (host != null) {
                hostStr = host.getFirstValue().getPattern();
            }
            Port port = template.getPort();
            String portStr = null;
            if (port != null) {
                portStr = port.getFirstValue().getPattern();
            }
            if (hostStr != null && portStr != null) {
                addr = hostStr + ":" + portStr;
            } else if (host != null && port == null) {
                addr = hostStr;
            } else if (host == null && port != null) {
                addr = ":" + portStr;
            }
        }
        return addr;
    }
}

