/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.graphite;

import com.codahale.metrics.graphite.GraphiteSanitize;
import com.codahale.metrics.graphite.GraphiteSender;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.net.SocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graphite
implements GraphiteSender {
    private final String hostname;
    private final int port;
    private final InetSocketAddress address;
    private final SocketFactory socketFactory;
    private final Charset charset;
    private Socket socket;
    private Writer writer;
    private int failures;
    private static final Logger LOGGER = LoggerFactory.getLogger(Graphite.class);

    public Graphite(String hostname, int port) {
        this(hostname, port, SocketFactory.getDefault());
    }

    public Graphite(String hostname, int port, SocketFactory socketFactory) {
        this(hostname, port, socketFactory, StandardCharsets.UTF_8);
    }

    public Graphite(String hostname, int port, SocketFactory socketFactory, Charset charset) {
        this.hostname = hostname;
        this.port = port;
        this.address = null;
        this.socketFactory = socketFactory;
        this.charset = charset;
    }

    public Graphite(InetSocketAddress address) {
        this(address, SocketFactory.getDefault());
    }

    public Graphite(InetSocketAddress address, SocketFactory socketFactory) {
        this(address, socketFactory, StandardCharsets.UTF_8);
    }

    public Graphite(InetSocketAddress address, SocketFactory socketFactory, Charset charset) {
        this.hostname = null;
        this.port = -1;
        this.address = address;
        this.socketFactory = socketFactory;
        this.charset = charset;
    }

    @Override
    public void connect() throws IllegalStateException, IOException {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        InetSocketAddress address = this.address;
        if (address == null) {
            address = new InetSocketAddress(this.hostname, this.port);
        }
        if (address.getAddress() == null && (address = new InetSocketAddress(address.getHostName(), address.getPort())).getAddress() == null) {
            throw new UnknownHostException(address.getHostName());
        }
        this.socket = this.socketFactory.createSocket(address.getAddress(), address.getPort());
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), this.charset));
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    @Override
    public void send(String name, String value, long timestamp) throws IOException {
        try {
            this.writer.write(this.sanitize(name));
            this.writer.write(32);
            this.writer.write(this.sanitize(value));
            this.writer.write(32);
            this.writer.write(Long.toString(timestamp));
            this.writer.write(10);
            this.failures = 0;
        }
        catch (IOException e) {
            ++this.failures;
            throw e;
        }
    }

    @Override
    public int getFailures() {
        return this.failures;
    }

    @Override
    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException ex) {
            LOGGER.debug("Error closing writer", (Throwable)ex);
        }
        finally {
            this.writer = null;
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException ex) {
            LOGGER.debug("Error closing socket", (Throwable)ex);
        }
        finally {
            this.socket = null;
        }
    }

    protected String sanitize(String s) {
        return GraphiteSanitize.sanitize(s);
    }
}

