/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class JsonPath {
    public static Expression compile(String expression) {
        return new Expression(expression);
    }

    public static class Segment {
        private Type type;
        private String field;
        private int index;

        Segment(Type type) {
            this.type = type;
            this.field = null;
            this.index = -1;
        }

        Segment(String field) {
            this.type = Type.FIELD;
            this.field = field;
            this.index = -1;
        }

        Segment(int index) {
            this.type = Type.INDEX;
            this.field = null;
            this.index = index;
        }

        public Type getType() {
            return this.type;
        }

        public String getField() {
            return this.field;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "JsonPath.Segment{type=" + (Object)((Object)this.getType()) + ",field=" + this.getField() + ",index=" + this.getIndex() + "}";
        }

        public static enum Type {
            ROOT,
            FIELD,
            INDEX,
            WILD,
            GLOB;

        }
    }

    public static class Expression {
        private List<Segment> segments;

        Expression(String expression) {
            if (expression == null || !expression.startsWith("$")) {
                throw new IllegalArgumentException(expression);
            }
            this.segments = this.parse(expression);
        }

        public Segment[] getSegments() {
            Segment[] array = null;
            if (this.segments != null) {
                array = new Segment[this.segments.size()];
                this.segments.toArray(array);
            }
            return array;
        }

        private List<Segment> parse(String expression) {
            boolean insideBrackets = false;
            boolean expectChild = false;
            boolean foundChild = false;
            ArrayList<Segment> list = null;
            StringTokenizer parser = new StringTokenizer(expression, "$.[]()@?:,", true);
            String currToken = null;
            block9: while (parser.hasMoreTokens()) {
                Segment segment;
                String prevToken = currToken;
                currToken = insideBrackets ? parser.nextToken("$[]()@?:,").trim() : parser.nextToken("$.[]()@?:,").trim();
                char c = currToken.charAt(0);
                switch (c) {
                    case '$': {
                        if (list != null) {
                            throw new IllegalArgumentException(expression);
                        }
                        list = new ArrayList<Segment>();
                        segment = new Segment(Segment.Type.ROOT);
                        list.add(segment);
                        continue block9;
                    }
                    case '.': {
                        if (expectChild) {
                            if (".".equals(prevToken)) {
                                segment = new Segment(Segment.Type.GLOB);
                                if (list == null) {
                                    throw new IllegalArgumentException(expression);
                                }
                                list.add(segment);
                                expectChild = true;
                                foundChild = false;
                                continue block9;
                            }
                            throw new IllegalArgumentException(expression);
                        }
                        expectChild = true;
                        foundChild = false;
                        continue block9;
                    }
                    case '[': {
                        if (expectChild) {
                            throw new IllegalArgumentException(expression);
                        }
                        insideBrackets = true;
                        expectChild = true;
                        foundChild = false;
                        continue block9;
                    }
                    case ']': {
                        if (!foundChild) {
                            throw new IllegalArgumentException(expression);
                        }
                        insideBrackets = false;
                        expectChild = false;
                        foundChild = false;
                        continue block9;
                    }
                    case '(': 
                    case ')': 
                    case ',': 
                    case ':': 
                    case '?': 
                    case '@': {
                        throw new IllegalArgumentException(expression);
                    }
                }
                if (!expectChild) {
                    throw new IllegalArgumentException(expression);
                }
                if (Character.isDigit(c)) {
                    try {
                        segment = new Segment(Integer.parseInt(currToken));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(expression, e);
                    }
                } else if ("*".equals(currToken)) {
                    segment = new Segment(Segment.Type.WILD);
                } else if ("**".equals(currToken)) {
                    segment = new Segment(Segment.Type.GLOB);
                } else {
                    if (currToken.startsWith("'")) {
                        currToken = currToken.substring(1);
                    }
                    if (currToken.endsWith("'")) {
                        currToken = currToken.substring(0, currToken.length() - 1);
                    }
                    segment = new Segment(currToken);
                }
                if (list == null) {
                    throw new IllegalArgumentException(expression);
                }
                list.add(segment);
                expectChild = false;
                foundChild = true;
            }
            if (expectChild && !foundChild) {
                throw new IllegalArgumentException(expression);
            }
            return list;
        }

        public List<Match> evaluate(JsonNode root) {
            ArrayList<Match> oldMatches = new ArrayList<Match>();
            ArrayList<Match> newMatches = new ArrayList<Match>();
            if (root != null) {
                for (Segment seg : this.segments) {
                    if (Segment.Type.ROOT == seg.getType()) {
                        oldMatches.add(new Match(null, this.segments.get(0), root, null, -1));
                        continue;
                    }
                    block11: for (Match oldMatch : oldMatches) {
                        JsonNode parent = oldMatch.getNode();
                        switch (seg.getType()) {
                            case FIELD: {
                                JsonNode child;
                                if (JsonNodeType.OBJECT != oldMatch.getNode().getNodeType() || (child = oldMatch.getNode().get(seg.getField())) == null) continue block11;
                                newMatches.add(new Match(oldMatch, seg, child, seg.getField()));
                                continue block11;
                            }
                            case INDEX: {
                                JsonNode child;
                                if (JsonNodeType.ARRAY != oldMatch.getNode().getNodeType() || (child = oldMatch.getNode().get(seg.getIndex())) == null) continue block11;
                                newMatches.add(new Match(oldMatch, seg, child, seg.getIndex()));
                                continue block11;
                            }
                            case GLOB: {
                                newMatches.add(oldMatch);
                            }
                            case WILD: {
                                switch (parent.getNodeType()) {
                                    case OBJECT: {
                                        Match newMatch;
                                        Iterator fields = parent.fields();
                                        while (fields.hasNext()) {
                                            Map.Entry field = (Map.Entry)fields.next();
                                            newMatch = new Match(oldMatch, seg, (JsonNode)field.getValue(), (String)field.getKey());
                                            newMatches.add(newMatch);
                                            if (seg.getType() != Segment.Type.GLOB) continue;
                                            Expression.addAllChildren(oldMatch, newMatches, (JsonNode)field.getValue());
                                        }
                                        break;
                                    }
                                    case ARRAY: {
                                        Match newMatch;
                                        int n = parent.size();
                                        for (int i = 0; i < n; ++i) {
                                            newMatch = new Match(oldMatch, seg, parent.get(i), i);
                                            newMatches.add(newMatch);
                                            if (seg.getType() != Segment.Type.GLOB) continue;
                                            Expression.addAllChildren(oldMatch, newMatches, newMatch.getNode());
                                        }
                                        break;
                                    }
                                }
                                continue block11;
                            }
                        }
                        throw new IllegalStateException();
                    }
                    if (newMatches.isEmpty()) {
                        return newMatches;
                    }
                    ArrayList<Match> tempMatches = oldMatches;
                    oldMatches = newMatches;
                    newMatches = tempMatches;
                    newMatches.clear();
                }
            }
            return oldMatches;
        }

        private static void addAllChildren(Match parent, List<Match> matches, JsonNode node) {
            switch (node.getNodeType()) {
                case OBJECT: {
                    Iterator fields = node.fields();
                    while (fields.hasNext()) {
                        Map.Entry field = (Map.Entry)fields.next();
                        Match match = new Match(parent, parent.getSegment(), (JsonNode)field.getValue(), (String)field.getKey());
                        matches.add(match);
                        Expression.addAllChildren(match, matches, match.getNode());
                    }
                    break;
                }
                case ARRAY: {
                    int n = node.size();
                    for (int i = 0; i < n; ++i) {
                        Match match = new Match(parent, parent.getSegment(), node.get(i), i);
                        matches.add(match);
                        Expression.addAllChildren(match, matches, match.getNode());
                    }
                    break;
                }
            }
        }

        public String toString() {
            StringBuilder s = new StringBuilder(32);
            s.append("JsonPath.Expression{");
            int n = this.segments.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    s.append(',');
                }
                s.append("segment[");
                s.append(i);
                s.append("]=");
                s.append(this.segments.get(i));
            }
            s.append(']');
            return s.toString();
        }
    }

    public static class Match {
        private Match parent;
        private Segment segment;
        private JsonNode node;
        private String field;
        private int index;

        Match(Match parent, Segment segment, JsonNode node, String field, int index) {
            this.parent = parent;
            this.segment = segment;
            this.node = node;
            this.field = field;
            this.index = index;
        }

        Match(Match parent, Segment segment, JsonNode node, String field) {
            this(parent, segment, node, field, -1);
        }

        Match(Match parent, Segment segment, JsonNode node, int index) {
            this(parent, segment, node, null, index);
        }

        public Match getParent() {
            return this.parent;
        }

        public Segment getSegment() {
            return this.segment;
        }

        public JsonNode getNode() {
            return this.node;
        }

        public String getField() {
            return this.field;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "JsonPath{parent=" + this.getParent() + ",segment=" + this.getSegment() + ",node=" + this.getNode() + ",field=" + this.getField() + ",index=" + this.getIndex() + "}";
        }
    }
}

