/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.audit.log4j.layout;

import org.apache.knox.gateway.audit.api.AuditContext;
import org.apache.knox.gateway.audit.api.CorrelationContext;
import org.apache.log4j.helpers.DateLayout;
import org.apache.log4j.spi.LoggingEvent;

public class AuditLayout
extends DateLayout {
    private static final String DATE_FORMAT = "yy/MM/dd HH:mm:ss";
    private static final String SEPARATOR = "|";
    private StringBuffer sb = new StringBuffer();

    public void activateOptions() {
        this.setDateFormat(DATE_FORMAT);
    }

    public String format(LoggingEvent event) {
        this.sb.setLength(0);
        this.dateFormat(this.sb, event);
        CorrelationContext cc = (CorrelationContext)event.getMDC("correlation_context");
        AuditContext ac = (AuditContext)event.getMDC("audit_context");
        this.appendParameter(cc == null ? null : cc.getRootRequestId());
        this.appendParameter(cc == null ? null : cc.getParentRequestId());
        this.appendParameter(cc == null ? null : cc.getRequestId());
        this.appendParameter(event.getLoggerName());
        this.appendParameter(ac == null ? null : ac.getRemoteIp());
        this.appendParameter(ac == null ? null : ac.getTargetServiceName());
        this.appendParameter(ac == null ? null : ac.getUsername());
        this.appendParameter(ac == null ? null : ac.getProxyUsername());
        this.appendParameter(ac == null ? null : ac.getSystemUsername());
        this.appendParameter((String)event.getMDC("action"));
        this.appendParameter((String)event.getMDC("resource_type"));
        this.appendParameter((String)event.getMDC("resource_name"));
        this.appendParameter((String)event.getMDC("outcome"));
        String message = event.getRenderedMessage();
        this.sb.append(message == null ? "" : message).append(LINE_SEP);
        return this.sb.toString();
    }

    public boolean ignoresThrowable() {
        return true;
    }

    private void appendParameter(String parameter) {
        if (parameter != null) {
            this.sb.append(parameter);
        }
        this.sb.append(SEPARATOR);
    }
}

