/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.knox.gateway.filter.AbstractGatewayFilter;

public class ResponseCookieFilter
extends AbstractGatewayFilter {
    public static final String RESTRICTED_COOKIES = "restrictedCookies";
    private List<String> restrictedCookies = new ArrayList<String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String cookies = filterConfig.getInitParameter(RESTRICTED_COOKIES);
        if (cookies != null) {
            this.restrictedCookies = Arrays.asList(cookies.split(","));
        }
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        ResponseWrapper responseWrapper = new ResponseWrapper(response);
        chain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
    }

    private class ResponseWrapper
    extends HttpServletResponseWrapper {
        ResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void addCookie(Cookie cookie) {
            if (cookie != null && this.isAllowedHeader(cookie.getName())) {
                super.addCookie(cookie);
            }
        }

        public void setHeader(String name, String value) {
            if (this.isAllowedHeader(name)) {
                super.setHeader(name, value);
            }
        }

        public void addHeader(String name, String value) {
            if (this.isAllowedHeader(name)) {
                super.addHeader(name, value);
            }
        }

        private boolean isAllowedHeader(String value) {
            if (value != null) {
                for (String v : ResponseCookieFilter.this.restrictedCookies) {
                    if (!value.contains(v)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

