/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.logback.internal;

import ch.qos.logback.classic.Level;
import org.ops4j.pax.logging.spi.PaxLevel;

public class PaxLevelForLogback
implements PaxLevel {
    public static final int SYSLOG_DEBUG = 7;
    public static final int SYSLOG_INFO = 6;
    public static final int SYSLOG_WARN = 4;
    public static final int SYSLOG_ERROR = 3;
    public static final int SYSLOG_OFF = 0;
    private Level m_delegate;

    public PaxLevelForLogback(Level delegate) {
        this.m_delegate = delegate;
    }

    public boolean isGreaterOrEqual(PaxLevel r) {
        if (r instanceof PaxLevelForLogback) {
            return this.m_delegate.isGreaterOrEqual(((PaxLevelForLogback)r).m_delegate);
        }
        return this.getSyslogEquivalent() <= r.getSyslogEquivalent();
    }

    public int toInt() {
        if (this.m_delegate.isGreaterOrEqual(Level.ERROR)) {
            return 4;
        }
        if (this.m_delegate.isGreaterOrEqual(Level.WARN)) {
            return 3;
        }
        if (this.m_delegate.isGreaterOrEqual(Level.INFO)) {
            return 2;
        }
        if (this.m_delegate.isGreaterOrEqual(Level.DEBUG)) {
            return 1;
        }
        return 0;
    }

    public int getSyslogEquivalent() {
        if (this.m_delegate == Level.TRACE) {
            return 7;
        }
        if (this.m_delegate == Level.DEBUG) {
            return 7;
        }
        if (this.m_delegate == Level.INFO) {
            return 6;
        }
        if (this.m_delegate == Level.WARN) {
            return 4;
        }
        if (this.m_delegate == Level.ERROR) {
            return 3;
        }
        if (this.m_delegate == Level.OFF) {
            return 0;
        }
        if (this.m_delegate == Level.ALL) {
            return 7;
        }
        return 7;
    }

    public String toString() {
        return this.m_delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaxLevelForLogback that = (PaxLevelForLogback)o;
        return this.m_delegate.equals(that.m_delegate);
    }

    public int hashCode() {
        return this.m_delegate.hashCode();
    }
}

