/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.table.ShellTable;

@Command(scope="feature", name="list", description="Lists all existing features available from the defined repositories.")
public class ListFeaturesCommand
extends FeaturesCommandSupport {
    @Option(name="-i", aliases={"--installed"}, description="Display a list of all installed features only", required=false, multiValued=false)
    boolean onlyInstalled;
    @Option(name="-o", aliases={"--ordered"}, description="Display a list using alphabetical order ", required=false, multiValued=false)
    boolean ordered;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;

    @Override
    protected void doExecute(FeaturesService featuresService) throws Exception {
        boolean needsLegend = false;
        ShellTable table = new ShellTable();
        table.column("Name");
        table.column("Version");
        table.column("Installed");
        table.column("Repository");
        table.column("Description").maxSize(50);
        table.emptyTableText(this.onlyInstalled ? "No features installed" : "No features available");
        ArrayList<FeatureAndRepository> featuresAndRepositories = new ArrayList<FeatureAndRepository>();
        for (Repository repository : Arrays.asList(featuresService.listRepositories())) {
            for (Feature feature : Arrays.asList(repository.getFeatures())) {
                if (this.onlyInstalled && !featuresService.isInstalled(feature)) continue;
                featuresAndRepositories.add(new FeatureAndRepository(feature, repository));
            }
        }
        if (this.ordered) {
            Collections.sort(featuresAndRepositories, new FeatureAndRepositoryComparator());
        }
        for (FeatureAndRepository far : featuresAndRepositories) {
            table.addRow().addContent(new Object[]{far.feature.getName(), far.feature.getVersion(), featuresService.isInstalled(far.feature) ? "x" : "", far.repository.getName(), far.feature.getDescription()});
            if (!this.isInstalledViaDeployDir(far.repository.getName())) continue;
            needsLegend = true;
        }
        table.print(System.out, !this.noFormat);
        if (needsLegend) {
            System.out.println("* Installed via deploy directory");
        }
    }

    private boolean isInstalledViaDeployDir(String st) {
        return st == null || st.length() <= 1 ? false : st.charAt(st.length() - 1) == '*';
    }

    class FeatureAndRepositoryComparator
    implements Comparator<FeatureAndRepository> {
        FeatureAndRepositoryComparator() {
        }

        @Override
        public int compare(FeatureAndRepository o1, FeatureAndRepository o2) {
            return o1.feature.getName().toLowerCase().compareTo(o2.feature.getName().toLowerCase());
        }
    }

    class FeatureAndRepository {
        public Feature feature;
        public Repository repository;

        FeatureAndRepository(Feature feature, Repository repository) {
            this.feature = feature;
            this.repository = repository;
        }
    }
}

