/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.Collection;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.util.ShellUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

@Command(scope="bundle", name="find-class", description="Locates a specified class in any deployed bundle")
public class FindClass
extends OsgiCommandSupport {
    @Argument(index=0, name="className", description="Class name or partial class name to be found", required=true, multiValued=false)
    String className;

    protected Object doExecute() throws Exception {
        this.findResource();
        return null;
    }

    protected void findResource() {
        Bundle[] bundles = this.getBundleContext().getBundles();
        String filter = "*" + this.className + "*";
        for (Bundle bundle : bundles) {
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            if (wiring != null) {
                Collection resources = wiring.listResources("/", filter, 1);
                if (resources.size() > 0) {
                    String title = ShellUtil.getBundleName((Bundle)bundle);
                    System.out.println("\n" + title);
                }
                for (String resource : resources) {
                    System.out.println(resource);
                }
                continue;
            }
            System.out.println("Bundle " + bundle.getBundleId() + " is not resolved.");
        }
    }
}

