/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.swagger;

import java.util.Locale;
import org.apache.juneau.bean.swagger.Swagger;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.swagger.BasicSwaggerProviderSession;
import org.apache.juneau.rest.swagger.SwaggerProvider;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;

public class BasicSwaggerProvider
implements SwaggerProvider {
    private final VarResolver vr;
    private final JsonSchemaGenerator js;
    private final Messages messages;
    private final FileFinder fileFinder;
    private final BeanStore beanStore;

    public BasicSwaggerProvider(BeanStore beanStore) {
        this(SwaggerProvider.create(beanStore).varResolver(() -> (VarResolver)beanStore.getBean(VarResolver.class).get()).fileFinder(() -> (FileFinder)beanStore.getBean(FileFinder.class).get()).messages(() -> (Messages)beanStore.getBean(Messages.class).get()).jsonSchemaGenerator(() -> (JsonSchemaGenerator)beanStore.getBean(JsonSchemaGenerator.class).get()));
    }

    public BasicSwaggerProvider(SwaggerProvider.Builder builder) {
        this.beanStore = builder.beanStore;
        this.vr = builder.varResolver().orElse(this.beanStore.getBean(VarResolver.class).orElse(VarResolver.DEFAULT));
        this.js = builder.jsonSchemaGenerator().orElse(this.beanStore.getBean(JsonSchemaGenerator.class).orElse(JsonSchemaGenerator.DEFAULT));
        this.messages = builder.messages().orElse(null);
        this.fileFinder = builder.fileFinder().orElse(null);
    }

    @Override
    public Swagger getSwagger(RestContext context, Locale locale) throws Exception {
        Class<?> c = context.getResourceClass();
        FileFinder ff = Utils.nn((Object)this.fileFinder) ? this.fileFinder : (FileFinder)FileFinder.create((BeanStore)this.beanStore).cp(c, null, false).build();
        Messages mb = Utils.nn((Object)this.messages) ? this.messages.forLocale(locale) : ((Messages)Messages.create(c).build()).forLocale(locale);
        VarResolverSession vrs = this.vr.createSession().bean(Messages.class, (Object)mb);
        BasicSwaggerProviderSession session = new BasicSwaggerProviderSession(context, locale, ff, this.messages, vrs, this.js.getSession());
        return session.getSwagger();
    }
}

