/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Deque;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.bean.openapi3.Example;
import org.apache.juneau.bean.openapi3.OpenApi;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.bean.openapi3.SchemaInfo;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class HeaderInfo
extends OpenApiElement {
    private String description;
    private String ref;
    private Boolean required;
    private Boolean explode;
    private Boolean deprecated;
    private Boolean allowEmptyValue;
    private Boolean allowReserved;
    private SchemaInfo schema;
    private Object example;
    private Map<String, Example> examples = CollectionUtils.map();

    public HeaderInfo() {
    }

    public HeaderInfo(HeaderInfo copyFrom) {
        super(copyFrom);
        this.description = copyFrom.description;
        this.example = copyFrom.example;
        this.allowEmptyValue = copyFrom.allowEmptyValue;
        this.schema = copyFrom.schema;
        this.allowReserved = copyFrom.allowReserved;
        this.required = copyFrom.required;
        this.ref = copyFrom.ref;
        this.explode = copyFrom.explode;
        this.deprecated = copyFrom.deprecated;
        if (Utils.nn(copyFrom.examples)) {
            this.examples.putAll(CollectionUtils.copyOf(copyFrom.examples, Example::copy));
        }
    }

    public HeaderInfo addExample(String name, Example example) {
        AssertionUtils.assertArgNotNull("name", name);
        AssertionUtils.assertArgNotNull("example", example);
        this.examples.put(name, example);
        return this;
    }

    public HeaderInfo copy() {
        return new HeaderInfo(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "description" -> ConverterUtils.toType(this.getDescription(), type);
            case "required" -> ConverterUtils.toType(this.getRequired(), type);
            case "explode" -> ConverterUtils.toType(this.getExplode(), type);
            case "deprecated" -> ConverterUtils.toType(this.getDeprecated(), type);
            case "allowEmptyValue" -> ConverterUtils.toType(this.getAllowEmptyValue(), type);
            case "allowReserved" -> ConverterUtils.toType(this.getAllowReserved(), type);
            case "$ref" -> ConverterUtils.toType(this.getRef(), type);
            case "schema" -> ConverterUtils.toType(this.getSchema(), type);
            case "x-example" -> ConverterUtils.toType(this.getExample(), type);
            case "examples" -> ConverterUtils.toType(this.getExamples(), type);
            default -> super.get(property, type);
        };
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    @Beanp(value="x-example")
    public Object getExample() {
        return this.example;
    }

    public Map<String, Example> getExamples() {
        return Utils.nullIfEmpty(this.examples);
    }

    public Boolean getExplode() {
        return this.explode;
    }

    @Beanp(value="$ref")
    public String getRef() {
        return this.ref;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.ref), "$ref").addIf(Utils.nn(this.allowEmptyValue), "allowEmptyValue").addIf(Utils.nn(this.allowReserved), "allowReserved").addIf(Utils.nn(this.deprecated), "deprecated").addIf(Utils.nn(this.description), "description").addIf(Utils.ne(this.examples), "examples").addIf(Utils.nn(this.explode), "explode").addIf(Utils.nn(this.required), "required").addIf(Utils.nn(this.schema), "schema").addIf(Utils.nn(this.example), "x-example").build();
        return new MultiSet<String>(s, super.keySet());
    }

    public HeaderInfo resolveRefs(OpenApi openApi, Deque<String> refStack, int maxDepth) {
        if (Utils.nn(this.ref)) {
            if (refStack.contains(this.ref) || refStack.size() >= maxDepth) {
                return this;
            }
            refStack.addLast(this.ref);
            HeaderInfo r = openApi.findRef(this.ref, HeaderInfo.class);
            r = r.resolveRefs(openApi, refStack, maxDepth);
            refStack.removeLast();
            return r;
        }
        return this;
    }

    @Override
    public HeaderInfo set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "$ref" -> this.setRef(Utils.s(value));
            case "allowEmptyValue" -> this.setAllowEmptyValue(ConverterUtils.toBoolean(value));
            case "allowReserved" -> this.setAllowReserved(ConverterUtils.toBoolean(value));
            case "deprecated" -> this.setDeprecated(ConverterUtils.toBoolean(value));
            case "description" -> this.setDescription(Utils.s(value));
            case "examples" -> this.setExamples(ConverterUtils.toMapBuilder(value, String.class, Example.class).sparse().build());
            case "explode" -> this.setExplode(ConverterUtils.toBoolean(value));
            case "required" -> this.setRequired(ConverterUtils.toBoolean(value));
            case "schema" -> this.setSchema(ConverterUtils.toType(value, SchemaInfo.class));
            case "x-example" -> this.setExample(value);
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public HeaderInfo setAllowEmptyValue(Boolean value) {
        this.allowEmptyValue = value;
        return this;
    }

    public HeaderInfo setAllowReserved(Boolean value) {
        this.allowReserved = value;
        return this;
    }

    public HeaderInfo setDeprecated(Boolean value) {
        this.deprecated = value;
        return this;
    }

    public HeaderInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    @Beanp(value="x-example")
    public HeaderInfo setExample(Object value) {
        this.example = value;
        return this;
    }

    public HeaderInfo setExamples(Map<String, Example> value) {
        this.examples.clear();
        if (Utils.nn(value)) {
            this.examples.putAll(value);
        }
        return this;
    }

    public HeaderInfo setExplode(Boolean value) {
        this.explode = value;
        return this;
    }

    @Beanp(value="$ref")
    public HeaderInfo setRef(String value) {
        this.ref = value;
        return this;
    }

    public HeaderInfo setRequired(Boolean value) {
        this.required = value;
        return this;
    }

    public HeaderInfo setSchema(SchemaInfo value) {
        this.schema = value;
        return this;
    }

    @Override
    public HeaderInfo strict(Object value) {
        super.strict(value);
        return this;
    }

    @Override
    protected HeaderInfo strict() {
        super.strict();
        return this;
    }
}

