/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.swagger;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.bean.swagger.Swagger;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.swagger.BasicSwaggerProvider;
import org.apache.juneau.svl.VarResolver;

public interface SwaggerProvider {
    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public Swagger getSwagger(RestContext var1, Locale var2) throws Exception;

    public static class Builder {
        final BeanStore beanStore;
        Class<?> resourceClass;
        Supplier<VarResolver> varResolver;
        Supplier<JsonSchemaGenerator> jsonSchemaGenerator;
        Supplier<Messages> messages;
        Supplier<FileFinder> fileFinder;
        BeanCreator<SwaggerProvider> creator;

        protected Builder(BeanStore beanStore) {
            this.beanStore = beanStore;
            this.creator = beanStore.createBean(SwaggerProvider.class).type(BasicSwaggerProvider.class).builder(Builder.class, this);
        }

        public SwaggerProvider build() {
            try {
                return this.creator.run();
            }
            catch (Exception e) {
                throw new InternalServerError(e);
            }
        }

        public Optional<FileFinder> fileFinder() {
            return Utils.opt(this.fileFinder).map(Supplier::get);
        }

        public Builder fileFinder(Supplier<FileFinder> value) {
            this.fileFinder = value;
            return this;
        }

        public Builder impl(SwaggerProvider value) {
            this.creator.impl(value);
            return this;
        }

        public Optional<JsonSchemaGenerator> jsonSchemaGenerator() {
            return Utils.opt(this.jsonSchemaGenerator).map(Supplier::get);
        }

        public Builder jsonSchemaGenerator(Supplier<JsonSchemaGenerator> value) {
            this.jsonSchemaGenerator = value;
            return this;
        }

        public Optional<Messages> messages() {
            return Utils.opt(this.messages).map(Supplier::get);
        }

        public Builder messages(Supplier<Messages> value) {
            this.messages = value;
            return this;
        }

        public Builder type(Class<? extends SwaggerProvider> value) {
            this.creator.type(value == null ? BasicSwaggerProvider.class : value);
            return this;
        }

        public Optional<VarResolver> varResolver() {
            return Utils.opt(this.varResolver).map(Supplier::get);
        }

        public Builder varResolver(Supplier<VarResolver> value) {
            this.varResolver = value;
            return this;
        }

        protected Class<? extends SwaggerProvider> getDefaultType() {
            return BasicSwaggerProvider.class;
        }
    }

    public static abstract class Void
    implements SwaggerProvider {
    }
}

