/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.servlet;

import jakarta.servlet.ServletException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;

public abstract class RestObject {
    private AtomicReference<RestContext> context = new AtomicReference();

    public synchronized RestRequest getRequest() {
        return this.getContext().getLocalSession().getOpSession().getRequest();
    }

    public synchronized RestResponse getResponse() {
        return this.getContext().getLocalSession().getOpSession().getResponse();
    }

    public void log(Level level, String msg, Object ... args) {
        this.doLog(level, null, Utils.fs(msg, args));
    }

    public void log(Level level, Throwable cause, String msg, Object ... args) {
        this.doLog(level, cause, Utils.fs(msg, args));
    }

    protected void doLog(Level level, Throwable cause, Supplier<String> msg) {
        Logger logger;
        RestContext c = this.context.get();
        Logger logger2 = logger = c == null ? null : c.getLogger();
        if (logger == null) {
            logger = Logger.getLogger(Utils.cn(this));
        }
        logger.log(level, cause, msg);
    }

    protected RestContext getContext() {
        if (this.context.get() == null) {
            throw new InternalServerError("RestContext object not set on resource.", new Object[0]);
        }
        return this.context.get();
    }

    protected void setContext(RestContext context) throws ServletException {
        this.context.set(context);
    }
}

