/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.NameValuePair;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.part.BasicStringPart;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.objecttools.PageArgs;
import org.apache.juneau.objecttools.SearchArgs;
import org.apache.juneau.objecttools.SortArgs;
import org.apache.juneau.objecttools.ViewArgs;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.httppart.RequestHttpPart;
import org.apache.juneau.rest.httppart.RequestQueryParam;
import org.apache.juneau.svl.VarResolverSession;

public class RequestQueryParams
extends ArrayList<RequestQueryParam> {
    private static final long serialVersionUID = 1L;
    private final RestRequest req;
    private boolean caseSensitive;
    private final VarResolverSession vs;
    private HttpPartParserSession parser;

    public RequestQueryParams(RestRequest req, Map<String, String[]> query, boolean caseSensitive) {
        this.req = req;
        this.caseSensitive = caseSensitive;
        this.vs = req.getVarResolverSession();
        for (Map.Entry<String, String[]> e : query.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            if (values == null) {
                values = new String[]{};
            }
            if (values.length == 1 && values[0] == null) {
                values[0] = "";
            }
            if (values.length == 0) {
                values = CollectionUtils.a(new String[]{null});
            }
            for (String value : values) {
                this.add(new RequestQueryParam(req, name, value));
            }
        }
    }

    private RequestQueryParams(RequestQueryParams copyFrom) {
        this.req = copyFrom.req;
        this.caseSensitive = copyFrom.caseSensitive;
        this.parser = copyFrom.parser;
        this.addAll(copyFrom);
        this.vs = copyFrom.vs;
    }

    private RequestQueryParams(RequestQueryParams copyFrom, String ... names) {
        this.req = copyFrom.req;
        this.caseSensitive = copyFrom.caseSensitive;
        this.parser = copyFrom.parser;
        this.vs = copyFrom.vs;
        for (String n : names) {
            copyFrom.stream().filter(x -> this.eq(x.getName(), n)).forEach(this::add);
        }
    }

    public RequestQueryParams add(NameValuePair ... parameters) {
        AssertionUtils.assertArgNotNull("parameters", parameters);
        for (NameValuePair p : parameters) {
            if (!Utils.nn(p)) continue;
            this.add(p.getName(), p.getValue());
        }
        return this;
    }

    public RequestQueryParams add(String name, Object value) {
        AssertionUtils.assertArgNotNull("name", name);
        this.add(new RequestQueryParam(this.req, name, Utils.s(value)).parser(this.parser));
        return this;
    }

    public RequestQueryParams addDefault(List<? extends NameValuePair> pairs) {
        for (NameValuePair nameValuePair : pairs) {
            String name = nameValuePair.getName();
            Stream<RequestQueryParam> l = this.stream(name);
            boolean hasAllBlanks = l.allMatch(x -> Utils.e(x.getValue()));
            if (!hasAllBlanks) continue;
            this.removeAll(this.getAll(name));
            this.add(new RequestQueryParam(this.req, name, this.vs.resolve(nameValuePair.getValue())));
        }
        return this;
    }

    public RequestQueryParams addDefault(NameValuePair ... pairs) {
        return this.addDefault(CollectionUtils.l(pairs));
    }

    public RequestQueryParams addDefault(String name, String value) {
        return this.addDefault(BasicStringPart.of(name, value));
    }

    public String asQueryString() {
        StringBuilder sb = new StringBuilder();
        for (RequestQueryParam e : this) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(StringUtils.urlEncode(e.getName())).append('=').append(StringUtils.urlEncode(e.getValue()));
        }
        return sb.toString();
    }

    public RequestQueryParams caseSensitive(boolean value) {
        this.caseSensitive = value;
        return this;
    }

    public boolean contains(String name) {
        return this.stream(name).findAny().isPresent();
    }

    public boolean containsAny(String ... names) {
        AssertionUtils.assertArgNotNull("names", names);
        for (String n : names) {
            if (!this.stream(n).findAny().isPresent()) continue;
            return true;
        }
        return false;
    }

    public RequestQueryParams copy() {
        return new RequestQueryParams(this);
    }

    public <T> Optional<T> get(Class<T> type) {
        ClassMeta<T> cm = this.req.getBeanSession().getClassMeta(type);
        String name = HttpParts.getName(HttpPartType.QUERY, cm).orElseThrow(() -> ThrowableUtils.rex("@Query(name) not found on class {0}", Utils.cn(type)));
        return this.get(name).as(type);
    }

    public RequestQueryParam get(String name) {
        List<RequestQueryParam> l = this.getAll(name);
        if (l.isEmpty()) {
            return new RequestQueryParam(this.req, name, null).parser(this.parser);
        }
        if (l.size() == 1) {
            return l.get(0);
        }
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < l.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(l.get(i).getValue());
        }
        return new RequestQueryParam(this.req, name, sb.toString()).parser(this.parser);
    }

    public List<RequestQueryParam> getAll(String name) {
        return this.stream(name).collect(Collectors.toList());
    }

    public RequestQueryParam getFirst(String name) {
        AssertionUtils.assertArgNotNull("name", name);
        return this.stream(name).findFirst().orElseGet(() -> new RequestQueryParam(this.req, name, null).parser(this.parser));
    }

    public RequestQueryParam getLast(String name) {
        AssertionUtils.assertArgNotNull("name", name);
        Value<RequestQueryParam> v = Value.empty();
        this.stream(name).forEach((? super T x) -> v.set((RequestQueryParam)x));
        return v.orElseGet(() -> new RequestQueryParam(this.req, name, null).parser(this.parser));
    }

    public List<String> getNames() {
        return this.stream().map(RequestHttpPart::getName).map(x -> this.caseSensitive ? x : x.toLowerCase()).distinct().collect(Collectors.toList());
    }

    public Optional<PageArgs> getPageArgs() {
        return Utils.opt(PageArgs.create(this.get("p").asInteger().orElse(null), this.get("l").asInteger().orElse(null)));
    }

    public Optional<SearchArgs> getSearchArgs() {
        return Utils.opt(SearchArgs.create(this.get("s").asString().orElse(null)));
    }

    public Optional<SortArgs> getSortArgs() {
        return Utils.opt(SortArgs.create(this.get("o").asString().orElse(null)));
    }

    public Stream<RequestQueryParam> getSorted() {
        Comparator<RequestQueryParam> x = this.caseSensitive ? Comparator.comparing(RequestHttpPart::getName) : (x1, x2) -> String.CASE_INSENSITIVE_ORDER.compare(x1.getName(), x2.getName());
        return this.stream().sorted(x);
    }

    public Optional<ViewArgs> getViewArgs() {
        return Utils.opt(ViewArgs.create(this.get("v").asString().orElse(null)));
    }

    public RequestQueryParams parser(HttpPartParserSession value) {
        this.parser = value;
        this.forEach((? super E x) -> x.parser(this.parser));
        return this;
    }

    public RequestQueryParams remove(String name) {
        AssertionUtils.assertArgNotNull("name", name);
        this.removeIf(x -> this.eq(x.getName(), name));
        return this;
    }

    public RequestQueryParams set(NameValuePair ... parameters) {
        AssertionUtils.assertArgNotNull("headers", parameters);
        for (NameValuePair p : parameters) {
            this.remove(p);
        }
        for (NameValuePair p : parameters) {
            this.add(p);
        }
        return this;
    }

    public RequestQueryParams set(String name, Object value) {
        AssertionUtils.assertArgNotNull("name", name);
        this.set(new RequestQueryParam(this.req, name, Utils.s(value)).parser(this.parser));
        return this;
    }

    public Stream<RequestQueryParam> stream(String name) {
        return this.stream().filter(x -> this.eq(x.getName(), name));
    }

    public RequestQueryParams subset(String ... names) {
        return new RequestQueryParams(this, names);
    }

    protected FluentMap<String, Object> properties() {
        FluentMap<String, Object> m = CollectionUtils.filteredBeanPropertyMap();
        for (String n : this.getNames()) {
            m.a(n, this.get(n).asString().orElse(null));
        }
        return m;
    }

    @Override
    public String toString() {
        return Utils.r(this.properties());
    }

    private boolean eq(String s1, String s2) {
        return Utils.eq(!this.caseSensitive, s1, s2);
    }
}

