/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server.config.repository;

import java.io.File;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.config.Config;
import org.apache.juneau.server.config.repository.Command;
import org.apache.juneau.server.config.repository.ConfigItem;
import org.apache.juneau.server.config.repository.GetValue;
import org.apache.juneau.server.config.repository.GitControl;

public class GetConfiguration
implements Command,
GetValue<Map<String, ConfigItem>> {
    private static final String APPLICATION = "APPLICATION";
    private static final String PROJECT = "PROJECT";
    private static final String EXT = ".cfg";
    private static final String BAR = "/";
    private Map<String, ConfigItem> configs = new HashMap<String, ConfigItem>();
    private String project;
    private String branch;

    public GetConfiguration(String project, String branch) {
        this.branch = branch;
        this.project = project;
    }

    @Override
    public void execute() throws Exception {
        File fileProject;
        Config config = Config.create().name("juneau-server-config.cfg").build();
        String pathStr = config.get("GitServer/pathLocal").orElse(null);
        String git = config.get("GitServer/gitRemote").orElse(null);
        GitControl gitControl = new GitControl(pathStr, git);
        File path = new File(pathStr);
        if (path.isDirectory()) {
            gitControl.pullFromRepo();
        } else {
            gitControl.cloneRepo();
        }
        gitControl.branch(this.branch);
        gitControl.pullFromRepo();
        String fileDefaultStr = APPLICATION.toLowerCase().concat(EXT);
        String fileProjectStr = this.project.concat(EXT);
        File fileDefault = new File(pathStr.concat(BAR).concat(fileDefaultStr));
        if (fileDefault.exists()) {
            String lines = new String(Files.readAllBytes(fileDefault.toPath()));
            this.configs.put(APPLICATION, new ConfigItem(lines));
        }
        if ((fileProject = new File(pathStr.concat(BAR).concat(fileProjectStr))).exists()) {
            String linesProject = new String(Files.readAllBytes(fileProject.toPath()));
            this.configs.put(PROJECT, new ConfigItem(linesProject));
        }
    }

    @Override
    public Map<String, ConfigItem> get() {
        return this.configs;
    }
}

