/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.eclipse.jetty.ee11.servlet.AsyncContextEvent;
import org.eclipse.jetty.ee11.servlet.ServletApiRequest;
import org.eclipse.jetty.ee11.servlet.ServletApiResponse;
import org.eclipse.jetty.ee11.servlet.ServletChannel;
import org.eclipse.jetty.ee11.servlet.ServletChannelState;

public class AsyncContextState
implements AsyncContext {
    volatile ServletChannelState _state;

    public AsyncContextState(ServletChannelState state) {
        this._state = state;
    }

    ServletChannelState state() {
        ServletChannelState state = this._state;
        if (state == null) {
            throw new IllegalStateException("AsyncContext completed and/or Request lifecycle recycled");
        }
        return state;
    }

    @Override
    public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        WrappedAsyncListener wrap = new WrappedAsyncListener(listener, request, response);
        this.state().addListener(wrap);
    }

    @Override
    public void addListener(AsyncListener listener) {
        this.state().addListener(listener);
    }

    @Override
    public void complete() {
        this.state().complete();
    }

    @Override
    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)((AsyncListener)this.state().getContextHandler().getContext().getServletContext().createInstance(clazz));
        }
        catch (Exception e2) {
            throw new ServletException(e2);
        }
    }

    @Override
    public void dispatch() {
        this.state().dispatch(null, null);
    }

    @Override
    public void dispatch(String path) {
        this.state().dispatch(null, path);
    }

    @Override
    public void dispatch(ServletContext context2, String path) {
        if (context2 != null && context2 == this.state().getContextHandler().getContext().getServletContext()) {
            this.state().dispatch(null, path);
        } else {
            this.state().dispatch(context2, path);
        }
    }

    @Override
    public ServletRequest getRequest() {
        return this.state().getAsyncContextEvent().getSuppliedRequest();
    }

    @Override
    public ServletResponse getResponse() {
        return this.state().getAsyncContextEvent().getSuppliedResponse();
    }

    @Override
    public long getTimeout() {
        return this.state().getTimeout();
    }

    @Override
    public boolean hasOriginalRequestAndResponse() {
        ServletRequest servletRequest = this.getRequest();
        ServletResponse servletResponse = this.getResponse();
        ServletChannel servletChannel = this._state.getServletChannel();
        ServletApiRequest originalHttpServletRequest = servletChannel.getServletContextRequest().getServletApiRequest();
        ServletApiResponse originalHttpServletResponse = servletChannel.getServletContextResponse().getServletApiResponse();
        return servletRequest == originalHttpServletRequest && servletResponse == originalHttpServletResponse;
    }

    @Override
    public void setTimeout(long timeout) {
        this.state().setTimeout(timeout);
    }

    @Override
    public void start(Runnable task) {
        this._state.getServletChannel().getContext().execute(() -> {
            AsyncContextEvent asyncContextEvent = this.state().getAsyncContextEvent();
            if (asyncContextEvent != null && asyncContextEvent.getContext() != null) {
                asyncContextEvent.getContext().run(task);
            } else {
                task.run();
            }
        }, this._state.getServletChannel().getRequest());
    }

    public void reset() {
        this._state = null;
    }

    public static class WrappedAsyncListener
    implements AsyncListener {
        private final AsyncListener _listener;
        private final ServletRequest _request;
        private final ServletResponse _response;

        public WrappedAsyncListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
            this._listener = listener;
            this._request = request;
            this._response = response;
        }

        public AsyncListener getListener() {
            return this._listener;
        }

        @Override
        public void onTimeout(AsyncEvent event) throws IOException {
            this._listener.onTimeout(new AsyncEvent(event.getAsyncContext(), this._request, this._response, event.getThrowable()));
        }

        @Override
        public void onStartAsync(AsyncEvent event) throws IOException {
            this._listener.onStartAsync(new AsyncEvent(event.getAsyncContext(), this._request, this._response, event.getThrowable()));
        }

        @Override
        public void onError(AsyncEvent event) throws IOException {
            this._listener.onError(new AsyncEvent(event.getAsyncContext(), this._request, this._response, event.getThrowable()));
        }

        @Override
        public void onComplete(AsyncEvent event) throws IOException {
            this._listener.onComplete(new AsyncEvent(event.getAsyncContext(), this._request, this._response, event.getThrowable()));
        }
    }
}

