/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.jena.irix.IRIs;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.WrappedIOException;
import org.apache.jena.util.SystemUtils;

public class FileUtils {
    public static final String langXML = "RDF/XML";
    public static final String langXMLAbbrev = "RDF/XML-ABBREV";
    public static final String langNTriple = "N-TRIPLE";
    public static final String langN3 = "N3";
    public static final String langTurtle = "TURTLE";
    static Charset utf8 = StandardCharsets.UTF_8;
    private static int counter = 0;

    public static Reader asUTF8(InputStream in) {
        return new InputStreamReader(in, utf8.newDecoder());
    }

    public static BufferedReader asBufferedUTF8(InputStream in) {
        BufferedReader r = new BufferedReader(FileUtils.asUTF8(in));
        return r;
    }

    public static Writer asUTF8(OutputStream out) {
        return new OutputStreamWriter(out, utf8);
    }

    public static PrintWriter asPrintWriterUTF8(OutputStream out) {
        return new PrintWriter(FileUtils.asUTF8(out));
    }

    public static String guessLang(String name, String otherwise) {
        String suffix = FileUtils.getFilenameExt(name);
        if (suffix.equals("n3")) {
            return langN3;
        }
        if (suffix.equals("nt")) {
            return langNTriple;
        }
        if (suffix.equals("ttl")) {
            return langTurtle;
        }
        if (suffix.equals("rdf")) {
            return langXML;
        }
        if (suffix.equals("owl")) {
            return langXML;
        }
        return otherwise;
    }

    public static String guessLang(String urlStr) {
        return FileUtils.guessLang(urlStr, langXML);
    }

    public static String toFilename(String filenameOrURI) {
        if (!FileUtils.isFile(filenameOrURI)) {
            return null;
        }
        String fn = filenameOrURI;
        if (!fn.startsWith("file:")) {
            return fn;
        }
        fn = fn.startsWith("file:///") ? fn.substring("file://".length()) : (fn.startsWith("file://localhost/") ? fn.substring("file://localhost".length()) : fn.substring("file:".length()));
        return FileUtils.decodeFileName(fn);
    }

    public static String decodeFileName(String s) {
        if (s.indexOf(37) < 0) {
            return s;
        }
        int len = s.length();
        StringBuilder sbuff = new StringBuilder(len);
        block3: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '%': {
                    int codepoint = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                    char ch = (char)codepoint;
                    sbuff.append(ch);
                    i += 2;
                    continue block3;
                }
                default: {
                    sbuff.append(c);
                }
            }
        }
        return sbuff.toString();
    }

    public static boolean isFile(String name) {
        String scheme = IRIs.scheme(name);
        if (scheme == null) {
            return true;
        }
        if (scheme.equals("file")) {
            return true;
        }
        return scheme.length() == 1;
    }

    public static boolean isURI(String name) {
        return IRIs.scheme(name) != null;
    }

    public static String getDirname(String filename) {
        File f = new File(filename);
        return f.getParent();
    }

    public static String getFilenameExt(String filename) {
        String pathname = FileUtils.pathname(filename);
        int iSlash = pathname.lastIndexOf(47);
        int iBack = pathname.lastIndexOf(92);
        int iExt = pathname.lastIndexOf(46);
        if (iBack > iSlash) {
            iSlash = iBack;
        }
        return iExt > iSlash ? pathname.substring(iExt + 1).toLowerCase() : "";
    }

    private static String pathname(String filename) {
        if (!Strings.CI.startsWith((CharSequence)filename, (CharSequence)"http:") && !Strings.CI.startsWith((CharSequence)filename, (CharSequence)"https:")) {
            return filename;
        }
        return StringUtils.substringBefore((String)filename, (String)"?");
    }

    public static File tempFileName(String prefix, String suffix) {
        File result = new File(FileUtils.getTempDirectory(), prefix + FileUtils.randomNumber() + suffix);
        if (result.exists()) {
            return FileUtils.tempFileName(prefix, suffix);
        }
        result.deleteOnExit();
        return result;
    }

    public static File getScratchDirectory(String prefix) {
        File result = new File(FileUtils.getTempDirectory(), prefix + FileUtils.randomNumber());
        if (result.exists()) {
            return FileUtils.getScratchDirectory(prefix);
        }
        if (!result.mkdir()) {
            throw new JenaException("mkdir failed on " + String.valueOf(result));
        }
        result.deleteOnExit();
        return result;
    }

    public static String getTempDirectory() {
        return SystemUtils.getSystemProperty("java.io.tmpdir");
    }

    private static int randomNumber() {
        return ++counter;
    }

    public static BufferedReader openResourceFile(String filename) {
        try {
            InputStream is = FileUtils.openResourceFileAsStream(filename);
            return new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
    }

    public static InputStream openResourceFileAsStream(String filename) throws FileNotFoundException {
        InputStream is = ClassLoader.getSystemResourceAsStream(filename);
        if (is == null && (is = FileUtils.class.getResourceAsStream("/" + filename)) == null && (is = FileUtils.class.getResourceAsStream(filename)) == null) {
            is = new FileInputStream(filename);
        }
        return is;
    }

    public static BufferedReader readerFromURL(String urlStr) {
        try {
            InputStream conn = new URI(urlStr).toURL().openStream();
            return FileUtils.asBufferedUTF8(conn);
        }
        catch (MalformedURLException | URISyntaxException e) {
            try {
                return FileUtils.asBufferedUTF8(new FileInputStream(urlStr));
            }
            catch (FileNotFoundException f) {
                throw new WrappedIOException(f);
            }
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
    }

    public static String readWholeFileAsUTF8(String filename) throws IOException {
        Path path = Path.of(filename, new String[0]);
        byte[] b = Files.readAllBytes(path);
        return new String(b, utf8);
    }

    public static String readWholeFileAsUTF8(InputStream in) throws IOException {
        return IOUtils.toString((InputStream)in, (Charset)utf8);
    }
}

