/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem.spliterator;

import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.jena.mem.spliterator.ArraySubSpliterator;

public class ArraySpliterator<E>
implements Spliterator<E> {
    private final E[] entries;
    private final Runnable checkForConcurrentModification;
    private int pos;

    public ArraySpliterator(E[] entries, int toIndex, Runnable checkForConcurrentModification) {
        this.entries = entries;
        this.pos = toIndex;
        this.checkForConcurrentModification = checkForConcurrentModification;
    }

    public ArraySpliterator(E[] entries, Runnable checkForConcurrentModification) {
        this(entries, entries.length, checkForConcurrentModification);
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        this.checkForConcurrentModification.run();
        if (-1 < --this.pos) {
            action.accept(this.entries[this.pos]);
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        while (-1 < --this.pos) {
            action.accept(this.entries[this.pos]);
        }
        this.checkForConcurrentModification.run();
    }

    @Override
    public Spliterator<E> trySplit() {
        if (this.pos < 2) {
            return null;
        }
        int toIndexOfSubIterator = this.pos;
        this.pos >>>= 1;
        return new ArraySubSpliterator<E>(this.entries, this.pos, toIndexOfSubIterator, this.checkForConcurrentModification);
    }

    @Override
    public long estimateSize() {
        return this.pos;
    }

    @Override
    public int characteristics() {
        return 17729;
    }
}

