/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwk;

import com.auth0.jwk.Bucket;
import java.util.concurrent.TimeUnit;

class BucketImpl
implements Bucket {
    private final long size;
    private final long rate;
    private final TimeUnit rateUnit;
    private long available;
    private long accumDelta;
    private long startTime;

    BucketImpl(long size, long rate, TimeUnit rateUnit) {
        this.assertPositiveValue(size, "Invalid bucket size.");
        this.assertPositiveValue(rate, "Invalid bucket refill rate.");
        this.size = size;
        this.available = size;
        this.rate = rate;
        this.rateUnit = rateUnit;
        this.startTime = System.nanoTime();
    }

    private void assertPositiveValue(long value, long maxValue, String exceptionMessage) {
        if (value < 1L || value > maxValue) {
            throw new IllegalArgumentException(exceptionMessage);
        }
    }

    private void assertPositiveValue(Number value, String exceptionMessage) {
        this.assertPositiveValue(value.intValue(), value.intValue(), exceptionMessage);
    }

    @Override
    public synchronized long willLeakIn() {
        return this.willLeakIn(1L);
    }

    @Override
    public synchronized long willLeakIn(long count) {
        long remaining;
        this.assertPositiveValue(count, this.size, String.format("Cannot consume %d tokens when the BucketImpl size is %d!", count, this.size));
        this.updateAvailableTokens();
        if (this.available >= count) {
            return 0L;
        }
        long leakDelta = this.getTimeSinceLastTokenAddition();
        if (leakDelta < this.getRatePerToken()) {
            leakDelta = this.getRatePerToken() - leakDelta;
        }
        if ((remaining = count - this.available - 1L) > 0L) {
            leakDelta += this.getRatePerToken() * remaining;
        }
        return leakDelta;
    }

    @Override
    public synchronized boolean consume() {
        return this.consume(1L);
    }

    @Override
    public synchronized boolean consume(long count) {
        this.assertPositiveValue(count, this.size, String.format("Cannot consume %d tokens when the BucketImpl size is %d!", count, this.size));
        this.updateAvailableTokens();
        if (count <= this.available) {
            this.available -= count;
            return true;
        }
        return false;
    }

    private void updateAvailableTokens() {
        long ratePerToken = this.getRatePerToken();
        long elapsed = this.getTimeSinceLastTokenAddition();
        if (elapsed < ratePerToken) {
            return;
        }
        this.accumDelta = elapsed % ratePerToken;
        long count = elapsed / ratePerToken;
        if (count > this.size - this.available) {
            count = this.size - this.available;
        }
        if (count > 0L) {
            this.available += count;
        }
        this.restartStopWatch();
    }

    private void restartStopWatch() {
        this.startTime = System.nanoTime();
    }

    private long getTimeSinceLastTokenAddition() {
        long elapsedTime = System.nanoTime() - this.startTime;
        return TimeUnit.MILLISECONDS.convert(elapsedTime, TimeUnit.NANOSECONDS) + this.accumDelta;
    }

    private long getRatePerToken() {
        return this.rateUnit.toMillis(this.rate);
    }
}

