/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.ValuePatternComponent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

final class TimestampValuePatternComponent
extends ValuePatternComponent {
    private static final long serialVersionUID = 9209358760604151565L;
    private final boolean expressAsGeneralizedTime;
    private final boolean expressAsMillisecondsSinceEpoch;
    private final boolean expressAsSecondsSinceEpoch;
    private final long boundRange;
    private final long lowerBound;
    @NotNull
    private final Random seedRandom;
    @Nullable
    private final String dateFormatString;
    @NotNull
    private final ThreadLocal<Random> threadLocalRandoms;
    @NotNull
    private final ThreadLocal<SimpleDateFormat> threadLocalDateFormatters;

    TimestampValuePatternComponent(@NotNull String pattern, long randomSeed) throws ParseException {
        this.seedRandom = new Random(randomSeed);
        this.threadLocalRandoms = new ThreadLocal();
        this.threadLocalDateFormatters = new ThreadLocal();
        if (pattern.equals("timestamp")) {
            this.expressAsGeneralizedTime = true;
            this.expressAsMillisecondsSinceEpoch = false;
            this.expressAsSecondsSinceEpoch = false;
            this.lowerBound = -1L;
            this.boundRange = -1L;
            this.dateFormatString = null;
            return;
        }
        if (pattern.startsWith("timestamp:min=")) {
            int maxPos = pattern.indexOf(":max=");
            if (maxPos < 0) {
                throw new ParseException(UtilityMessages.ERR_TIMESTAMP_VALUE_PATTERN_MIN_WITHOUT_MAX.get(pattern), 10);
            }
            int formatPos = pattern.indexOf(":format");
            if (formatPos > 0 && formatPos < maxPos) {
                throw new ParseException(UtilityMessages.ERR_TIMESTAMP_VALUE_PATTERN_FORMAT_NOT_AT_END.get(pattern), formatPos);
            }
            String lowerBoundString = pattern.substring(14, maxPos);
            try {
                this.lowerBound = StaticUtils.decodeGeneralizedTime(lowerBoundString).getTime();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new ParseException(UtilityMessages.ERR_TIMESTAMP_VALUE_PATTERN_CANNOT_PARSE_MIN.get(pattern, lowerBoundString, StaticUtils.getExceptionMessage(e)), 14);
            }
            if (formatPos < 0) {
                long upperBound;
                String upperBoundString = pattern.substring(maxPos + 5);
                try {
                    upperBound = StaticUtils.decodeGeneralizedTime(upperBoundString).getTime();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new ParseException(UtilityMessages.ERR_TIMESTAMP_VALUE_PATTERN_CANNOT_PARSE_MAX.get(pattern, upperBoundString, StaticUtils.getExceptionMessage(e)), maxPos + 5);
                }
                if (upperBound <= this.lowerBound) {
                    throw new ParseException(UtilityMessages.ERR_TIMESTAMP_VALUE_PATTERN_MIN_NOT_LT_MAX.get(pattern, lowerBoundString, upperBoundString), maxPos + 5);
                }
                this.boundRange = upperBound - this.lowerBound + 1L;
                this.expressAsGeneralizedTime = true;
                this.expressAsMillisecondsSinceEpoch = false;
                this.expressAsSecondsSinceEpoch = false;
                this.dateFormatString = null;
            } else {
                long upperBound;
                String upperBoundString = pattern.substring(maxPos + 5, formatPos);
                try {
                    upperBound = StaticUtils.decodeGeneralizedTime(upperBoundString).getTime();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new ParseException(UtilityMessages.ERR_TIMESTAMP_VALUE_PATTERN_CANNOT_PARSE_MAX.get(pattern, upperBoundString, StaticUtils.getExceptionMessage(e)), maxPos + 5);
                }
                if (upperBound <= this.lowerBound) {
                    throw new ParseException(UtilityMessages.ERR_TIMESTAMP_VALUE_PATTERN_MIN_NOT_LT_MAX.get(pattern, lowerBoundString, upperBoundString), maxPos + 5);
                }
                this.boundRange = upperBound - this.lowerBound + 1L;
                this.expressAsGeneralizedTime = false;
                String formatString = pattern.substring(formatPos + 8);
                if (formatString.equals("milliseconds")) {
                    this.expressAsMillisecondsSinceEpoch = true;
                    this.expressAsSecondsSinceEpoch = false;
                    this.dateFormatString = null;
                } else if (formatString.equals("seconds")) {
                    this.expressAsMillisecondsSinceEpoch = false;
                    this.expressAsSecondsSinceEpoch = true;
                    this.dateFormatString = null;
                } else {
                    this.expressAsMillisecondsSinceEpoch = false;
                    this.expressAsSecondsSinceEpoch = false;
                    this.dateFormatString = formatString;
                    try {
                        new SimpleDateFormat(this.dateFormatString);
                    }
                    catch (Exception e) {
                        throw new ParseException(UtilityMessages.ERR_TIMESTAMP_VALUE_PATTERN_CANNOT_PARSE_FORMAT_STRING.get(pattern, this.dateFormatString), formatPos + 8);
                    }
                }
            }
        } else if (pattern.startsWith("timestamp:format=")) {
            if (pattern.contains(":min=") || pattern.contains(":max=")) {
                throw new ParseException(UtilityMessages.ERR_TIMESTAMP_VALUE_PATTERN_FORMAT_NOT_AT_END.get(pattern), 17);
            }
            this.lowerBound = -1L;
            this.boundRange = -1L;
            this.expressAsGeneralizedTime = false;
            String formatString = pattern.substring(17);
            if (formatString.equals("milliseconds")) {
                this.expressAsMillisecondsSinceEpoch = true;
                this.expressAsSecondsSinceEpoch = false;
                this.dateFormatString = null;
            } else if (formatString.equals("seconds")) {
                this.expressAsMillisecondsSinceEpoch = false;
                this.expressAsSecondsSinceEpoch = true;
                this.dateFormatString = null;
            } else {
                this.expressAsMillisecondsSinceEpoch = false;
                this.expressAsSecondsSinceEpoch = false;
                this.dateFormatString = formatString;
                try {
                    new SimpleDateFormat(this.dateFormatString);
                }
                catch (Exception e) {
                    throw new ParseException(UtilityMessages.ERR_TIMESTAMP_VALUE_PATTERN_CANNOT_PARSE_FORMAT_STRING.get(pattern, this.dateFormatString), 17);
                }
            }
        } else {
            throw new ParseException(UtilityMessages.ERR_TIMESTAMP_VALUE_PATTERN_MALFORMED.get(pattern), 0);
        }
    }

    @Override
    void append(@NotNull StringBuilder buffer) {
        long selectedTime;
        if (this.lowerBound == -1L) {
            selectedTime = System.currentTimeMillis();
        } else {
            long positiveRandomValue = this.getRandom().nextLong() & Long.MAX_VALUE;
            selectedTime = this.lowerBound + positiveRandomValue % this.boundRange;
        }
        if (this.expressAsMillisecondsSinceEpoch) {
            buffer.append(selectedTime);
        } else if (this.expressAsSecondsSinceEpoch) {
            buffer.append(selectedTime / 1000L);
        } else if (this.expressAsGeneralizedTime) {
            buffer.append(StaticUtils.encodeGeneralizedTime(selectedTime));
        } else {
            buffer.append(this.getDateFormatter().format(new Date(selectedTime)));
        }
    }

    @Override
    boolean supportsBackReference() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Random getRandom() {
        Random random = this.threadLocalRandoms.get();
        if (random == null) {
            Random random2 = this.seedRandom;
            synchronized (random2) {
                random = new Random(this.seedRandom.nextLong());
            }
            this.threadLocalRandoms.set(random);
        }
        return random;
    }

    @NotNull
    private SimpleDateFormat getDateFormatter() {
        SimpleDateFormat dateFormatter = this.threadLocalDateFormatters.get();
        if (dateFormatter == null) {
            dateFormatter = new SimpleDateFormat(this.dateFormatString);
            this.threadLocalDateFormatters.set(dateFormatter);
        }
        return dateFormatter;
    }
}

