/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import com.google.common.base.Strings;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPBindException;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.ResultCode;
import org.apache.james.core.Username;
import org.apache.james.user.api.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyLDAPUser
implements User {
    public static final Logger LOGGER = LoggerFactory.getLogger(ReadOnlyLDAPUser.class);
    private final Username userName;
    private final DN userDN;
    private final LDAPConnectionPool connectionPool;

    public ReadOnlyLDAPUser(Username userName, DN userDN, LDAPConnectionPool connectionPool) {
        this.userName = userName;
        this.userDN = userDN;
        this.connectionPool = connectionPool;
    }

    public Username getUserName() {
        return this.userName;
    }

    public boolean setPassword(String newPass) {
        return false;
    }

    public boolean verifyPassword(String password) {
        if (Strings.isNullOrEmpty((String)password)) {
            LOGGER.info("Error. Password is empty for {}", (Object)this.userName.asString());
            return false;
        }
        try {
            BindResult bindResult = this.connectionPool.bindAndRevertAuthentication(this.userDN.toString(), password, new Control[0]);
            return bindResult.getResultCode() == ResultCode.SUCCESS;
        }
        catch (LDAPBindException e) {
            LOGGER.info("Error binding LDAP for {}: {}", (Object)this.userName.asString(), (Object)e.getMessage());
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error upon authentication for {}", (Object)this.userName.asString(), (Object)e);
            return false;
        }
    }
}

