/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.internal.querybuilder.ArithmeticOperator;
import com.datastax.oss.driver.internal.querybuilder.select.ArithmeticSelector;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class BinaryArithmeticSelector
extends ArithmeticSelector {
    private final Selector left;
    private final Selector right;
    private final CqlIdentifier alias;

    public BinaryArithmeticSelector(@NonNull ArithmeticOperator operator, @NonNull Selector left, @NonNull Selector right) {
        this(operator, left, right, null);
    }

    public BinaryArithmeticSelector(@NonNull ArithmeticOperator operator, @NonNull Selector left, @NonNull Selector right, @Nullable CqlIdentifier alias) {
        super(operator);
        Preconditions.checkNotNull((Object)left);
        Preconditions.checkNotNull((Object)right);
        this.left = left;
        this.right = right;
        this.alias = alias;
    }

    @Override
    @NonNull
    public Selector as(@NonNull CqlIdentifier alias) {
        return new BinaryArithmeticSelector(this.operator, this.left, this.right, alias);
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        BinaryArithmeticSelector.appendAndMaybeParenthesize(this.operator.getPrecedenceLeft(), this.left, builder);
        builder.append(this.operator.getSymbol());
        BinaryArithmeticSelector.appendAndMaybeParenthesize(this.operator.getPrecedenceRight(), this.right, builder);
        if (this.alias != null) {
            builder.append(" AS ").append(this.alias.asCql(true));
        }
    }

    @NonNull
    public Selector getLeft() {
        return this.left;
    }

    @NonNull
    public Selector getRight() {
        return this.right;
    }

    @Override
    @Nullable
    public CqlIdentifier getAlias() {
        return this.alias;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof BinaryArithmeticSelector) {
            BinaryArithmeticSelector that = (BinaryArithmeticSelector)other;
            return this.operator.equals((Object)that.operator) && this.left.equals(that.left) && this.right.equals(that.right) && Objects.equals(this.alias, that.alias);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.left, this.right, this.alias});
    }
}

