/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail.dao;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.mail.Flags;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.backends.postgres.utils.PostgresUtils;
import org.apache.james.core.Domain;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.PostgresMessageId;
import org.apache.james.mailbox.postgres.mail.PostgresMessageDataDefinition;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxMessageDAOUtils;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxMessageFetchStrategy;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.util.streams.Limit;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SortField;
import org.jooq.TableOnConditionStep;
import org.jooq.UpdateConditionStep;
import org.jooq.UpdateSetFirstStep;
import org.jooq.UpdateSetStep;
import org.jooq.impl.DSL;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresMailboxMessageDAO {
    private static final TableOnConditionStep<Record> MESSAGES_JOIN_MAILBOX_MESSAGES_CONDITION_STEP = PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME.join(PostgresMessageDataDefinition.MessageTable.TABLE_NAME).on(PostgresCommons.tableField(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME, PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID).eq(PostgresCommons.tableField(PostgresMessageDataDefinition.MessageTable.TABLE_NAME, PostgresMessageDataDefinition.MessageTable.MESSAGE_ID)));
    public static final SortField<Long> DEFAULT_SORT_ORDER_BY = PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.asc();
    private static final int QUERY_BATCH_SIZE = PostgresUtils.QUERY_BATCH_SIZE;
    private final PostgresExecutor postgresExecutor;

    public PostgresMailboxMessageDAO(PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public Mono<MessageUid> findFirstUnseenMessageUid(PostgresMailboxId mailboxId) {
        return this.postgresExecutor.executeRow(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.IS_SEEN.eq((Object)false)).orderBy(DEFAULT_SORT_ORDER_BY).limit((Number)1))).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_UID_FUNCTION);
    }

    public Flux<MessageUid> listUnseen(PostgresMailboxId mailboxId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.IS_SEEN.eq((Object)false)).orderBy(DEFAULT_SORT_ORDER_BY)), true).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_UID_FUNCTION);
    }

    public Flux<MessageUid> listUnseen(PostgresMailboxId mailboxId, MessageRange range) {
        return switch (range.getType()) {
            default -> throw new MatchException(null, null);
            case MessageRange.Type.ALL -> this.listUnseen(mailboxId);
            case MessageRange.Type.FROM -> this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.IS_SEEN.eq((Object)false)).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterOrEqual((Object)range.getUidFrom().asLong())).orderBy(DEFAULT_SORT_ORDER_BY)), true).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_UID_FUNCTION);
            case MessageRange.Type.RANGE -> this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.IS_SEEN.eq((Object)false)).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterOrEqual((Object)range.getUidFrom().asLong())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.lessOrEqual((Object)range.getUidTo().asLong())).orderBy(DEFAULT_SORT_ORDER_BY)), true).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_UID_FUNCTION);
            case MessageRange.Type.ONE -> this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.IS_SEEN.eq((Object)false)).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.eq((Object)range.getUidFrom().asLong())).orderBy(DEFAULT_SORT_ORDER_BY)), true).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_UID_FUNCTION);
        };
    }

    public Flux<MessageUid> findAllRecentMessageUid(PostgresMailboxId mailboxId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.IS_RECENT.eq((Object)true)).orderBy(DEFAULT_SORT_ORDER_BY)), true).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_UID_FUNCTION);
    }

    public Flux<MessageUid> listAllMessageUid(PostgresMailboxId mailboxId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).orderBy(DEFAULT_SORT_ORDER_BY)), true).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_UID_FUNCTION);
    }

    public Flux<MessageUid> listUids(PostgresMailboxId mailboxId, MessageRange range) {
        if (range.getType() == MessageRange.Type.ALL) {
            return this.listAllMessageUid(mailboxId);
        }
        return this.doListUids(mailboxId, range);
    }

    private Flux<MessageUid> doListUids(PostgresMailboxId mailboxId, MessageRange range) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterOrEqual((Object)range.getUidFrom().asLong())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.lessOrEqual((Object)range.getUidTo().asLong())).orderBy(DEFAULT_SORT_ORDER_BY)), true).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_UID_FUNCTION);
    }

    public Mono<MessageMetaData> deleteByMailboxIdAndMessageUid(PostgresMailboxId mailboxId, MessageUid messageUid) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.eq((Object)messageUid.asLong())).returning(PostgresMailboxMessageDAOUtils.MESSAGE_METADATA_FIELDS_REQUIRE))).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_METADATA_FUNCTION);
    }

    public Flux<MessageMetaData> deleteByMailboxIdAndMessageUids(PostgresMailboxId mailboxId, List<MessageUid> uids) {
        if (uids.isEmpty()) {
            return Flux.empty();
        }
        Function<List, Flux> deletePublisherFunction = uidsToDelete -> this.postgresExecutor.executeDeleteAndReturnList(dslContext -> dslContext.deleteFrom(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.in((Object[])((Long[])uidsToDelete.stream().map(MessageUid::asLong).toArray(Long[]::new)))).returning(PostgresMailboxMessageDAOUtils.MESSAGE_METADATA_FIELDS_REQUIRE)).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_METADATA_FUNCTION);
        if (uids.size() <= 32) {
            return deletePublisherFunction.apply(uids);
        }
        return Flux.fromIterable((Iterable)Iterables.partition(uids, (int)32)).flatMap(deletePublisherFunction);
    }

    public Flux<PostgresMessageId> deleteByMailboxId(PostgresMailboxId mailboxId) {
        return this.postgresExecutor.executeDeleteAndReturnList(dslContext -> dslContext.deleteFrom(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).returning(new SelectFieldOrAsterisk[]{PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID})).map(record -> PostgresMessageId.Factory.of((UUID)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID))).collectList().flatMapMany(Flux::fromIterable);
    }

    public Mono<Void> deleteByMessageIdAndMailboxIds(PostgresMessageId messageId, Collection<PostgresMailboxId> mailboxIds) {
        if (mailboxIds.isEmpty()) {
            return Mono.empty();
        }
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID.eq((Object)messageId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.in((Collection)mailboxIds.stream().map(PostgresMailboxId::asUuid).collect(ImmutableList.toImmutableList())))));
    }

    public Mono<Void> deleteByMessageId(PostgresMessageId messageId) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID.eq((Object)messageId.asUuid()))));
    }

    public Mono<Integer> countTotalMessagesByMailboxId(PostgresMailboxId mailboxId) {
        return this.postgresExecutor.executeCount(dslContext -> Mono.from((Publisher)dslContext.selectCount().from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid()))));
    }

    public Mono<Pair<Integer, Integer>> countTotalAndUnseenMessagesByMailboxId(PostgresMailboxId mailboxId) {
        Name totalCount = DSL.name((String)"total_count");
        Name unSeenCount = DSL.name((String)"unseen_count");
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select((SelectField)DSL.count().as(totalCount), (SelectField)DSL.count().filterWhere(PostgresMessageDataDefinition.MessageToMailboxTable.IS_SEEN.eq((Object)false)).as(unSeenCount)).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())))).map(record -> Pair.of((Object)((Integer)record.get(totalCount, Integer.class)), (Object)((Integer)record.get(unSeenCount, Integer.class))));
    }

    public Flux<Pair<SimpleMailboxMessage.Builder, Record>> findMessagesByMailboxId(PostgresMailboxId mailboxId, Limit limit, MessageMapper.FetchType fetchType) {
        if (limit.isUnlimited()) {
            return Flux.defer(() -> this.findMessagesByMailboxIdBatch(mailboxId, fetchType, Optional.empty(), QUERY_BATCH_SIZE)).expand(messages -> {
                if (messages.isEmpty() || messages.size() < QUERY_BATCH_SIZE) {
                    return Mono.empty();
                }
                return this.findMessagesByMailboxIdBatch(mailboxId, fetchType, Optional.of((Long)((Record)((Pair)messages.getLast()).getRight()).get(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID)), QUERY_BATCH_SIZE);
            }).flatMapIterable(Function.identity());
        }
        return this.findMessagesByMailboxIdBatch(mailboxId, fetchType, Optional.empty(), (Integer)limit.getLimit().get()).flatMapIterable(Function.identity());
    }

    private Mono<List<Pair<SimpleMailboxMessage.Builder, Record>>> findMessagesByMailboxIdBatch(PostgresMailboxId mailboxId, MessageMapper.FetchType fetchType, Optional<Long> messageUidFrom, int batchSize) {
        PostgresMailboxMessageFetchStrategy fetchStrategy = PostgresMailboxMessageDAOUtils.FETCH_TYPE_TO_FETCH_STRATEGY.apply(fetchType);
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(fetchStrategy.fetchFields()).from(MESSAGES_JOIN_MAILBOX_MESSAGES_CONDITION_STEP).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(messageUidFrom.map(arg_0 -> PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterThan(arg_0)).orElseGet(DSL::noCondition)).orderBy((OrderField)PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.asc()).limit((Number)batchSize))).map(record -> Pair.of((Object)fetchStrategy.toMessageBuilder().apply((Record)record), (Object)record)).collectList().switchIfEmpty(Mono.just((Object)ImmutableList.of()));
    }

    public Flux<Pair<SimpleMailboxMessage.Builder, Record>> findMessagesByMailboxIdAndBetweenUIDs(PostgresMailboxId mailboxId, MessageUid from, MessageUid to, Limit limit, MessageMapper.FetchType fetchType) {
        if (limit.isUnlimited()) {
            return Flux.defer(() -> this.findMessagesByMailboxIdAndBetweenUIDsBatch(mailboxId, PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterOrEqual((Object)from.asLong()), to, fetchType, QUERY_BATCH_SIZE)).expand(messages -> {
                if (messages.isEmpty() || messages.size() < QUERY_BATCH_SIZE) {
                    return Mono.empty();
                }
                MessageUid messageUidFrom = MessageUid.of((long)((Long)((Record)((Pair)messages.getLast()).getRight()).get(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID)));
                return this.findMessagesByMailboxIdAndBetweenUIDsBatch(mailboxId, PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterThan((Object)messageUidFrom.asLong()), to, fetchType, QUERY_BATCH_SIZE);
            }).flatMapIterable(Function.identity());
        }
        return this.findMessagesByMailboxIdAndBetweenUIDsBatch(mailboxId, PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterOrEqual((Object)from.asLong()), to, fetchType, (Integer)limit.getLimit().get()).flatMapIterable(Function.identity());
    }

    private Mono<List<Pair<SimpleMailboxMessage.Builder, Record>>> findMessagesByMailboxIdAndBetweenUIDsBatch(PostgresMailboxId mailboxId, Condition messageUidFromCondition, MessageUid to, MessageMapper.FetchType fetchType, int batchSize) {
        PostgresMailboxMessageFetchStrategy fetchStrategy = PostgresMailboxMessageDAOUtils.FETCH_TYPE_TO_FETCH_STRATEGY.apply(fetchType);
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(fetchStrategy.fetchFields()).from(MESSAGES_JOIN_MAILBOX_MESSAGES_CONDITION_STEP).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(messageUidFromCondition).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.lessOrEqual((Object)to.asLong())).orderBy((OrderField)PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.asc()).limit((Number)batchSize))).map(record -> Pair.of((Object)fetchStrategy.toMessageBuilder().apply((Record)record), (Object)record)).collectList().switchIfEmpty(Mono.just((Object)ImmutableList.of()));
    }

    public Mono<Pair<SimpleMailboxMessage.Builder, Record>> findMessageByMailboxIdAndUid(PostgresMailboxId mailboxId, MessageUid uid, MessageMapper.FetchType fetchType) {
        PostgresMailboxMessageFetchStrategy fetchStrategy = PostgresMailboxMessageDAOUtils.FETCH_TYPE_TO_FETCH_STRATEGY.apply(fetchType);
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(fetchStrategy.fetchFields()).from(MESSAGES_JOIN_MAILBOX_MESSAGES_CONDITION_STEP).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.eq((Object)uid.asLong())))).map(record -> Pair.of((Object)fetchStrategy.toMessageBuilder().apply((Record)record), (Object)record));
    }

    public Flux<Pair<SimpleMailboxMessage.Builder, Record>> findMessagesByMailboxIdAndAfterUID(PostgresMailboxId mailboxId, MessageUid from, Limit limit, MessageMapper.FetchType fetchType) {
        if (limit.isUnlimited()) {
            return Flux.defer(() -> this.findMessagesByMailboxIdAndAfterUIDBatch(mailboxId, PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterOrEqual((Object)from.asLong()), fetchType, QUERY_BATCH_SIZE)).expand(messages -> {
                if (messages.isEmpty() || messages.size() < QUERY_BATCH_SIZE) {
                    return Mono.empty();
                }
                MessageUid messageUidFrom = MessageUid.of((long)((Long)((Record)((Pair)messages.getLast()).getRight()).get(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID)));
                return this.findMessagesByMailboxIdAndAfterUIDBatch(mailboxId, PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterThan((Object)messageUidFrom.asLong()), fetchType, QUERY_BATCH_SIZE);
            }).flatMapIterable(Function.identity());
        }
        return this.findMessagesByMailboxIdAndAfterUIDBatch(mailboxId, PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterOrEqual((Object)from.asLong()), fetchType, (Integer)limit.getLimit().get()).flatMapIterable(Function.identity());
    }

    private Mono<List<Pair<SimpleMailboxMessage.Builder, Record>>> findMessagesByMailboxIdAndAfterUIDBatch(PostgresMailboxId mailboxId, Condition messageUidFromCondition, MessageMapper.FetchType fetchType, int batchSize) {
        PostgresMailboxMessageFetchStrategy fetchStrategy = PostgresMailboxMessageDAOUtils.FETCH_TYPE_TO_FETCH_STRATEGY.apply(fetchType);
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(fetchStrategy.fetchFields()).from(MESSAGES_JOIN_MAILBOX_MESSAGES_CONDITION_STEP).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(messageUidFromCondition).orderBy((OrderField)PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.asc()).limit((Number)batchSize))).map(record -> Pair.of((Object)fetchStrategy.toMessageBuilder().apply((Record)record), (Object)record)).collectList().switchIfEmpty(Mono.just((Object)ImmutableList.of()));
    }

    public Flux<SimpleMailboxMessage.Builder> findMessagesByMailboxIdAndUIDs(PostgresMailboxId mailboxId, List<MessageUid> uids) {
        if (uids.isEmpty()) {
            return Flux.empty();
        }
        PostgresMailboxMessageFetchStrategy fetchStrategy = PostgresMailboxMessageFetchStrategy.METADATA;
        Function<List, Flux> queryPublisherFunction = uidsToFetch -> this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(fetchStrategy.fetchFields()).from(MESSAGES_JOIN_MAILBOX_MESSAGES_CONDITION_STEP).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.in((Object[])((Long[])uidsToFetch.stream().map(MessageUid::asLong).toArray(Long[]::new)))).orderBy(DEFAULT_SORT_ORDER_BY)), true).map(fetchStrategy.toMessageBuilder());
        if (uids.size() <= 32) {
            return queryPublisherFunction.apply(uids);
        }
        return Flux.fromIterable((Iterable)Iterables.partition(uids, (int)32)).flatMap(queryPublisherFunction);
    }

    public Flux<MessageUid> findDeletedMessagesByMailboxId(PostgresMailboxId mailboxId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.IS_DELETED.eq((Object)true)).orderBy(DEFAULT_SORT_ORDER_BY)), true).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_UID_FUNCTION);
    }

    public Flux<MessageUid> findDeletedMessagesByMailboxIdAndBetweenUIDs(PostgresMailboxId mailboxId, MessageUid from, MessageUid to) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.IS_DELETED.eq((Object)true)).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterOrEqual((Object)from.asLong())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.lessOrEqual((Object)to.asLong())).orderBy(DEFAULT_SORT_ORDER_BY)), true).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_UID_FUNCTION);
    }

    public Flux<MessageUid> findDeletedMessagesByMailboxIdAndAfterUID(PostgresMailboxId mailboxId, MessageUid from) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.IS_DELETED.eq((Object)true)).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterOrEqual((Object)from.asLong())).orderBy(DEFAULT_SORT_ORDER_BY)), true).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_UID_FUNCTION);
    }

    public Mono<MessageUid> findDeletedMessageByMailboxIdAndUid(PostgresMailboxId mailboxId, MessageUid uid) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.IS_DELETED.eq((Object)true)).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.eq((Object)uid.asLong())))).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_UID_FUNCTION);
    }

    public Flux<MessageUid> listNotDeletedUids(PostgresMailboxId mailboxId, MessageRange range) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID, PostgresMessageDataDefinition.MessageToMailboxTable.IS_DELETED).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterOrEqual((Object)range.getUidFrom().asLong())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.lessOrEqual((Object)range.getUidTo().asLong())).and(PostgresMessageDataDefinition.MessageToMailboxTable.IS_DELETED.eq((Object)false)).orderBy(DEFAULT_SORT_ORDER_BY)), true).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_UID_FUNCTION);
    }

    public Mono<Boolean> existsByMessageId(PostgresMessageId messageId) {
        return this.postgresExecutor.executeExists(dslContext -> dslContext.selectOne().from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID.eq((Object)messageId.asUuid())));
    }

    public Flux<ComposedMessageIdWithMetaData> findMessagesMetadata(PostgresMailboxId mailboxId, MessageRange range) {
        return Flux.defer(() -> this.findMessagesMetadataBatch(mailboxId, range.getUidTo(), PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterOrEqual((Object)range.getUidFrom().asLong()), QUERY_BATCH_SIZE)).expand(messages -> {
            if (messages.isEmpty() || messages.size() < QUERY_BATCH_SIZE) {
                return Mono.empty();
            }
            MessageUid messageUidFrom = ((ComposedMessageIdWithMetaData)messages.getLast()).getComposedMessageId().getUid();
            return this.findMessagesMetadataBatch(mailboxId, range.getUidTo(), PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterThan((Object)messageUidFrom.asLong()), QUERY_BATCH_SIZE);
        }).flatMapIterable(Function.identity());
    }

    private Mono<List<ComposedMessageIdWithMetaData>> findMessagesMetadataBatch(PostgresMailboxId mailboxId, MessageUid messageUidTo, Condition messageUidFromCondition, int batchSize) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(new SelectFieldOrAsterisk[0]).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(messageUidFromCondition).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.lessOrEqual((Object)messageUidTo.asLong())).orderBy((OrderField)PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.asc()).limit((Number)batchSize))).map(PostgresMailboxMessageDAOUtils.RECORD_TO_COMPOSED_MESSAGE_ID_WITH_META_DATA_FUNCTION).collectList().switchIfEmpty(Mono.just((Object)ImmutableList.of()));
    }

    public Flux<ComposedMessageIdWithMetaData> findAllRecentMessageMetadata(PostgresMailboxId mailboxId) {
        return Flux.defer(() -> this.findAllRecentMessageMetadataBatch(mailboxId, Optional.empty(), QUERY_BATCH_SIZE)).expand(messages -> {
            if (messages.isEmpty() || messages.size() < QUERY_BATCH_SIZE) {
                return Mono.empty();
            }
            return this.findAllRecentMessageMetadataBatch(mailboxId, Optional.of(((ComposedMessageIdWithMetaData)messages.getLast()).getComposedMessageId().getUid()), QUERY_BATCH_SIZE);
        }).flatMapIterable(Function.identity());
    }

    private Mono<List<ComposedMessageIdWithMetaData>> findAllRecentMessageMetadataBatch(PostgresMailboxId mailboxId, Optional<MessageUid> messageUidFrom, int batchSize) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(new SelectFieldOrAsterisk[0]).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.IS_RECENT.eq((Object)true)).and(messageUidFrom.map(messageUid -> PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.greaterThan((Object)messageUid.asLong())).orElseGet(DSL::noCondition)).orderBy((OrderField)PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.asc()).limit((Number)batchSize))).map(PostgresMailboxMessageDAOUtils.RECORD_TO_COMPOSED_MESSAGE_ID_WITH_META_DATA_FUNCTION).collectList().switchIfEmpty(Mono.just((Object)ImmutableList.of()));
    }

    public Mono<Flags> replaceFlags(PostgresMailboxId mailboxId, MessageUid uid, Flags newFlags, ModSeq newModSeq) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)this.buildReplaceFlagsStatement((DSLContext)dslContext, newFlags, mailboxId, uid, newModSeq).returning(PostgresMailboxMessageDAOUtils.MESSAGE_METADATA_FIELDS_REQUIRE))).map(PostgresMailboxMessageDAOUtils.RECORD_TO_FLAGS_FUNCTION);
    }

    public Mono<Flags> addFlags(PostgresMailboxId mailboxId, MessageUid uid, Flags appendFlags, ModSeq newModSeq) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)this.buildAddFlagsStatement((DSLContext)dslContext, appendFlags, mailboxId, uid, newModSeq).returning(PostgresMailboxMessageDAOUtils.MESSAGE_METADATA_FIELDS_REQUIRE))).map(PostgresMailboxMessageDAOUtils.RECORD_TO_FLAGS_FUNCTION);
    }

    public Mono<Flags> removeFlags(PostgresMailboxId mailboxId, MessageUid uid, Flags removeFlags, ModSeq newModSeq) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)this.buildRemoveFlagsStatement((DSLContext)dslContext, removeFlags, mailboxId, uid, newModSeq).returning(PostgresMailboxMessageDAOUtils.MESSAGE_METADATA_FIELDS_REQUIRE))).map(PostgresMailboxMessageDAOUtils.RECORD_TO_FLAGS_FUNCTION);
    }

    private UpdateConditionStep<Record> buildAddFlagsStatement(DSLContext dslContext, Flags addFlags, PostgresMailboxId mailboxId, MessageUid uid, ModSeq newModSeq) {
        AtomicReference<UpdateSetFirstStep> updateStatement = new AtomicReference<UpdateSetFirstStep>(dslContext.update(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME));
        PostgresMailboxMessageDAOUtils.BOOLEAN_FLAGS_MAPPING.forEach((flagColumn, flagMapped) -> {
            if (addFlags.contains(flagMapped)) {
                updateStatement.getAndUpdate(currentStatement -> currentStatement.set(flagColumn, (Object)true));
            }
        });
        if (addFlags.getUserFlags() != null && addFlags.getUserFlags().length > 0) {
            if (addFlags.getUserFlags().length == 1) {
                updateStatement.getAndUpdate(currentStatement -> currentStatement.set(PostgresMessageDataDefinition.MessageToMailboxTable.USER_FLAGS, DSL.arrayAppend(PostgresMessageDataDefinition.MessageToMailboxTable.USER_FLAGS, (Object)addFlags.getUserFlags()[0])));
            } else {
                updateStatement.getAndUpdate(currentStatement -> currentStatement.set(PostgresMessageDataDefinition.MessageToMailboxTable.USER_FLAGS, DSL.arrayConcat(PostgresMessageDataDefinition.MessageToMailboxTable.USER_FLAGS, (Object[])addFlags.getUserFlags())));
            }
        }
        return ((UpdateSetStep)updateStatement.get()).set(PostgresMessageDataDefinition.MessageToMailboxTable.MOD_SEQ, (Object)newModSeq.asLong()).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.eq((Object)uid.asLong()));
    }

    private UpdateConditionStep<Record> buildReplaceFlagsStatement(DSLContext dslContext, Flags newFlags, PostgresMailboxId mailboxId, MessageUid uid, ModSeq newModSeq) {
        AtomicReference<UpdateSetFirstStep> updateStatement = new AtomicReference<UpdateSetFirstStep>(dslContext.update(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME));
        PostgresMailboxMessageDAOUtils.BOOLEAN_FLAGS_MAPPING.forEach((flagColumn, flagMapped) -> updateStatement.getAndUpdate(currentStatement -> currentStatement.set(flagColumn, (Object)newFlags.contains(flagMapped))));
        return ((UpdateSetStep)updateStatement.get()).set(PostgresMessageDataDefinition.MessageToMailboxTable.USER_FLAGS, (Object)newFlags.getUserFlags()).set(PostgresMessageDataDefinition.MessageToMailboxTable.MOD_SEQ, (Object)newModSeq.asLong()).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.eq((Object)uid.asLong()));
    }

    private UpdateConditionStep<Record> buildRemoveFlagsStatement(DSLContext dslContext, Flags removeFlags, PostgresMailboxId mailboxId, MessageUid uid, ModSeq newModSeq) {
        AtomicReference<UpdateSetFirstStep> updateStatement = new AtomicReference<UpdateSetFirstStep>(dslContext.update(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME));
        PostgresMailboxMessageDAOUtils.BOOLEAN_FLAGS_MAPPING.forEach((flagColumn, flagMapped) -> {
            if (removeFlags.contains(flagMapped)) {
                updateStatement.getAndUpdate(currentStatement -> currentStatement.set(flagColumn, (Object)false));
            }
        });
        if (removeFlags.getUserFlags() != null && removeFlags.getUserFlags().length > 0) {
            if (removeFlags.getUserFlags().length == 1) {
                updateStatement.getAndUpdate(currentStatement -> currentStatement.set(PostgresMessageDataDefinition.MessageToMailboxTable.USER_FLAGS, DSL.arrayRemove(PostgresMessageDataDefinition.MessageToMailboxTable.USER_FLAGS, (Object)removeFlags.getUserFlags()[0])));
            } else {
                updateStatement.getAndUpdate(currentStatement -> currentStatement.set(PostgresMessageDataDefinition.MessageToMailboxTable.USER_FLAGS, DSL.function((String)"remove_elements_from_array", String[].class, (Field[])new Field[]{PostgresMessageDataDefinition.MessageToMailboxTable.USER_FLAGS, DSL.array((Object[])removeFlags.getUserFlags())})));
            }
        }
        return ((UpdateSetStep)updateStatement.get()).set(PostgresMessageDataDefinition.MessageToMailboxTable.MOD_SEQ, (Object)newModSeq.asLong()).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.eq((Object)uid.asLong()));
    }

    public Mono<Flags> listDistinctUserFlags(PostgresMailboxId mailboxId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectDistinct((SelectField)PostgresCommons.UNNEST_FIELD.apply(PostgresMessageDataDefinition.MessageToMailboxTable.USER_FLAGS)).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())))).map(record -> (String)record.get(0, String.class)).collectList().map(flagList -> {
            Flags flags = new Flags();
            flagList.forEach(arg_0 -> ((Flags)flags).add(arg_0));
            return flags;
        });
    }

    public Flux<MessageMetaData> resetRecentFlag(PostgresMailboxId mailboxId, List<MessageUid> uids, ModSeq newModSeq) {
        if (uids.isEmpty()) {
            return Flux.empty();
        }
        Function<List, Flux> queryPublisherFunction = uidsMatching -> this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.update(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).set(PostgresMessageDataDefinition.MessageToMailboxTable.IS_RECENT, (Object)false).set(PostgresMessageDataDefinition.MessageToMailboxTable.MOD_SEQ, (Object)newModSeq.asLong()).where(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID.in((Object[])((Long[])uidsMatching.stream().map(MessageUid::asLong).toArray(Long[]::new)))).and(PostgresMessageDataDefinition.MessageToMailboxTable.MOD_SEQ.notEqual((Object)newModSeq.asLong())).returning(PostgresMailboxMessageDAOUtils.MESSAGE_METADATA_FIELDS_REQUIRE))).map(PostgresMailboxMessageDAOUtils.RECORD_TO_MESSAGE_METADATA_FUNCTION);
        if (uids.size() <= 32) {
            return queryPublisherFunction.apply(uids);
        }
        return Flux.fromIterable((Iterable)Iterables.partition(uids, (int)32)).flatMap(queryPublisherFunction);
    }

    public Mono<Void> insert(MailboxMessage mailboxMessage) {
        return this.insert(mailboxMessage, (PostgresMailboxId)mailboxMessage.getMailboxId());
    }

    public Mono<Void> insert(MailboxMessage mailboxMessage, PostgresMailboxId mailboxId) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).set(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID, (Object)mailboxId.asUuid()).set(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID, (Object)mailboxMessage.getUid().asLong()).set(PostgresMessageDataDefinition.MessageToMailboxTable.MOD_SEQ, (Object)mailboxMessage.getModSeq().asLong()).set(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID, (Object)((PostgresMessageId)mailboxMessage.getMessageId()).asUuid()).set(PostgresMessageDataDefinition.MessageToMailboxTable.THREAD_ID, (Object)((PostgresMessageId)mailboxMessage.getThreadId().getBaseMessageId()).asUuid()).set(PostgresMessageDataDefinition.MessageTable.INTERNAL_DATE, (Object)((LocalDateTime)PostgresCommons.DATE_TO_LOCAL_DATE_TIME.apply(mailboxMessage.getInternalDate()))).set(PostgresMessageDataDefinition.MessageTable.SIZE, (Object)mailboxMessage.getFullContentOctets()).set(PostgresMessageDataDefinition.MessageToMailboxTable.IS_DELETED, (Object)mailboxMessage.isDeleted()).set(PostgresMessageDataDefinition.MessageToMailboxTable.IS_ANSWERED, (Object)mailboxMessage.isAnswered()).set(PostgresMessageDataDefinition.MessageToMailboxTable.IS_DRAFT, (Object)mailboxMessage.isDraft()).set(PostgresMessageDataDefinition.MessageToMailboxTable.IS_FLAGGED, (Object)mailboxMessage.isFlagged()).set(PostgresMessageDataDefinition.MessageToMailboxTable.IS_RECENT, (Object)mailboxMessage.isRecent()).set(PostgresMessageDataDefinition.MessageToMailboxTable.IS_SEEN, (Object)mailboxMessage.isSeen()).set(PostgresMessageDataDefinition.MessageToMailboxTable.USER_FLAGS, (Object)mailboxMessage.createFlags().getUserFlags()).set(PostgresMessageDataDefinition.MessageToMailboxTable.SAVE_DATE, (Object)mailboxMessage.getSaveDate().map(PostgresCommons.DATE_TO_LOCAL_DATE_TIME).orElse(null))));
    }

    public Flux<MailboxId> findMailboxes(PostgresMessageId messageId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID.eq((Object)messageId.asUuid()))), true).map(record -> PostgresMailboxId.of((UUID)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID)));
    }

    public Flux<Pair<SimpleMailboxMessage.Builder, Record>> findMessagesByMessageIds(Collection<PostgresMessageId> messageIds, MessageMapper.FetchType fetchType) {
        if (messageIds.isEmpty()) {
            return Flux.empty();
        }
        PostgresMailboxMessageFetchStrategy fetchStrategy = PostgresMailboxMessageDAOUtils.FETCH_TYPE_TO_FETCH_STRATEGY.apply(fetchType);
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(fetchStrategy.fetchFields()).from(MESSAGES_JOIN_MAILBOX_MESSAGES_CONDITION_STEP).where(DSL.field((String)(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME.getName() + "." + PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID.getName())).in((Collection)messageIds.stream().map(PostgresMessageId::asUuid).collect(ImmutableList.toImmutableList())))), true).map(record -> Pair.of((Object)fetchStrategy.toMessageBuilder().apply((Record)record), (Object)record));
    }

    public Flux<ComposedMessageIdWithMetaData> findMetadataByMessageId(PostgresMessageId messageId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(new SelectFieldOrAsterisk[0]).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID.eq((Object)messageId.asUuid()))), true).map(PostgresMailboxMessageDAOUtils.RECORD_TO_COMPOSED_MESSAGE_ID_WITH_META_DATA_FUNCTION);
    }

    public Flux<ComposedMessageIdWithMetaData> findMetadataByMessageId(PostgresMessageId messageId, PostgresMailboxId mailboxId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(new SelectFieldOrAsterisk[0]).from(PostgresMessageDataDefinition.MessageToMailboxTable.TABLE_NAME).where(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID.eq((Object)messageId.asUuid())).and(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID.eq((Object)mailboxId.asUuid()))), true).map(PostgresMailboxMessageDAOUtils.RECORD_TO_COMPOSED_MESSAGE_ID_WITH_META_DATA_FUNCTION);
    }

    public static class Factory {
        private final PostgresExecutor.Factory executorFactory;

        @Inject
        @Singleton
        public Factory(PostgresExecutor.Factory executorFactory) {
            this.executorFactory = executorFactory;
        }

        public PostgresMailboxMessageDAO create(Optional<Domain> domain) {
            return new PostgresMailboxMessageDAO(this.executorFactory.create(domain));
        }
    }
}

