/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.PropertyManager;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class BouncyCastleFIPSHelper {
    @NotNull
    private static final AtomicReference<Provider> BOUNCY_CASTLE_FIPS_PROVIDER_REF = new AtomicReference();
    @NotNull
    private static final AtomicReference<Provider> BOUNCY_CASTLE_JSSE_PROVIDER_REF = new AtomicReference();
    @NotNull
    private static final AtomicReference<Class<?>> BOUNCY_CASTLE_FIPS_PROVIDER_CLASS_REF = new AtomicReference();
    @NotNull
    private static final AtomicReference<Class<?>> BOUNCY_CASTLE_JSSE_PROVIDER_CLASS_REF = new AtomicReference();
    @NotNull
    public static final String BOUNCY_CASTLE_FIPS_PROVIDER_CLASS_NAME = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";
    @NotNull
    public static final String BOUNCY_CASTLE_JSSE_PROVIDER_CLASS_NAME = "org.bouncycastle.jsse.provider.BouncyCastleJsseProvider";
    @NotNull
    public static final String FIPS_PROVIDER_NAME = "BCFIPS";
    @NotNull
    public static final String FIPS_PROVIDER_VERSION_1 = "1";
    @NotNull
    public static final String FIPS_PROVIDER_VERSION_2 = "2";
    @NotNull
    public static final String FIPS_PROVIDER_VERSION_DEFAULT = "1";
    @NotNull
    public static final String JSSE_PROVIDER_NAME = "BCJSSE";
    @NotNull
    public static final String FIPS_KEY_STORE_TYPE = "BCFKS";
    @NotNull
    public static final String DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM = "X.509";
    @NotNull
    public static final String DEFAULT_SSL_CONTEXT_PROTOCOL = "DEFAULT";
    @NotNull
    public static final String[] ALTERNATIVE_DEFAULT_SSL_CONTEXT_PROTOCOLS = new String[]{"TLSv1.3", "TLSv1.2"};
    @NotNull
    public static final String DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM = "PKIX";
    @NotNull
    public static final String PROPERTY_ALLOW_RSA_MULTI_USE = "org.bouncycastle.rsa.allow_multi_use";
    @NotNull
    public static final String PROPERTY_APPROVED_ONLY = "org.bouncycastle.fips.approved_only";
    @NotNull
    public static final String PROPERTY_ENABLE_JKS = "org.bouncycastle.jca.enable_jks";
    @NotNull
    public static final String PROPERTY_ENABLE_MD5 = "org.bouncycastle.jsse.enable_md5";
    @NotNull
    public static final String PROPERTY_ENABLE_LOGGING = BouncyCastleFIPSHelper.class.getName() + ".ENABLE_LOGGING";
    @NotNull
    public static final String PROPERTY_LOG_LEVEL = BouncyCastleFIPSHelper.class.getName() + ".LOG_LEVEL";
    @NotNull
    private static final String LOGGER_NAME = "org.bouncycastle";
    @NotNull
    private static final Logger LOGGER = Logger.getLogger("org.bouncycastle");

    private BouncyCastleFIPSHelper() {
    }

    @NotNull
    public static Provider getBouncyCastleFIPSProvider() throws NoSuchProviderException {
        return BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider(null);
    }

    @NotNull
    public static Provider getBouncyCastleFIPSProvider(@Nullable String versionString) throws NoSuchProviderException {
        Provider cachedProvider = BOUNCY_CASTLE_FIPS_PROVIDER_REF.get();
        if (cachedProvider != null) {
            return cachedProvider;
        }
        return BouncyCastleFIPSHelper.loadBouncyCastleFIPSProvider(false, versionString);
    }

    static void setPropertiesForPingIdentityServer() {
        if (InternalSDKHelper.getPingIdentityServerRoot() == null) {
            return;
        }
        StaticUtils.setSystemPropertyIfNotAlreadyDefined(PROPERTY_APPROVED_ONLY, "true");
        StaticUtils.setSystemPropertyIfNotAlreadyDefined(PROPERTY_ALLOW_RSA_MULTI_USE, "true");
        StaticUtils.setSystemPropertyIfNotAlreadyDefined(PROPERTY_ENABLE_MD5, "true");
    }

    @NotNull
    static synchronized Provider loadBouncyCastleFIPSProvider(boolean makeDefault) throws NoSuchProviderException {
        return BouncyCastleFIPSHelper.loadBouncyCastleFIPSProvider(makeDefault, null);
    }

    @NotNull
    static synchronized Provider loadBouncyCastleFIPSProvider(boolean makeDefault, @Nullable String versionString) throws NoSuchProviderException {
        Class<?> fipsProviderClass;
        block19: {
            int versionNumber = BouncyCastleFIPSHelper.parseVersionString(FIPS_PROVIDER_NAME, versionString);
            try {
                Provider existingProvider = Security.getProvider(FIPS_PROVIDER_NAME);
                if (existingProvider != null) {
                    BOUNCY_CASTLE_FIPS_PROVIDER_REF.compareAndSet(null, existingProvider);
                    return existingProvider;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            fipsProviderClass = BOUNCY_CASTLE_FIPS_PROVIDER_CLASS_REF.get();
            if (fipsProviderClass == null) {
                try {
                    fipsProviderClass = Class.forName(BOUNCY_CASTLE_FIPS_PROVIDER_CLASS_NAME);
                    BOUNCY_CASTLE_FIPS_PROVIDER_CLASS_REF.set(fipsProviderClass);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    boolean shouldThrow = true;
                    try {
                        File instanceRoot = InternalSDKHelper.getPingIdentityServerRoot();
                        if (instanceRoot != null) {
                            File fipsProviderJarFile = null;
                            File fipsJSSEProviderJarFile = null;
                            ArrayList<File> additionalFIPSProviderJarFiles = new ArrayList<File>();
                            File resourceDir = new File(instanceRoot, "resource");
                            File bcDir = new File(resourceDir, "bc");
                            File fipsDir = versionNumber == 2 ? new File(bcDir, "fips2") : new File(bcDir, "fips");
                            if (fipsDir.exists()) {
                                for (File f : fipsDir.listFiles()) {
                                    String name = f.getName();
                                    if (name.startsWith("bc-fips-") && name.endsWith(".jar")) {
                                        fipsProviderJarFile = f;
                                        continue;
                                    }
                                    if (name.startsWith("bctls-fips-") && name.endsWith(".jar")) {
                                        fipsJSSEProviderJarFile = f;
                                        continue;
                                    }
                                    if (!name.endsWith(".jar")) continue;
                                    additionalFIPSProviderJarFiles.add(f);
                                }
                            }
                            if (fipsProviderJarFile != null && fipsJSSEProviderJarFile != null) {
                                ArrayList<File> fipsJarFiles = new ArrayList<File>();
                                fipsJarFiles.add(fipsProviderJarFile);
                                fipsJarFiles.add(fipsJSSEProviderJarFile);
                                fipsJarFiles.addAll(additionalFIPSProviderJarFiles);
                                URL[] fileURLs = new URL[fipsJarFiles.size()];
                                for (int i = 0; i < fileURLs.length; ++i) {
                                    fileURLs[i] = ((File)fipsJarFiles.get(i)).toURI().toURL();
                                }
                                URLClassLoader classLoader = new URLClassLoader(fileURLs, BouncyCastleFIPSHelper.class.getClassLoader());
                                fipsProviderClass = classLoader.loadClass(BOUNCY_CASTLE_FIPS_PROVIDER_CLASS_NAME);
                                BOUNCY_CASTLE_FIPS_PROVIDER_CLASS_REF.set(fipsProviderClass);
                                Class<?> jsseProviderClass = classLoader.loadClass(BOUNCY_CASTLE_JSSE_PROVIDER_CLASS_NAME);
                                BOUNCY_CASTLE_JSSE_PROVIDER_CLASS_REF.set(jsseProviderClass);
                                shouldThrow = false;
                            }
                        }
                    }
                    catch (Exception e2) {
                        Debug.debugException(e2);
                    }
                    if (!shouldThrow) break block19;
                    throw new NoSuchProviderException(UtilityMessages.ERR_BC_FIPS_HELPER_CANNOT_LOAD_FIPS_PROVIDER_CLASS.get(BOUNCY_CASTLE_FIPS_PROVIDER_CLASS_NAME, StaticUtils.getExceptionMessage(e)));
                }
            }
        }
        try {
            Constructor<?> constructor = fipsProviderClass.getConstructor(String.class);
            Provider provider = (Provider)constructor.newInstance("C:HYBRID;ENABLE{All};");
            if (makeDefault) {
                Security.insertProviderAt(provider, 1);
            } else {
                Security.addProvider(provider);
            }
            BOUNCY_CASTLE_FIPS_PROVIDER_REF.set(provider);
            return provider;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new NoSuchProviderException(UtilityMessages.ERR_BC_FIPS_PROVIDER_CANNOT_INSTANTIATE_FIPS_PROVIDER.get(BOUNCY_CASTLE_FIPS_PROVIDER_CLASS_NAME, StaticUtils.getExceptionMessage(e)));
        }
    }

    private static int parseVersionString(@NotNull String providerName, @Nullable String versionString) throws NoSuchProviderException {
        if (versionString == null || versionString.equalsIgnoreCase(FIPS_PROVIDER_NAME) || versionString.equalsIgnoreCase(providerName)) {
            return 1;
        }
        if (versionString.equalsIgnoreCase("1") || versionString.equalsIgnoreCase("BCFIPS1") || versionString.equalsIgnoreCase(providerName + "1")) {
            return 1;
        }
        if (versionString.equalsIgnoreCase(FIPS_PROVIDER_VERSION_2) || versionString.equalsIgnoreCase("BCFIPS2") || versionString.equalsIgnoreCase(providerName + FIPS_PROVIDER_VERSION_2)) {
            return 2;
        }
        throw new NoSuchProviderException(UtilityMessages.ERR_BC_FIPS_HELPER_UNSUPPORTED_VERSION.get(versionString, providerName, "1", FIPS_PROVIDER_VERSION_2));
    }

    @NotNull
    public static Provider getBouncyCastleJSSEProvider() throws NoSuchProviderException {
        return BouncyCastleFIPSHelper.getBouncyCastleJSSEProvider(null);
    }

    @NotNull
    public static Provider getBouncyCastleJSSEProvider(@Nullable String versionString) throws NoSuchProviderException {
        Provider cachedProvider = BOUNCY_CASTLE_JSSE_PROVIDER_REF.get();
        if (cachedProvider != null) {
            return cachedProvider;
        }
        return BouncyCastleFIPSHelper.loadBouncyCastleJSSEProvider(false, versionString);
    }

    @NotNull
    static synchronized Provider loadBouncyCastleJSSEProvider(boolean makeSecond) throws NoSuchProviderException {
        return BouncyCastleFIPSHelper.loadBouncyCastleJSSEProvider(makeSecond, null);
    }

    @NotNull
    static synchronized Provider loadBouncyCastleJSSEProvider(boolean makeSecond, @Nullable String versionString) throws NoSuchProviderException {
        BouncyCastleFIPSHelper.parseVersionString(JSSE_PROVIDER_NAME, versionString);
        try {
            Provider existingProvider = Security.getProvider(JSSE_PROVIDER_NAME);
            if (existingProvider != null) {
                BOUNCY_CASTLE_JSSE_PROVIDER_REF.compareAndSet(null, existingProvider);
                return existingProvider;
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        Class<?> jsseProviderClass = BOUNCY_CASTLE_JSSE_PROVIDER_CLASS_REF.get();
        if (jsseProviderClass == null) {
            try {
                jsseProviderClass = Class.forName(BOUNCY_CASTLE_JSSE_PROVIDER_CLASS_NAME);
                BOUNCY_CASTLE_JSSE_PROVIDER_CLASS_REF.set(jsseProviderClass);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new NoSuchProviderException(UtilityMessages.ERR_BC_FIPS_HELPER_CANNOT_LOAD_JSSE_PROVIDER_CLASS.get(BOUNCY_CASTLE_JSSE_PROVIDER_CLASS_NAME, StaticUtils.getExceptionMessage(e)));
            }
        }
        try {
            Constructor<?> constructor = jsseProviderClass.getConstructor(String.class);
            Provider provider = (Provider)constructor.newInstance("fips:BCFIPS");
            if (makeSecond) {
                Security.insertProviderAt(provider, 2);
            } else {
                Security.addProvider(provider);
            }
            BOUNCY_CASTLE_JSSE_PROVIDER_REF.set(provider);
            return provider;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new NoSuchProviderException(UtilityMessages.ERR_BC_FIPS_PROVIDER_CANNOT_INSTANTIATE_JSSE_PROVIDER.get(BOUNCY_CASTLE_JSSE_PROVIDER_CLASS_NAME, StaticUtils.getExceptionMessage(e)));
        }
    }

    public static void disableLogging() {
        StaticUtils.setLoggerLevel(LOGGER, Level.OFF);
        LOGGER.setUseParentHandlers(false);
    }

    @NotNull
    public static Logger enableLogging(@Nullable Level level) {
        StaticUtils.setLoggerLevel(LOGGER, level == null ? Level.INFO : level);
        return LOGGER;
    }

    static {
        LOGGER.setUseParentHandlers(false);
        if (PropertyManager.getBoolean(PROPERTY_ENABLE_LOGGING, false).booleanValue()) {
            Level level = Level.INFO;
            String levelPropertyValue = PropertyManager.get(PROPERTY_LOG_LEVEL);
            if (levelPropertyValue != null) {
                switch (StaticUtils.toUpperCase(levelPropertyValue)) {
                    case "SEVERE": {
                        level = Level.SEVERE;
                        break;
                    }
                    case "WARNING": {
                        level = Level.WARNING;
                        break;
                    }
                    case "INFO": {
                        level = Level.INFO;
                        break;
                    }
                    case "CONFIG": {
                        level = Level.CONFIG;
                        break;
                    }
                    case "FINE": {
                        level = Level.FINE;
                        break;
                    }
                    case "FINER": {
                        level = Level.FINER;
                        break;
                    }
                    case "FINEST": {
                        level = Level.FINEST;
                        break;
                    }
                    case "ALL": {
                        level = Level.ALL;
                        break;
                    }
                    case "OFF": {
                        level = Level.OFF;
                        break;
                    }
                    default: {
                        Validator.violation("Unsupported " + PROPERTY_LOG_LEVEL + " property value '" + levelPropertyValue + "'.");
                    }
                }
            }
            StaticUtils.setLoggerLevel(LOGGER, level);
        } else {
            StaticUtils.setLoggerLevel(LOGGER, Level.OFF);
        }
    }
}

