/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.protocols;

import jakarta.inject.Inject;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.james.pop3server.netty.POP3ServerFactory;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.utils.GuiceProbe;

public class Pop3GuiceProbe
implements GuiceProbe {
    private final POP3ServerFactory pop3ServerFactory;

    @Inject
    private Pop3GuiceProbe(POP3ServerFactory pop3ServerFactory) {
        this.pop3ServerFactory = pop3ServerFactory;
    }

    public int getPop3Port() {
        return this.pop3ServerFactory.getServers().stream().findFirst().flatMap(server -> server.getListenAddresses().stream().findFirst()).map(InetSocketAddress::getPort).orElseThrow(() -> new IllegalStateException("POP3 server not defined"));
    }

    public Optional<Integer> getPort(Predicate<? super AbstractConfigurableAsyncServer> filter) {
        return this.pop3ServerFactory.getServers().stream().filter(filter).findFirst().flatMap(server -> server.getListenAddresses().stream().findFirst()).map(InetSocketAddress::getPort);
    }
}

