/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import java.util.Collection;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.TemporaryResolutionException;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class RecipientHasMXRecord
extends GenericMatcher {
    private final DNSService dnsService;
    private ImmutableList<String> expectedMxRecords;

    @Inject
    public RecipientHasMXRecord(DNSService dnsService) {
        this.dnsService = dnsService;
    }

    public void init() throws MessagingException {
        this.expectedMxRecords = (ImmutableList)Splitter.on((char)',').splitToStream((CharSequence)this.getCondition()).map(Domain::of).map(Domain::asString).sorted().collect(ImmutableList.toImmutableList());
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        return (Collection)mail.getRecipients().stream().filter(this::matchesExpectedMxRecord).collect(ImmutableList.toImmutableList());
    }

    private boolean matchesExpectedMxRecord(MailAddress address) {
        try {
            ImmutableList mxRecords = (ImmutableList)this.dnsService.findMXRecords(address.getDomain().asString()).stream().sorted().collect(ImmutableList.toImmutableList());
            return this.expectedMxRecords.equals((Object)mxRecords);
        }
        catch (TemporaryResolutionException e) {
            return false;
        }
    }
}

