/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws.sse;

import com.github.fge.lambdas.Throwing;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.objectstorage.aws.sse.S3SSECConfiguration;
import org.apache.james.blob.objectstorage.aws.sse.S3SSECustomerKeyGenerator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface S3SSECustomerKeyFactory {
    public Publisher<SSECustomerKey> generate(BucketName var1, BlobId var2);

    public static class SingleCustomerKeyFactory
    implements S3SSECustomerKeyFactory {
        private final SSECustomerKey sseCustomerKey;

        public SingleCustomerKeyFactory(S3SSECConfiguration.Basic sseCustomerConfiguration) throws InvalidKeySpecException, NoSuchAlgorithmException {
            S3SSECustomerKeyGenerator sseCustomerKeyGenerator = (S3SSECustomerKeyGenerator)sseCustomerConfiguration.customerKeyFactoryAlgorithm().map(Throwing.function(S3SSECustomerKeyGenerator::new)).orElseGet(Throwing.supplier(S3SSECustomerKeyGenerator::new));
            String customerKey = sseCustomerKeyGenerator.generateCustomerKey(sseCustomerConfiguration.masterPassword(), sseCustomerConfiguration.salt());
            String customerMd5 = sseCustomerKeyGenerator.generateCustomerKeyMd5(customerKey);
            this.sseCustomerKey = new SSECustomerKey(customerKey, customerMd5, sseCustomerConfiguration.ssecAlgorithm());
        }

        public Mono<SSECustomerKey> generate(BucketName bucketName, BlobId blobId) {
            return Mono.just((Object)this.sseCustomerKey);
        }
    }

    public record SSECustomerKey(String customerKey, String md5, String ssecAlgorithm) {
    }
}

