/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.github.fge.lambdas.Throwing;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import jakarta.inject.Inject;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueueFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class RabbitMQMailQueueConsumerHealthCheck
implements HealthCheck {
    public static final ComponentName COMPONENT_NAME = new ComponentName("RabbitMQMailQueueConsumersHealthCheck");
    public static final ComponentName COMPONENT = new ComponentName("MailQueueConsumers");
    private final RabbitMQMailQueueFactory queueFactory;
    private final Set<SimpleConnectionPool.ReconnectionHandler> reconnectionHandlers;
    private final SimpleConnectionPool connectionPool;

    @Inject
    public RabbitMQMailQueueConsumerHealthCheck(RabbitMQMailQueueFactory queueFactory, Set<SimpleConnectionPool.ReconnectionHandler> reconnectionHandlers, SimpleConnectionPool connectionPool) {
        this.queueFactory = queueFactory;
        this.reconnectionHandlers = reconnectionHandlers;
        this.connectionPool = connectionPool;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        return this.connectionPool.getResilientConnection().flatMap(connection -> Mono.using(() -> ((Connection)connection).createChannel(), channel -> this.check((Connection)connection, (Channel)channel), (Consumer)Throwing.consumer(Channel::close))).subscribeOn(Schedulers.boundedElastic());
    }

    private Mono<Result> check(Connection connection, Channel channel) {
        boolean queueWithoutConsumers = this.queueFactory.listCreatedMailQueues().stream().map(org.apache.james.queue.api.MailQueueName::asString).map(MailQueueName::fromString).map(m -> m.toWorkQueueName().asString()).anyMatch((Predicate<String>)Throwing.predicate(queue -> channel.consumerCount(queue) == 0L));
        if (queueWithoutConsumers) {
            return Mono.fromRunnable(() -> this.reconnectionHandlers.forEach(r -> r.handleReconnection(connection))).thenReturn((Object)Result.degraded((ComponentName)COMPONENT, (String)"No consumers"));
        }
        return Mono.just((Object)Result.healthy((ComponentName)COMPONENT));
    }
}

