/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.lambdas.Throwing;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;
import org.apache.james.jwt.CheckTokenClient;
import org.apache.james.jwt.introspection.IntrospectionEndpoint;
import org.apache.james.jwt.introspection.TokenIntrospectionException;
import org.apache.james.jwt.introspection.TokenIntrospectionResponse;
import org.apache.james.jwt.userinfo.UserInfoCheckException;
import org.apache.james.jwt.userinfo.UserinfoResponse;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufMono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.resources.ConnectionProvider;

public class DefaultCheckTokenClient
implements CheckTokenClient {
    public static final String TOKEN_ATTRIBUTE = "token";
    public static final int PENDING_ACQUIRE_MAX = Optional.ofNullable(System.getProperty("james.oidc.client.pending.acquire.max")).map(Integer::valueOf).orElse(10000);
    private final HttpClient httpClient = HttpClient.create((ConnectionProvider)((ConnectionProvider.Builder)ConnectionProvider.builder((String)this.getClass().getName()).pendingAcquireMaxCount(PENDING_ACQUIRE_MAX)).build()).disableRetry(true).headers(builder -> {
        builder.add("Accept", (Object)"application/json");
        builder.add("Content-Type", (Object)"application/x-www-form-urlencoded");
    });
    private final ObjectMapper deserializer = new ObjectMapper();

    @Override
    public Publisher<TokenIntrospectionResponse> introspect(IntrospectionEndpoint introspectionEndpoint, String token) {
        return ((HttpClient.RequestSender)this.httpClient.headers(builder -> introspectionEndpoint.getAuthorizationHeader().ifPresent(auth -> builder.add("Authorization", auth))).post().uri(introspectionEndpoint.getUrl().toString())).sendForm((req, form) -> form.multipart(false).attr(TOKEN_ATTRIBUTE, token)).responseSingle(this::afterHTTPResponseIntrospectHandler);
    }

    @Override
    public Publisher<UserinfoResponse> userInfo(URL userinfoEndpoint, String bearerToken) {
        return ((HttpClient.ResponseReceiver)this.httpClient.headers(builder -> builder.add("Authorization", (Object)("Bearer " + bearerToken))).get().uri(userinfoEndpoint.toString())).responseSingle(this::afterHTTPResponseUserinfoHandler);
    }

    private Mono<TokenIntrospectionResponse> afterHTTPResponseIntrospectHandler(HttpClientResponse httpClientResponse, ByteBufMono dataBuf) {
        return Mono.just((Object)httpClientResponse.status()).filter(httpStatus -> httpStatus.equals((Object)HttpResponseStatus.OK)).flatMap(httpStatus -> dataBuf.asByteArray()).map((Function)Throwing.function(arg_0 -> ((ObjectMapper)this.deserializer).readTree(arg_0))).map(TokenIntrospectionResponse::parse).onErrorResume(error -> Mono.error((Throwable)new TokenIntrospectionException("Error when introspecting token.", (Throwable)error))).switchIfEmpty(dataBuf.asString(StandardCharsets.UTF_8).switchIfEmpty(Mono.just((Object)"")).flatMap(errorResponse -> Mono.error((Throwable)new TokenIntrospectionException(String.format("Error when introspecting token. \nResponse Status = %s,\n Response Body = %s", httpClientResponse.status().code(), errorResponse)))));
    }

    private Mono<UserinfoResponse> afterHTTPResponseUserinfoHandler(HttpClientResponse httpClientResponse, ByteBufMono dataBuf) {
        return Mono.just((Object)httpClientResponse.status()).filter(arg_0 -> ((HttpResponseStatus)HttpResponseStatus.OK).equals(arg_0)).flatMap(httpStatus -> dataBuf.asByteArray()).map((Function)Throwing.function(arg_0 -> ((ObjectMapper)this.deserializer).readTree(arg_0))).map(UserinfoResponse::new).onErrorResume(error -> Mono.error((Throwable)new UserInfoCheckException("Error when check token by userInfo.", (Throwable)error))).switchIfEmpty(dataBuf.asString(StandardCharsets.UTF_8).switchIfEmpty(Mono.just((Object)"")).flatMap(errorResponse -> Mono.error((Throwable)new UserInfoCheckException(String.format("Error when check token by userInfo. \nResponse Status = %s,\n Response Body = %s", httpClientResponse.status().code(), errorResponse)))));
    }
}

