/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mailbox.quota.model.HistoryEvolution;
import org.apache.james.mailbox.quota.model.QuotaThreshold;
import org.apache.james.mailbox.quota.model.QuotaThresholdChange;

public class QuotaThresholdHistory {
    private final ImmutableList<QuotaThresholdChange> changes;

    public QuotaThresholdHistory() {
        this((List<QuotaThresholdChange>)ImmutableList.of());
    }

    public QuotaThresholdHistory(QuotaThresholdChange ... changes) {
        this(Arrays.asList(changes));
    }

    public QuotaThresholdHistory(List<QuotaThresholdChange> changes) {
        this.changes = (ImmutableList)changes.stream().sorted(Comparator.comparing(QuotaThresholdChange::getInstant)).collect(ImmutableList.toImmutableList());
    }

    public HistoryEvolution compareWithCurrentThreshold(QuotaThresholdChange thresholdChange, Duration gracePeriod) {
        Optional<QuotaThreshold> lastThreshold = Optional.ofNullable((QuotaThresholdChange)Iterables.getLast(this.changes, null)).map(QuotaThresholdChange::getQuotaThreshold);
        return this.compareWithCurrentThreshold(thresholdChange, gracePeriod, lastThreshold.orElse(QuotaThreshold.ZERO));
    }

    private HistoryEvolution compareWithCurrentThreshold(QuotaThresholdChange thresholdChange, Duration gracePeriod, QuotaThreshold lastThreshold) {
        QuotaThreshold quotaThreshold = thresholdChange.getQuotaThreshold();
        int comparisonResult = quotaThreshold.compareTo(lastThreshold);
        if (comparisonResult < 0) {
            return HistoryEvolution.lowerThresholdReached(thresholdChange);
        }
        if (comparisonResult == 0) {
            return HistoryEvolution.noChanges();
        }
        return this.recentlyExceededQuotaThreshold(thresholdChange, gracePeriod).map(any -> HistoryEvolution.higherThresholdReached(thresholdChange, HistoryEvolution.HighestThresholdRecentness.AlreadyReachedDuringGracePeriod)).orElse(HistoryEvolution.higherThresholdReached(thresholdChange, HistoryEvolution.HighestThresholdRecentness.NotAlreadyReachedDuringGracePeriod));
    }

    private Optional<QuotaThresholdChange> recentlyExceededQuotaThreshold(QuotaThresholdChange thresholdChange, Duration gracePeriod) {
        return this.changes.stream().filter(change -> change.isAfter(thresholdChange.getInstant().minus(gracePeriod))).filter(change -> change.getQuotaThreshold().compareTo(thresholdChange.getQuotaThreshold()) >= 0).findFirst();
    }

    public QuotaThresholdHistory combineWith(QuotaThresholdChange change) {
        return new QuotaThresholdHistory((List<QuotaThresholdChange>)ImmutableList.builder().addAll(this.changes).add((Object)change).build());
    }

    public ImmutableList<QuotaThresholdChange> getChanges() {
        return this.changes;
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaThresholdHistory) {
            QuotaThresholdHistory that = (QuotaThresholdHistory)o;
            return Objects.equals(this.changes, that.changes);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.changes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("changes", this.changes).toString();
    }
}

