/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.RecoverableChannel;
import com.rabbitmq.client.RecoverableConnection;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.IdempotentClosedConnection;
import reactor.rabbitmq.RabbitFluxException;

public abstract class Utils {
    public static Mono<? extends Connection> singleConnectionMono(ConnectionFactory connectionFactory) {
        return Utils.singleConnectionMono(connectionFactory, cf -> cf.newConnection());
    }

    public static Mono<? extends Connection> singleConnectionMono(ConnectionFactory cf, ExceptionFunction<ConnectionFactory, ? extends Connection> function) {
        return Mono.fromCallable(() -> new IdempotentClosedConnection((Connection)function.apply(cf))).cache();
    }

    public static Mono<? extends Connection> singleConnectionMono(Callable<? extends Connection> supplier) {
        return Mono.fromCallable(() -> new IdempotentClosedConnection((Connection)supplier.call())).cache();
    }

    public static ExceptionFunction<ConnectionFactory, ? extends Connection> singleConnectionSupplier(ConnectionFactory cf, ExceptionFunction<ConnectionFactory, ? extends Connection> supplier) {
        return new SingleConnectionSupplier(() -> (Connection)supplier.apply(cf));
    }

    public static ExceptionFunction<ConnectionFactory, ? extends Connection> singleConnectionSupplier(ConnectionFactory cf) {
        return new SingleConnectionSupplier(() -> cf.newConnection());
    }

    public static ExceptionFunction<ConnectionFactory, ? extends Connection> singleConnectionSupplier(Callable<? extends Connection> supplier) {
        return new SingleConnectionSupplier(supplier);
    }

    public static <T> Mono<T> cache(Mono<T> mono) {
        return mono.cache(element -> Duration.ofMillis(Long.MAX_VALUE), throwable -> Duration.ZERO, () -> Duration.ZERO);
    }

    static boolean isRecoverable(Connection connection) {
        return connection instanceof RecoverableConnection;
    }

    static boolean isRecoverable(Channel channel) {
        return channel instanceof RecoverableChannel;
    }

    public static class SingleConnectionSupplier
    implements ExceptionFunction<ConnectionFactory, Connection> {
        private final Callable<? extends Connection> creationAction;
        private final Duration waitTimeout;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final AtomicBoolean created = new AtomicBoolean(false);
        private final AtomicReference<Connection> connection = new AtomicReference();

        public SingleConnectionSupplier(Callable<? extends Connection> creationAction) {
            this(creationAction, Duration.ofMinutes(5L));
        }

        public SingleConnectionSupplier(Callable<? extends Connection> creationAction, Duration waitTimeout) {
            this.creationAction = creationAction;
            this.waitTimeout = waitTimeout;
        }

        @Override
        public Connection apply(ConnectionFactory connectionFactory) throws Exception {
            if (this.created.compareAndSet(false, true)) {
                this.connection.set(new IdempotentClosedConnection(this.creationAction.call()));
                this.latch.countDown();
            } else {
                boolean reachedZero = this.latch.await(this.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
                if (!reachedZero) {
                    if (this.connection.get() != null) {
                        return this.connection.get();
                    }
                    throw new RabbitFluxException("Reached timeout when waiting for connection to be created: " + this.waitTimeout);
                }
            }
            return this.connection.get();
        }
    }

    @FunctionalInterface
    public static interface ExceptionFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

