/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.netty.handler.traffic.ChannelTrafficShapingHandler;
import io.netty.handler.traffic.TrafficCounter;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.ConnectionDescription;
import org.apache.james.core.ConnectionDescriptionSupplier;
import org.apache.james.core.Disconnector;
import org.apache.james.core.Username;
import org.apache.james.imap.api.ConnectionCheck;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imapserver.netty.HAProxyMessageHandler;
import org.apache.james.imapserver.netty.IMAPCommandsThrottler;
import org.apache.james.imapserver.netty.IMAPServerMBean;
import org.apache.james.imapserver.netty.ImapChannelUpstreamHandler;
import org.apache.james.imapserver.netty.ImapIdleStateHandler;
import org.apache.james.imapserver.netty.ImapMetrics;
import org.apache.james.imapserver.netty.ImapRequestFrameDecoder;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.imapserver.netty.ReactiveThrottler;
import org.apache.james.imapserver.netty.SwitchableLineBasedFrameDecoderFactory;
import org.apache.james.imapserver.netty.TrafficShapingConfiguration;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.protocols.api.OidcSASLConfiguration;
import org.apache.james.protocols.api.ProxyInformation;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.netty.AbstractChannelPipelineFactory;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.ConnectionLimitUpstreamHandler;
import org.apache.james.protocols.netty.ConnectionPerIpLimitUpstreamHandler;
import org.apache.james.protocols.netty.Encryption;
import org.apache.james.util.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMAPServer
extends AbstractConfigurableAsyncServer
implements ImapConstants,
IMAPServerMBean,
NettyConstants,
Disconnector,
ConnectionDescriptionSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(IMAPServer.class);
    public static final AttributeKey<Instant> CONNECTION_DATE = AttributeKey.newInstance((String)"connectionDate");
    private static final String SOFTWARE_TYPE = "JAMES IMAP4rev1 Server ";
    private static final String DEFAULT_TIME_UNIT = "SECONDS";
    private static final String CAPABILITY_SEPARATOR = "|";
    public static final int DEFAULT_MAX_LINE_LENGTH = 65536;
    public static final Size DEFAULT_IN_MEMORY_SIZE_LIMIT = Size.of((Long)10L, (Size.Unit)Size.Unit.M);
    public static final int DEFAULT_TIMEOUT = 1800;
    public static final int DEFAULT_LITERAL_SIZE_LIMIT = 0;
    private final ImapProcessor processor;
    private final ImapEncoder encoder;
    private final ImapDecoder decoder;
    private final ImapMetrics imapMetrics;
    private final GaugeRegistry gaugeRegistry;
    private final Set<ConnectionCheck> connectionChecks;
    private final DefaultChannelGroup imapChannelGroup;
    private String hello;
    private boolean compress;
    private int maxLineLength;
    private int inMemorySizeLimit;
    private int timeout;
    private int literalSizeLimit;
    private AuthenticationConfiguration authenticationConfiguration;
    private Optional<TrafficShapingConfiguration> trafficShaping = Optional.empty();
    private Optional<ConnectionLimitUpstreamHandler> connectionLimitUpstreamHandler = Optional.empty();
    private Optional<ConnectionPerIpLimitUpstreamHandler> connectionPerIpLimitUpstreamHandler = Optional.empty();
    private Optional<IMAPCommandsThrottler.ThrottlerConfiguration> throttlerConfiguration = Optional.empty();
    private boolean ignoreIDLEUponProcessing;
    private Duration heartbeatInterval;
    private ReactiveThrottler reactiveThrottler;

    public IMAPServer(ImapDecoder decoder, ImapEncoder encoder, ImapProcessor processor, ImapMetrics imapMetrics, GaugeRegistry gaugeRegistry, Set<ConnectionCheck> connectionChecks) {
        this.processor = processor;
        this.encoder = encoder;
        this.decoder = decoder;
        this.imapMetrics = imapMetrics;
        this.gaugeRegistry = gaugeRegistry;
        this.connectionChecks = connectionChecks;
        this.imapChannelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    public void doConfigure(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        super.doConfigure(configuration);
        this.hello = SOFTWARE_TYPE + this.getHelloName() + " is ready.";
        this.compress = configuration.getBoolean("compress", false);
        this.maxLineLength = configuration.getInt("maxLineLength", 65536);
        this.inMemorySizeLimit = Math.toIntExact(Optional.ofNullable(configuration.getString("inMemorySizeLimit", null)).map(Size::parse).orElse(DEFAULT_IN_MEMORY_SIZE_LIMIT).asBytes());
        this.literalSizeLimit = IMAPServer.parseLiteralSizeLimit(configuration);
        this.timeout = configuration.getInt("timeout", 1800);
        if (this.timeout < 1800) {
            throw new ConfigurationException("Minimum timeout of 30 minutes required. See rfc2060 5.4 for details");
        }
        this.authenticationConfiguration = AuthenticationConfiguration.parse(configuration);
        this.connectionLimitUpstreamHandler = ConnectionLimitUpstreamHandler.forCount((int)this.connectionLimit);
        this.connectionPerIpLimitUpstreamHandler = ConnectionPerIpLimitUpstreamHandler.forCount((int)this.connPerIP);
        this.ignoreIDLEUponProcessing = configuration.getBoolean("ignoreIDLEUponProcessing", true);
        ImapConfiguration imapConfiguration = IMAPServer.getImapConfiguration(configuration);
        this.heartbeatInterval = imapConfiguration.idleTimeIntervalAsDuration();
        this.reactiveThrottler = new ReactiveThrottler(this.gaugeRegistry, imapConfiguration.getConcurrentRequests(), imapConfiguration.getMaxQueueSize());
        this.processor.configure(imapConfiguration);
        if (configuration.getKeys("trafficShaping").hasNext()) {
            this.trafficShaping = Optional.ofNullable(configuration.configurationAt("trafficShaping")).map(TrafficShapingConfiguration::from);
        }
        if (configuration.getKeys("perSessionCommandThrottling").hasNext()) {
            this.throttlerConfiguration = Optional.ofNullable(configuration.configurationAt("perSessionCommandThrottling")).map(IMAPCommandsThrottler.ThrottlerConfiguration::from);
        }
    }

    public void disconnect(Predicate<Username> user) {
        this.imapChannelGroup.stream().filter(channel -> Optional.ofNullable((ImapSession)channel.attr(IMAP_SESSION_ATTRIBUTE_KEY).get()).flatMap(session -> Optional.ofNullable(session.getUserName())).map(user::test).orElse(false)).forEach(channel -> channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE));
    }

    private static Integer parseLiteralSizeLimit(HierarchicalConfiguration<ImmutableNode> configuration) {
        return Optional.ofNullable(configuration.getString("literalSizeLimit", null)).map(Size::parse).map(Size::asBytes).map(Math::toIntExact).orElse(0);
    }

    @VisibleForTesting
    static ImapConfiguration getImapConfiguration(HierarchicalConfiguration<ImmutableNode> configuration) {
        ImmutableSet disabledCaps = ImmutableSet.copyOf((Iterable)Splitter.on((String)CAPABILITY_SEPARATOR).split((CharSequence)configuration.getString("disabledCaps", "")));
        return ImapConfiguration.builder().enableIdle(Boolean.valueOf(configuration.getBoolean("enableIdle", true))).idleTimeInterval(configuration.getLong("idleTimeInterval", 120L)).idleTimeIntervalUnit(IMAPServer.getTimeIntervalUnit(configuration.getString("idleTimeIntervalUnit", DEFAULT_TIME_UNIT))).disabledCaps(disabledCaps).appendLimit(Optional.of(IMAPServer.parseLiteralSizeLimit(configuration)).filter(i -> i > 0)).maxQueueSize(configuration.getInteger("maxQueueSize", Integer.valueOf(4096)).intValue()).concurrentRequests(configuration.getInteger("concurrentRequests", Integer.valueOf(128)).intValue()).isProvisionDefaultMailboxes(Boolean.valueOf(configuration.getBoolean("provisionDefaultMailboxes", true))).withCustomProperties(configuration.getProperties("customProperties")).idFieldsResponse(IMAPServer.getIdCommandResponseFields(configuration)).build();
    }

    private static ImmutableMap<String, String> getIdCommandResponseFields(HierarchicalConfiguration<ImmutableNode> configuration) {
        LinkedHashMap fieldsMap = new LinkedHashMap();
        configuration.configurationsAt("idCommandResponse.field").forEach(field -> {
            String name = field.getString("[@name]");
            String value = field.getString("[@value]");
            fieldsMap.put(name, value);
        });
        return ImmutableMap.copyOf(fieldsMap);
    }

    private static TimeUnit getTimeIntervalUnit(String timeIntervalUnit) {
        try {
            return TimeUnit.valueOf(timeIntervalUnit);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Time interval unit is not valid {}, the default {} value should be used", (Object)timeIntervalUnit, (Object)ImapConfiguration.DEFAULT_HEARTBEAT_INTERVAL_UNIT);
            return ImapConfiguration.DEFAULT_HEARTBEAT_INTERVAL_UNIT;
        }
    }

    public int getDefaultPort() {
        return 143;
    }

    public String getServiceType() {
        return "IMAP Service";
    }

    protected AbstractChannelPipelineFactory createPipelineFactory() {
        return new AbstractChannelPipelineFactory(this.getFrameHandlerFactory(), this.getExecutorGroup()){

            protected ChannelInboundHandlerAdapter createHandler() {
                return IMAPServer.this.createCoreHandler();
            }

            public void initChannel(Channel channel) {
                channel.attr(CONNECTION_DATE).set((Object)Clock.systemUTC().instant());
                ChannelPipeline pipeline = channel.pipeline();
                channel.config().setWriteBufferWaterMark(IMAPServer.this.writeBufferWaterMark);
                pipeline.addLast("timeoutHandler", (ChannelHandler)new ImapIdleStateHandler(IMAPServer.this.timeout));
                IMAPServer.this.connectionLimitUpstreamHandler.ifPresent(handler -> pipeline.addLast("connectionLimitHandler", (ChannelHandler)handler));
                IMAPServer.this.connectionPerIpLimitUpstreamHandler.ifPresent(handler -> pipeline.addLast("connectionPerIpLimitHandler", (ChannelHandler)handler));
                if (IMAPServer.this.proxyRequired) {
                    pipeline.addLast("proxyHandler", (ChannelHandler)new HAProxyMessageDecoder());
                    pipeline.addLast("proxyInformationHandler", (ChannelHandler)new HAProxyMessageHandler(IMAPServer.this.connectionChecks));
                }
                pipeline.addLast("framer", IMAPServer.this.getFrameHandlerFactory().create(pipeline));
                Encryption secure = IMAPServer.this.getEncryption();
                if (secure != null && !secure.isStartTLS()) {
                    if (IMAPServer.this.proxyRequired && IMAPServer.this.proxyFirst) {
                        channel.pipeline().addAfter("proxyInformationHandler", "sslHandler", (ChannelHandler)secure.sslHandler());
                    } else {
                        channel.pipeline().addFirst("sslHandler", (ChannelHandler)secure.sslHandler());
                    }
                }
                IMAPServer.this.trafficShaping.map(TrafficShapingConfiguration::newHandler).ifPresent(handler -> pipeline.addLast("trafficShaping", (ChannelHandler)handler));
                pipeline.addLast("chunkWriteHandler", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("requestDecoder", (ChannelHandler)new ImapRequestFrameDecoder(IMAPServer.this.decoder, IMAPServer.this.inMemorySizeLimit, IMAPServer.this.literalSizeLimit, IMAPServer.this.maxLineLength));
                IMAPServer.this.throttlerConfiguration.map(IMAPCommandsThrottler::new).ifPresent(handler -> pipeline.addLast("commandThrottler", (ChannelHandler)handler));
                pipeline.addLast("coreHandler", (ChannelHandler)IMAPServer.this.createCoreHandler());
            }
        };
    }

    protected String getDefaultJMXName() {
        return "imapserver";
    }

    protected ChannelInboundHandlerAdapter createCoreHandler() {
        Encryption secure = this.getEncryption();
        return ImapChannelUpstreamHandler.builder().reactiveThrottler(this.reactiveThrottler).hello(this.hello).processor(this.processor).encoder(this.encoder).compress(this.compress).authenticationConfiguration(this.authenticationConfiguration).connectionChecks(this.connectionChecks).secure(secure).imapMetrics(this.imapMetrics).heartbeatInterval(this.heartbeatInterval).ignoreIDLEUponProcessing(this.ignoreIDLEUponProcessing).proxyRequired(this.proxyRequired).imapChannelGroup((ChannelGroup)this.imapChannelGroup).build();
    }

    protected ChannelHandlerFactory createFrameHandlerFactory() {
        return new SwitchableLineBasedFrameDecoderFactory(this.maxLineLength);
    }

    public Set<ConnectionCheck> getConnectionChecks() {
        return this.connectionChecks;
    }

    public boolean isReactiveThrottlerQueueFull() {
        return this.reactiveThrottler.isQueueFull();
    }

    @VisibleForTesting
    ReactiveThrottler getReactiveThrottler() {
        return this.reactiveThrottler;
    }

    public Stream<ConnectionDescription> describeConnections() {
        return this.imapChannelGroup.stream().map(channel -> {
            Optional<ImapSession> imapSession = Optional.ofNullable((ImapSession)channel.attr(IMAP_SESSION_ATTRIBUTE_KEY).get());
            Optional<TrafficCounter> trafficCounter = Optional.ofNullable((ChannelTrafficShapingHandler)channel.pipeline().get(ChannelTrafficShapingHandler.class)).map(AbstractTrafficShapingHandler::trafficCounter);
            return new ConnectionDescription("IMAP", this.jmxName, Optional.ofNullable(channel.attr(HAProxyMessageHandler.PROXY_INFO)).flatMap(attr -> Optional.ofNullable((ProxyInformation)attr.get())).map(proxyInfo -> proxyInfo.getSource()).or(() -> Optional.ofNullable(channel.remoteAddress())).map(this::addressAsString), Optional.ofNullable(channel.attr(CONNECTION_DATE)).flatMap(attribute -> Optional.ofNullable((Instant)attribute.get())), channel.isActive(), channel.isOpen(), channel.isWritable(), imapSession.map(ImapSession::isTLSActive).orElse(false).booleanValue(), imapSession.flatMap(session -> Optional.ofNullable(session.getUserName())), (Map)ImmutableMap.builder().put((Object)"loggedInUser", (Object)imapSession.flatMap(s -> Optional.ofNullable(s.getMailboxSession())).flatMap(MailboxSession::getLoggedInUser).map(Username::asString).orElse("")).put((Object)"isCompressed", (Object)Boolean.toString(imapSession.map(ImapSession::isCompressionActive).orElse(false))).put((Object)"selectedMailbox", (Object)imapSession.flatMap(session -> Optional.ofNullable(session.getSelected())).map(SelectedMailbox::getMailboxId).map(MailboxId::serialize).orElse("")).put((Object)"isIdling", (Object)Boolean.toString(imapSession.flatMap(session -> Optional.ofNullable(session.getSelected())).map(SelectedMailbox::isIdling).orElse(false))).put((Object)"requestCount", (Object)Long.toString(Optional.ofNullable(channel.attr(REQUEST_COUNTER)).flatMap(attribute -> Optional.ofNullable((AtomicLong)attribute.get())).map(AtomicLong::get).orElse(0L))).put((Object)"userAgent", (Object)imapSession.flatMap(s -> Optional.ofNullable(s.getAttribute("userAgent"))).map(Object::toString).orElse("")).put((Object)"cumulativeWrittenBytes", (Object)Long.toString(trafficCounter.map(TrafficCounter::cumulativeWrittenBytes).orElse(0L))).put((Object)"cumulativeReadBytes", (Object)Long.toString(trafficCounter.map(TrafficCounter::cumulativeReadBytes).orElse(0L))).put((Object)"liveReadThroughputBytePerSecond", (Object)Long.toString(trafficCounter.map(TrafficCounter::lastReadThroughput).orElse(0L))).put((Object)"liveWriteThroughputBytePerSecond", (Object)Long.toString(trafficCounter.map(TrafficCounter::lastWriteThroughput).orElse(0L))).build());
        });
    }

    private String addressAsString(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)socketAddress;
            return address.getAddress().getHostAddress();
        }
        return socketAddress.toString();
    }

    public static class AuthenticationConfiguration {
        private static final boolean PLAIN_AUTH_DISALLOWED_DEFAULT = true;
        private static final boolean PLAIN_AUTH_ENABLED_DEFAULT = true;
        private static final String OIDC_PATH = "auth.oidc";
        private final boolean isSSLRequired;
        private final boolean plainAuthEnabled;
        private final Optional<OidcSASLConfiguration> oidcSASLConfiguration;

        public static AuthenticationConfiguration parse(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
            boolean isRequireSSL = configuration.getBoolean("auth.requireSSL", AuthenticationConfiguration.fallback(configuration));
            boolean isPlainAuthEnabled = configuration.getBoolean("auth.plainAuthEnabled", true);
            if (configuration.immutableConfigurationsAt(OIDC_PATH).isEmpty()) {
                return new AuthenticationConfiguration(isRequireSSL, isPlainAuthEnabled);
            }
            try {
                return new AuthenticationConfiguration(isRequireSSL, isPlainAuthEnabled, OidcSASLConfiguration.parse((HierarchicalConfiguration)configuration.configurationAt(OIDC_PATH)));
            }
            catch (NullPointerException | MalformedURLException | URISyntaxException exception) {
                throw new ConfigurationException("Failed to retrieve oauth component", (Throwable)exception);
            }
        }

        private static boolean fallback(HierarchicalConfiguration<ImmutableNode> configuration) {
            return configuration.getBoolean("plainAuthDisallowed", true);
        }

        public AuthenticationConfiguration(boolean isSSLRequired, boolean plainAuthEnabled) {
            this.isSSLRequired = isSSLRequired;
            this.plainAuthEnabled = plainAuthEnabled;
            this.oidcSASLConfiguration = Optional.empty();
        }

        public AuthenticationConfiguration(boolean isSSLRequired, boolean plainAuthEnabled, OidcSASLConfiguration oidcSASLConfiguration) {
            this.isSSLRequired = isSSLRequired;
            this.plainAuthEnabled = plainAuthEnabled;
            this.oidcSASLConfiguration = Optional.of(oidcSASLConfiguration);
        }

        public boolean isSSLRequired() {
            return this.isSSLRequired;
        }

        public boolean isPlainAuthEnabled() {
            return this.plainAuthEnabled;
        }

        public Optional<OidcSASLConfiguration> getOidcSASLConfiguration() {
            return this.oidcSASLConfiguration;
        }
    }
}

