/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.RegistrationKey;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MetadataWithMailboxId;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.exception.InboxAlreadyCreated;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.extension.PreDeletionHook;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.PrefixedWildcard;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxManagerConfiguration;
import org.apache.james.mailbox.store.MailboxReactorUtils;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MessageFactory;
import org.apache.james.mailbox.store.MessageStorer;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;
import org.apache.james.util.FunctionalUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public class StoreMailboxManager
implements MailboxManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreMailboxManager.class);
    public static final char SQL_WILDCARD_CHAR = '%';
    public static final EnumSet<MailboxManager.MessageCapabilities> DEFAULT_NO_MESSAGE_CAPABILITIES = EnumSet.noneOf(MailboxManager.MessageCapabilities.class);
    public static final int MAX_ATTEMPTS = 3;
    public static final Duration MIN_BACKOFF = Duration.ofMillis(100L);
    public static final RetryBackoffSpec RETRY_BACKOFF_SPEC = Retry.backoff((long)3L, (Duration)MIN_BACKOFF);
    private static final int LOW_CONCURRENCY = 2;
    private final StoreRightManager storeRightManager;
    private final EventBus eventBus;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final MailboxAnnotationManager annotationManager;
    private final MailboxPathLocker locker;
    private final MessageParser messageParser;
    private final MessageId.Factory messageIdFactory;
    private final SessionProvider sessionProvider;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final QuotaComponents quotaComponents;
    private final MessageSearchIndex index;
    private final PreDeletionHooks preDeletionHooks;
    protected final MailboxManagerConfiguration configuration;
    private final ThreadIdGuessingAlgorithm threadIdGuessingAlgorithm;
    private final Clock clock;

    @Inject
    public StoreMailboxManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, SessionProvider sessionProvider, MailboxPathLocker locker, MessageParser messageParser, MessageId.Factory messageIdFactory, MailboxAnnotationManager annotationManager, EventBus eventBus, StoreRightManager storeRightManager, QuotaComponents quotaComponents, MessageSearchIndex searchIndex, MailboxManagerConfiguration configuration, PreDeletionHooks preDeletionHooks, ThreadIdGuessingAlgorithm threadIdGuessingAlgorithm, Clock clock) {
        Preconditions.checkNotNull((Object)eventBus);
        Preconditions.checkNotNull((Object)mailboxSessionMapperFactory);
        this.annotationManager = annotationManager;
        this.sessionProvider = sessionProvider;
        this.locker = locker;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.messageParser = messageParser;
        this.messageIdFactory = messageIdFactory;
        this.eventBus = eventBus;
        this.storeRightManager = storeRightManager;
        this.quotaRootResolver = quotaComponents.getQuotaRootResolver();
        this.quotaManager = quotaComponents.getQuotaManager();
        this.quotaComponents = quotaComponents;
        this.index = searchIndex;
        this.configuration = configuration;
        this.preDeletionHooks = preDeletionHooks;
        this.threadIdGuessingAlgorithm = threadIdGuessingAlgorithm;
        this.clock = clock;
    }

    public QuotaComponents getQuotaComponents() {
        return this.quotaComponents;
    }

    public MessageId.Factory getMessageIdFactory() {
        return this.messageIdFactory;
    }

    public SessionProvider getSessionProvider() {
        return this.sessionProvider;
    }

    public EnumSet<MailboxManager.MailboxCapabilities> getSupportedMailboxCapabilities() {
        return EnumSet.noneOf(MailboxManager.MailboxCapabilities.class);
    }

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities() {
        return DEFAULT_NO_MESSAGE_CAPABILITIES;
    }

    public EnumSet<MailboxManager.SearchCapabilities> getSupportedSearchCapabilities() {
        return this.index.getSupportedCapabilities(this.getSupportedMessageCapabilities());
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    protected MessageSearchIndex getMessageSearchIndex() {
        return this.index;
    }

    public MailboxSessionMapperFactory getMapperFactory() {
        return this.mailboxSessionMapperFactory;
    }

    protected MailboxPathLocker getLocker() {
        return this.locker;
    }

    protected StoreRightManager getStoreRightManager() {
        return this.storeRightManager;
    }

    protected MessageParser getMessageParser() {
        return this.messageParser;
    }

    protected PreDeletionHooks getPreDeletionHooks() {
        return this.preDeletionHooks;
    }

    public ThreadIdGuessingAlgorithm getThreadIdGuessingAlgorithm() {
        return this.threadIdGuessingAlgorithm;
    }

    public Clock getClock() {
        return this.clock;
    }

    public MailboxSession createSystemSession(Username userName) {
        return this.sessionProvider.createSystemSession(userName);
    }

    public SessionProvider.AuthorizationStep authenticate(Username givenUserid, String passwd) {
        return this.sessionProvider.authenticate(givenUserid, passwd);
    }

    public SessionProvider.AuthorizationStep authenticate(Username givenUserid) {
        return this.sessionProvider.authenticate(givenUserid);
    }

    protected StoreMessageManager createMessageManager(Mailbox mailbox, MailboxSession session) throws MailboxException {
        return new StoreMessageManager(DEFAULT_NO_MESSAGE_CAPABILITIES, this.getMapperFactory(), this.getMessageSearchIndex(), this.getEventBus(), this.getLocker(), mailbox, this.quotaManager, this.getQuotaComponents().getQuotaRootResolver(), this.configuration.getBatchSizes(), this.getStoreRightManager(), this.preDeletionHooks, new MessageStorer.WithoutAttachment(this.mailboxSessionMapperFactory, this.messageIdFactory, new MessageFactory.StoreMessageFactory(), this.threadIdGuessingAlgorithm, this.clock));
    }

    public MessageManager getMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return MailboxReactorUtils.block(this.getMailboxReactive(mailboxPath, session));
    }

    public Mono<MessageManager> getMailboxReactive(MailboxPath mailboxPath, MailboxSession session) {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mapper.findMailboxByPath(mailboxPath).map(Throwing.function(mailboxRow -> this.getMailbox((Mailbox)mailboxRow, session)).sneakyThrow()).switchIfEmpty(Mono.fromCallable(() -> {
            LOGGER.debug("Mailbox '{}' not found.", (Object)mailboxPath);
            throw new MailboxNotFoundException(mailboxPath);
        }));
    }

    public MessageManager getMailbox(Mailbox mailboxRow, MailboxSession session) throws MailboxException {
        MailboxPath mailboxPath = mailboxRow.generateAssociatedPath();
        if (!this.assertUserHasAccessTo(mailboxRow, session)) {
            LOGGER.info("Mailbox '{}' does not belong to user '{}' but to '{}'", new Object[]{mailboxPath, session.getUser(), mailboxRow.getUser()});
            throw new MailboxNotFoundException(mailboxPath);
        }
        LOGGER.debug("Loaded mailbox {}", (Object)mailboxPath);
        return this.createMessageManager(mailboxRow, session);
    }

    public MessageManager getMailbox(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        return MailboxReactorUtils.block(this.getMailboxReactive(mailboxId, session));
    }

    public Publisher<MessageManager> getMailboxReactive(MailboxId mailboxId, MailboxSession session) {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mapper.findMailboxById(mailboxId).map(Throwing.function(mailboxRow -> {
            if (!this.assertUserHasAccessTo((Mailbox)mailboxRow, session)) {
                LOGGER.info("Mailbox '{} {}' does not belong to user '{}' but to '{}'", new Object[]{mailboxRow.getMailboxId().serialize(), mailboxRow.generateAssociatedPath(), session.getUser(), mailboxRow.getUser()});
                throw new MailboxNotFoundException(mailboxId);
            }
            LOGGER.debug("Loaded mailbox {} {}", (Object)mailboxRow.getMailboxId().serialize(), (Object)mailboxRow.generateAssociatedPath());
            return this.createMessageManager((Mailbox)mailboxRow, session);
        }).sneakyThrow());
    }

    private boolean assertUserHasAccessTo(Mailbox mailbox, MailboxSession session) {
        return this.belongsToCurrentUser(mailbox, session) || this.userHasLookupRightsOn(mailbox, session);
    }

    private boolean belongsToCurrentUser(Mailbox mailbox, MailboxSession session) {
        return mailbox.generateAssociatedPath().belongsTo(session);
    }

    private boolean userHasLookupRightsOn(Mailbox mailbox, MailboxSession session) {
        return this.storeRightManager.hasRight(mailbox, MailboxACL.Right.Lookup, session);
    }

    public Optional<MailboxId> createMailbox(MailboxPath mailboxPath, MailboxManager.CreateOption createOption, MailboxSession mailboxSession) throws MailboxException {
        return MailboxReactorUtils.blockOptional(this.createMailboxReactive(mailboxPath, createOption, mailboxSession));
    }

    public Mono<MailboxId> createMailboxReactive(MailboxPath mailboxPath, MailboxManager.CreateOption createOption, MailboxSession mailboxSession) {
        LOGGER.debug("createMailbox {}", (Object)mailboxPath);
        return this.assertCanCreateReactive(mailboxSession, mailboxPath).then(this.doCreateMailboxReactive(mailboxPath, createOption, mailboxSession));
    }

    private Mono<Void> createSubscriptionIfNeeded(MailboxPath mailboxPath, MailboxManager.CreateOption createOption, MailboxSession session) {
        if (createOption.equals((Object)MailboxManager.CreateOption.CREATE_SUBSCRIPTION)) {
            return this.mailboxSessionMapperFactory.getSubscriptionMapper(session).saveReactive(new Subscription(session.getUser(), mailboxPath.asEscapedString()));
        }
        return Mono.empty();
    }

    private Mono<MailboxId> doCreateMailboxReactive(MailboxPath mailboxPath, MailboxManager.CreateOption createOption, MailboxSession mailboxSession) {
        if (mailboxPath.getName().isEmpty()) {
            LOGGER.warn("Ignoring mailbox with empty name");
            return Mono.empty();
        }
        try {
            MailboxPath sanitizedMailboxPath = mailboxPath.sanitize(mailboxSession.getPathDelimiter());
            sanitizedMailboxPath.assertAcceptable(mailboxSession.getPathDelimiter());
            return this.mailboxExists(sanitizedMailboxPath, mailboxSession).flatMap(exists -> {
                if (exists.booleanValue()) {
                    return Mono.error((Throwable)new MailboxExistsException(sanitizedMailboxPath.asString()));
                }
                return this.createMailboxesForPath(mailboxSession, createOption, sanitizedMailboxPath).takeLast(1).next();
            }).retryWhen((Retry)Retry.backoff((long)5L, (Duration)Duration.ofMillis(100L)).modifyErrorFilter(old -> old.and(e -> !(e instanceof MailboxException))).jitter(0.5).maxBackoff(Duration.ofSeconds(1L)));
        }
        catch (MailboxNameException e) {
            return Mono.error((Throwable)e);
        }
    }

    private Flux<MailboxId> createMailboxesForPath(MailboxSession mailboxSession, MailboxManager.CreateOption createOption, MailboxPath sanitizedMailboxPath) {
        List intermediatePaths = sanitizedMailboxPath.getHierarchyLevels(mailboxSession.getPathDelimiter());
        boolean isRootPath = intermediatePaths.size() == 1;
        return Flux.fromIterable((Iterable)intermediatePaths).concatMap(path -> this.manageMailboxCreation(mailboxSession, isRootPath, (MailboxPath)path, createOption));
    }

    private Mono<MailboxId> manageMailboxCreation(MailboxSession mailboxSession, boolean isRootPath, MailboxPath mailboxPath, MailboxManager.CreateOption createOption) {
        if (mailboxPath.isInbox()) {
            return Mono.from((Publisher)this.hasInbox(mailboxSession)).flatMap(hasInbox -> {
                if (hasInbox.booleanValue()) {
                    return this.duplicatedINBOXCreation(isRootPath, mailboxPath);
                }
                return this.performConcurrentMailboxCreation(mailboxSession, MailboxPath.inbox((MailboxSession)mailboxSession), createOption);
            });
        }
        return this.performConcurrentMailboxCreation(mailboxSession, mailboxPath, createOption);
    }

    private Mono<MailboxId> duplicatedINBOXCreation(boolean isRootPath, MailboxPath mailbox) {
        if (isRootPath) {
            return Mono.error((Throwable)new InboxAlreadyCreated(mailbox.getName()));
        }
        return Mono.empty();
    }

    private Mono<MailboxId> performConcurrentMailboxCreation(MailboxSession mailboxSession, MailboxPath mailboxPath, MailboxManager.CreateOption createOption) {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        return Mono.from((Publisher)this.locker.executeReactiveWithLockReactive(mailboxPath, mapper.executeReactive(Mono.from(mapper.create(mailboxPath, UidValidity.generate()))), MailboxPathLocker.LockType.Write)).flatMap(mailbox -> this.eventBus.dispatch((Event)((EventFactory.MailboxAddedFinalStage)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.mailboxAdded().randomEventId()).mailboxSession(mailboxSession)).mailbox((Mailbox)mailbox)).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId())).thenReturn((Object)mailbox.getMailboxId())).onErrorResume(MailboxExistsException.class, e -> {
            LOGGER.info("{} mailbox was created concurrently", (Object)mailboxPath.asString());
            return Mono.empty();
        }).flatMap(any -> this.createSubscriptionIfNeeded(mailboxPath, createOption, mailboxSession).thenReturn(any)).flatMap(any -> this.inheritRightsReactive(mailboxSession, mailboxPath).thenReturn(any));
    }

    private Mono<Boolean> canCreateReactive(MailboxSession session, MailboxPath path) {
        if (path.belongsTo(session)) {
            return Mono.just((Object)true);
        }
        return this.nearestExistingParent(session, path).filterWhen(parent -> this.hasRightReactive((MailboxPath)parent, MailboxACL.Right.CreateMailbox, session)).hasElement();
    }

    private Mono<Void> assertCanCreateReactive(MailboxSession session, MailboxPath path) {
        return this.canCreateReactive(session, path).filter(canCreate -> canCreate).switchIfEmpty(Mono.error(() -> new InsufficientRightsException("user '" + session.getUser().asString() + "' is not allowed to create the mailbox '" + path.asString() + "'"))).then();
    }

    private Mono<MailboxPath> nearestExistingParent(MailboxSession session, MailboxPath path) {
        return Flux.fromIterable((Iterable)path.getParents(session.getPathDelimiter()).reversed()).filterWhen(parent -> this.mailboxExists((MailboxPath)parent, session)).next();
    }

    private Mono<Void> inheritRightsReactive(MailboxSession mailboxSession, MailboxPath path) {
        return this.nearestExistingParent(mailboxSession, path).flatMap(parent -> Mono.from(this.listRightsReactive((MailboxPath)parent, mailboxSession))).flatMap(acl -> {
            if (acl.getEntries().isEmpty()) {
                return Mono.empty();
            }
            return this.storeRightManager.setRightsReactiveWithoutAccessControl(path, (MailboxACL)acl, mailboxSession);
        });
    }

    public void deleteMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        LOGGER.info("deleteMailbox {}", (Object)mailboxPath);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        mailboxMapper.execute(() -> (Mailbox)MailboxReactorUtils.block(mailboxMapper.findMailboxByPath(mailboxPath).flatMap(mailbox -> this.assertCanDeleteReactive(session, (Mailbox)mailbox)).flatMap(mailbox -> this.doDeleteMailbox(mailboxMapper, (Mailbox)mailbox, session)).switchIfEmpty(Mono.error(() -> new MailboxNotFoundException(mailboxPath)))));
    }

    public Mailbox deleteMailbox(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        LOGGER.info("deleteMailbox {}", (Object)mailboxId);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mailboxMapper.execute(() -> (Mailbox)MailboxReactorUtils.block(mailboxMapper.findMailboxById(mailboxId).flatMap(mailbox -> this.assertCanDeleteReactive(session, (Mailbox)mailbox)).flatMap(mailbox -> this.doDeleteMailbox(mailboxMapper, (Mailbox)mailbox, session))));
    }

    public Mono<Mailbox> deleteMailboxReactive(MailboxId mailboxId, MailboxSession session) {
        LOGGER.info("deleteMailbox {}", (Object)mailboxId);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mailboxMapper.executeReactive(mailboxMapper.findMailboxById(mailboxId).flatMap(mailbox -> this.assertCanDeleteReactive(session, (Mailbox)mailbox)).flatMap(mailbox -> this.doDeleteMailbox(mailboxMapper, (Mailbox)mailbox, session)));
    }

    public Mono<Void> deleteMailboxReactive(MailboxPath mailboxPath, MailboxSession session) {
        LOGGER.info("deleteMailbox {}", (Object)mailboxPath);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mailboxMapper.executeReactive(mailboxMapper.findMailboxByPath(mailboxPath).flatMap(mailbox -> this.assertCanDeleteReactive(session, (Mailbox)mailbox)).flatMap(mailbox -> this.doDeleteMailbox(mailboxMapper, (Mailbox)mailbox, session)).switchIfEmpty(Mono.error(() -> new MailboxNotFoundException(mailboxPath)))).then();
    }

    private Mono<Mailbox> assertCanDeleteReactive(MailboxSession session, Mailbox mailbox) {
        MailboxPath path = mailbox.generateAssociatedPath();
        if (path.belongsTo(session)) {
            return Mono.just((Object)mailbox);
        }
        return Mono.from(this.hasRightReactive(path, MailboxACL.Right.DeleteMailbox, session)).flatMap(hasRight -> {
            if (hasRight.booleanValue()) {
                return Mono.just((Object)mailbox);
            }
            return Mono.error((Throwable)new InsufficientRightsException("user '" + session.getUser().asString() + "' is not allowed to delete the mailbox '" + path.asString() + "'"));
        });
    }

    private Mono<MailboxPath> assertCanDeleteWhenRename(MailboxSession session, MailboxPath path) {
        if (path.belongsTo(session)) {
            return Mono.just((Object)path);
        }
        return Mono.from(this.myRightsReactive(path, session)).flatMap(rights -> {
            if (rights.contains(MailboxACL.Right.DeleteMailbox)) {
                return Mono.just((Object)path);
            }
            if (!rights.contains(MailboxACL.Right.Lookup)) {
                return Mono.error((Throwable)new MailboxNotFoundException(path));
            }
            return Mono.error((Throwable)new InsufficientRightsException("user '" + session.getUser().asString() + "' is not allowed to delete the mailbox '" + path.asString() + "'"));
        });
    }

    private Mono<Mailbox> doDeleteMailbox(MailboxMapper mailboxMapper, Mailbox mailbox, MailboxSession session) {
        MessageMapper messageMapper = this.mailboxSessionMapperFactory.getMessageMapper(session);
        Mono quotaRootPublisher = Mono.fromCallable(() -> this.quotaRootResolver.getQuotaRoot(mailbox.generateAssociatedPath()));
        Mono messageCountPublisher = Mono.from(messageMapper.getMailboxCountersReactive(mailbox)).map(MailboxCounters::getCount);
        return quotaRootPublisher.zipWith(messageCountPublisher).flatMap(quotaRootWithMessageCount -> messageMapper.findInMailboxReactive(mailbox, MessageRange.all(), MessageMapper.FetchType.METADATA, -1).map(message -> MetadataWithMailboxId.from((MessageMetaData)message.metaData(), (MailboxId)message.getMailboxId())).collect(ImmutableList.toImmutableList()).flatMap(metadata -> {
            long totalSize = metadata.stream().mapToLong(MetadataWithMailboxId::getSize).sum();
            return this.preDeletionHooks.runHooks(PreDeletionHook.DeleteOperation.from((List)metadata)).then(mailboxMapper.delete(mailbox)).then(this.eventBus.dispatch((Event)((EventFactory.MailboxDeletionFinalStage)((EventFactory.RequireQuotaSizeValue)((EventFactory.RequireQuotaCountValue)((EventFactory.RequireMailboxACL)((EventFactory.RequireQuotaRoot)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.mailboxDeleted().randomEventId()).mailboxSession(session)).mailbox(mailbox)).quotaRoot((QuotaRoot)quotaRootWithMessageCount.getT1())).mailboxACL(mailbox.getACL())).quotaCount(QuotaCountUsage.count((long)((Long)quotaRootWithMessageCount.getT2())))).quotaSize(QuotaSizeUsage.size((long)totalSize))).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId())));
        }).retryWhen((Retry)RETRY_BACKOFF_SPEC).thenReturn((Object)new Mailbox(mailbox)));
    }

    public List<MailboxManager.MailboxRenamedResult> renameMailbox(MailboxPath from, MailboxPath to, MailboxManager.RenameOption option, MailboxSession session) throws MailboxException {
        return MailboxReactorUtils.block(this.renameMailboxReactive(from, to, option, session));
    }

    public Mono<List<MailboxManager.MailboxRenamedResult>> renameMailboxReactive(MailboxPath from, MailboxPath to, MailboxManager.RenameOption option, MailboxSession session) {
        return this.renameMailboxReactive(from, to, option, session, session);
    }

    public Mono<List<MailboxManager.MailboxRenamedResult>> renameMailboxReactive(MailboxPath from, MailboxPath to, MailboxManager.RenameOption option, MailboxSession fromSession, MailboxSession toSession) {
        LOGGER.debug("renameMailbox {} to {}", (Object)from, (Object)to);
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(fromSession);
        Mono fromMailboxPublisher = this.assertCanDeleteWhenRename(fromSession, from).then(mapper.findMailboxByPath(from).switchIfEmpty(Mono.error(() -> new MailboxNotFoundException(from))));
        return this.sanitizedMailboxPath(to, toSession).flatMap(sanitizedPath -> this.processRename((Mono<Mailbox>)fromMailboxPublisher, (MailboxPath)sanitizedPath, option, fromSession, toSession));
    }

    private Mono<List<MailboxManager.MailboxRenamedResult>> renameSubscriptionsIfNeeded(List<MailboxManager.MailboxRenamedResult> renamedResults, MailboxManager.RenameOption option, MailboxSession fromSession, MailboxSession toSession) {
        if (option == MailboxManager.RenameOption.RENAME_SUBSCRIPTIONS) {
            SubscriptionMapper subscriptionMapper = this.mailboxSessionMapperFactory.getSubscriptionMapper(fromSession);
            return subscriptionMapper.findSubscriptionsForUserReactive(fromSession.getUser()).collectList().flatMap(subscriptions -> Flux.fromIterable((Iterable)renamedResults).concatMap(renamedResult -> {
                Function<Subscription, Mono> renameFunction = subscription -> subscriptionMapper.deleteReactive((Subscription)subscription).then(subscriptionMapper.saveReactive(new Subscription(toSession.getUser(), renamedResult.getDestinationPath().asEscapedString())));
                Subscription legacySubscription = new Subscription(fromSession.getUser(), renamedResult.getOriginPath().getName());
                if (subscriptions.contains(legacySubscription)) {
                    return (Publisher)renameFunction.apply(legacySubscription);
                }
                Subscription subscription2 = new Subscription(fromSession.getUser(), renamedResult.getOriginPath().asEscapedString());
                if (subscriptions.contains(subscription2)) {
                    return (Publisher)renameFunction.apply(subscription2);
                }
                return Mono.empty();
            }).then().thenReturn((Object)renamedResults));
        }
        return Mono.just(renamedResults);
    }

    public List<MailboxManager.MailboxRenamedResult> renameMailbox(MailboxId mailboxId, MailboxPath newMailboxPath, MailboxManager.RenameOption option, MailboxSession session) throws MailboxException {
        return MailboxReactorUtils.block(this.renameMailboxReactive(mailboxId, newMailboxPath, option, session));
    }

    public Mono<List<MailboxManager.MailboxRenamedResult>> renameMailboxReactive(MailboxId mailboxId, MailboxPath newMailboxPath, MailboxManager.RenameOption option, MailboxSession session) {
        LOGGER.debug("renameMailbox {} to {}", (Object)mailboxId, (Object)newMailboxPath);
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mono fromMailboxPublisher = mapper.findMailboxById(mailboxId).flatMap(mailbox -> this.assertCanDeleteWhenRename(session, mailbox.generateAssociatedPath()).thenReturn(mailbox)).switchIfEmpty(Mono.error(() -> new MailboxNotFoundException(mailboxId)));
        return this.sanitizedMailboxPath(newMailboxPath, session).flatMap(sanitizedPath -> this.processRename((Mono<Mailbox>)fromMailboxPublisher, (MailboxPath)sanitizedPath, option, session, session));
    }

    private Mono<MailboxPath> sanitizedMailboxPath(MailboxPath mailboxPath, MailboxSession session) {
        Function<MailboxPath, Mono> assertNewMailboxPathDoesNotExist = newMailboxPath -> this.mailboxExists(mailboxPath, session).map(FunctionalUtils.negate());
        Function<MailboxPath, Mono> assertRightToCreate = newMailboxPath -> this.canCreateReactive(session, mailboxPath);
        return Mono.fromCallable(() -> mailboxPath.sanitize(session.getPathDelimiter())).filterWhen(assertNewMailboxPathDoesNotExist).switchIfEmpty(Mono.error(() -> new MailboxExistsException(mailboxPath.toString()))).filterWhen(assertRightToCreate).switchIfEmpty(Mono.error(() -> new InsufficientRightsException("user '" + session.getUser().asString() + "' is not allowed to create the mailbox '" + mailboxPath.asString() + "'"))).flatMap(newMailboxPath -> Mono.fromCallable(() -> newMailboxPath.assertAcceptable(session.getPathDelimiter())));
    }

    private Mono<List<MailboxManager.MailboxRenamedResult>> processRename(Mono<Mailbox> fromMailboxPublisher, MailboxPath to, MailboxManager.RenameOption option, MailboxSession fromSession, MailboxSession toSession) {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(fromSession);
        return mapper.executeReactive(fromMailboxPublisher.flatMap(mailbox -> this.doRenameMailbox((Mailbox)mailbox, to, fromSession, toSession, mapper).flatMap(renamedResults -> this.renameSubscriptionsIfNeeded((List<MailboxManager.MailboxRenamedResult>)renamedResults, option, fromSession, toSession))));
    }

    private Mono<List<MailboxManager.MailboxRenamedResult>> doRenameMailbox(Mailbox mailbox, MailboxPath newMailboxPath, MailboxSession fromSession, MailboxSession toSession, MailboxMapper mapper) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        MailboxPath from = mailbox.generateAssociatedPath();
        mailbox.setNamespace(newMailboxPath.getNamespace());
        mailbox.setUser(newMailboxPath.getUser());
        mailbox.setName(newMailboxPath.getName());
        MailboxQuery.UserBound query = MailboxQuery.builder().userAndNamespaceFrom(from).expression((MailboxNameExpression)new PrefixedWildcard(from.getName() + fromSession.getPathDelimiter())).build().asUserBound();
        return mapper.rename(mailbox).map(mailboxId -> {
            resultBuilder.add((Object)new MailboxManager.MailboxRenamedResult(mailboxId, from, newMailboxPath));
            return mailboxId;
        }).then(Mono.from(this.renameSubMailboxes(newMailboxPath, mapper, from, query, (ImmutableList.Builder<MailboxManager.MailboxRenamedResult>)resultBuilder))).then(Mono.defer(() -> Flux.fromIterable((Iterable)resultBuilder.build()).concatMap(result -> this.eventBus.dispatch((Event)EventFactory.mailboxRenamed().randomEventId().mailboxSession(fromSession).mailboxId(result.getMailboxId()).oldPath(result.getOriginPath()).newPath(result.getDestinationPath()).build(), (RegistrationKey)new MailboxIdRegistrationKey(result.getMailboxId()))).then())).then(Mono.fromCallable(() -> ((ImmutableList.Builder)resultBuilder).build()));
    }

    private Publisher<Void> renameSubMailboxes(MailboxPath newMailboxPath, MailboxMapper mapper, MailboxPath from, MailboxQuery.UserBound query, ImmutableList.Builder<MailboxManager.MailboxRenamedResult> resultBuilder) {
        if ("INBOX".equalsIgnoreCase(from.getName())) {
            return Mono.empty();
        }
        return this.locker.executeReactiveWithLockReactive(from, (Publisher)mapper.findMailboxWithPathLike(query).concatMap(sub -> {
            String subOriginalName = sub.getName();
            String subNewName = newMailboxPath.getName() + subOriginalName.substring(from.getName().length());
            MailboxPath fromPath = new MailboxPath(from, subOriginalName);
            sub.setName(subNewName);
            sub.setUser(newMailboxPath.getUser());
            return mapper.rename((Mailbox)sub).map(mailboxId -> {
                resultBuilder.add((Object)new MailboxManager.MailboxRenamedResult(sub.getMailboxId(), fromPath, sub.generateAssociatedPath()));
                return mailboxId;
            }).retryWhen((Retry)Retry.backoff((long)5L, (Duration)Duration.ofMillis(10L))).then(Mono.fromRunnable(() -> LOGGER.debug("Rename mailbox sub-mailbox {} to {}", (Object)subOriginalName, (Object)subNewName)));
        }, 2).then(), MailboxPathLocker.LockType.Write);
    }

    public List<MessageRange> copyMessages(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        return (List)MailboxReactorUtils.block(this.copyMessagesReactive(set, from, to, session).collectList());
    }

    public List<MessageRange> copyMessages(MessageRange set, MailboxId from, MailboxId to, MailboxSession session) throws MailboxException {
        return (List)MailboxReactorUtils.block(this.copyMessagesReactive(set, from, to, session).collectList());
    }

    public Flux<MessageRange> copyMessagesReactive(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) {
        return Mono.zip((Mono)Mono.from(this.getMailboxReactive(from, session)), (Mono)Mono.from(this.getMailboxReactive(to, session))).flatMapMany(fromTo -> {
            StoreMessageManager fromMessageManager = (StoreMessageManager)fromTo.getT1();
            StoreMessageManager toMessageManager = (StoreMessageManager)fromTo.getT2();
            return fromMessageManager.copyTo(set, toMessageManager, session);
        });
    }

    public Flux<MessageRange> copyMessagesReactive(MessageRange set, MailboxId from, MailboxId to, MailboxSession session) {
        return Mono.zip((Mono)Mono.from(this.getMailboxReactive(from, session)), (Mono)Mono.from(this.getMailboxReactive(to, session))).flatMapMany(fromTo -> {
            StoreMessageManager fromMessageManager = (StoreMessageManager)fromTo.getT1();
            StoreMessageManager toMessageManager = (StoreMessageManager)fromTo.getT2();
            return fromMessageManager.copyTo(set, toMessageManager, session);
        });
    }

    public List<MessageRange> moveMessages(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        return (List)MailboxReactorUtils.block(this.moveMessagesReactive(set, from, to, session).collectList());
    }

    public List<MessageRange> moveMessages(MessageRange set, MailboxId from, MailboxId to, MailboxSession session) throws MailboxException {
        return (List)MailboxReactorUtils.block(this.moveMessagesReactive(set, from, to, session).collectList());
    }

    public Flux<MessageRange> moveMessagesReactive(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) {
        return Mono.zip((Mono)Mono.from(this.getMailboxReactive(from, session)), (Mono)Mono.from(this.getMailboxReactive(to, session))).flatMapMany(fromTo -> {
            StoreMessageManager fromMessageManager = (StoreMessageManager)fromTo.getT1();
            StoreMessageManager toMessageManager = (StoreMessageManager)fromTo.getT2();
            return fromMessageManager.moveTo(set, toMessageManager, session);
        });
    }

    public Flux<MessageRange> moveMessagesReactive(MessageRange set, MailboxId from, MailboxId to, MailboxSession session) {
        return Mono.zip((Mono)Mono.from(this.getMailboxReactive(from, session)), (Mono)Mono.from(this.getMailboxReactive(to, session))).flatMapMany(fromTo -> {
            StoreMessageManager fromMessageManager = (StoreMessageManager)fromTo.getT1();
            StoreMessageManager toMessageManager = (StoreMessageManager)fromTo.getT2();
            return fromMessageManager.moveTo(set, toMessageManager, session);
        });
    }

    public Flux<MailboxMetaData> search(MailboxQuery expression, MailboxManager.MailboxSearchFetchType fetchType, MailboxSession session) {
        Mono mailboxesMono = this.searchMailboxes(expression, session, MailboxACL.Right.Lookup).collectList();
        return mailboxesMono.publishOn(Schedulers.parallel()).flatMapMany(mailboxes -> Flux.fromIterable((Iterable)mailboxes).filter(arg_0 -> ((MailboxQuery)expression).matches(arg_0)).transform(this.metadataTransformation(fetchType, session, (List<Mailbox>)mailboxes))).sort(MailboxMetaData.COMPARATOR);
    }

    private Function<Flux<Mailbox>, Flux<MailboxMetaData>> metadataTransformation(MailboxManager.MailboxSearchFetchType fetchType, MailboxSession session, List<Mailbox> mailboxes) {
        if (fetchType == MailboxManager.MailboxSearchFetchType.Counters) {
            return this.withCounters(session, mailboxes);
        }
        return this.withoutCounters(session, mailboxes);
    }

    private Function<Flux<Mailbox>, Flux<MailboxMetaData>> withCounters(MailboxSession session, List<Mailbox> mailboxes) {
        MessageMapper messageMapper = this.mailboxSessionMapperFactory.getMessageMapper(session);
        Map<MailboxPath, Boolean> parentMap = this.parentMap(mailboxes, session);
        int concurrency = 4;
        return mailboxFlux -> mailboxFlux.flatMap(mailbox -> this.retrieveCounters(messageMapper, (Mailbox)mailbox, session).map(Throwing.function(counters -> this.toMailboxMetadata(session, parentMap, (Mailbox)mailbox, (MailboxCounters)counters)).sneakyThrow()), concurrency);
    }

    private Map<MailboxPath, Boolean> parentMap(List<Mailbox> mailboxes, MailboxSession session) {
        return (Map)mailboxes.stream().flatMap(mailbox -> mailbox.generateAssociatedPath().getParents(session.getPathDelimiter()).stream()).collect(ImmutableMap.toImmutableMap(Function.identity(), any -> true, (a, b) -> true));
    }

    private Function<Flux<Mailbox>, Flux<MailboxMetaData>> withoutCounters(MailboxSession session, List<Mailbox> mailboxes) {
        Map<MailboxPath, Boolean> parentMap = this.parentMap(mailboxes, session);
        return mailboxFlux -> mailboxFlux.map(Throwing.function(mailbox -> this.toMailboxMetadata(session, parentMap, (Mailbox)mailbox, MailboxCounters.empty((MailboxId)mailbox.getMailboxId()))).sneakyThrow());
    }

    private Mono<MailboxCounters> retrieveCounters(MessageMapper messageMapper, Mailbox mailbox, MailboxSession session) {
        return messageMapper.getMailboxCountersReactive(mailbox).filter(Throwing.predicate(counter -> this.storeRightManager.hasRight(mailbox, MailboxACL.Right.Read, session)).sneakyThrow()).switchIfEmpty(Mono.just((Object)MailboxCounters.empty((MailboxId)mailbox.getMailboxId())));
    }

    private Flux<Mailbox> searchMailboxes(MailboxQuery mailboxQuery, MailboxSession session, MailboxACL.Right right) {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Flux<Mailbox> baseMailboxes = this.getBaseMailboxes(mailboxMapper, mailboxQuery, session);
        Flux delegatedMailboxes = this.getDelegatedMailboxes(mailboxMapper, mailboxQuery, right, session).filter((Predicate)Throwing.predicate(mailbox -> this.storeRightManager.hasRight((Mailbox)mailbox, right, session))).filter(mailbox -> !mailbox.getUser().equals((Object)session.getUser()));
        return Flux.concat((Publisher[])new Publisher[]{baseMailboxes, delegatedMailboxes});
    }

    private Flux<Mailbox> getBaseMailboxes(MailboxMapper mailboxMapper, MailboxQuery mailboxQuery, MailboxSession session) {
        if (mailboxQuery.isPrivateMailboxes(session) || mailboxQuery.getNamespace().isEmpty() && mailboxQuery.getUser().isEmpty()) {
            return mailboxMapper.findMailboxWithPathLike(StoreMailboxManager.toSingleUserQuery(mailboxQuery, session));
        }
        return Flux.empty();
    }

    private Flux<MailboxId> accessibleMailboxIds(MultimailboxesSearchQuery.Namespace namespace, MailboxACL.Right right, MailboxSession session) {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Flux<MailboxId> baseMailboxes = mailboxMapper.userMailboxes(session.getUser());
        Flux<MailboxId> delegatedMailboxes = this.getDelegatedMailboxes(mailboxMapper, namespace, right, session);
        return Flux.concat((Publisher[])new Publisher[]{baseMailboxes, delegatedMailboxes});
    }

    static MailboxQuery.UserBound toSingleUserQuery(MailboxQuery mailboxQuery, MailboxSession mailboxSession) {
        return MailboxQuery.builder().namespace(mailboxQuery.getNamespace().orElse("#private")).username(mailboxQuery.getUser().orElse(mailboxSession.getUser())).expression(mailboxQuery.getMailboxNameExpression().includeChildren()).build().asUserBound();
    }

    private Flux<Mailbox> getDelegatedMailboxes(MailboxMapper mailboxMapper, MailboxQuery mailboxQuery, MailboxACL.Right right, MailboxSession session) {
        if (mailboxQuery.isPrivateMailboxes(session)) {
            return Flux.empty();
        }
        return mailboxMapper.findNonPersonalMailboxes(session.getUser(), right);
    }

    private Flux<MailboxId> getDelegatedMailboxes(MailboxMapper mailboxMapper, MultimailboxesSearchQuery.Namespace namespace, MailboxACL.Right right, MailboxSession session) {
        if (!namespace.accessDelegatedMailboxes()) {
            return Flux.empty();
        }
        return mailboxMapper.findNonPersonalMailboxes(session.getUser(), right).filter(mailbox -> !mailbox.getUser().equals((Object)session.getUser())).map(Mailbox::getMailboxId);
    }

    private MailboxMetaData toMailboxMetadata(MailboxSession session, Map<MailboxPath, Boolean> parentMap, Mailbox mailbox, MailboxCounters counters) throws UnsupportedRightException {
        return new MailboxMetaData(mailbox, session.getPathDelimiter(), this.computeChildren(parentMap, mailbox), MailboxMetaData.Selectability.NONE, this.storeRightManager.getResolvedMailboxACL(mailbox, session), counters);
    }

    private MailboxMetaData.Children computeChildren(Map<MailboxPath, Boolean> parentMap, Mailbox mailbox) {
        if (parentMap.getOrDefault(mailbox.generateAssociatedPath(), false).booleanValue()) {
            return MailboxMetaData.Children.HAS_CHILDREN;
        }
        return MailboxMetaData.Children.HAS_NO_CHILDREN;
    }

    public Flux<MessageId> search(MultimailboxesSearchQuery expression, MailboxSession session, long limit) {
        return this.getInMailboxIds(expression, session).filter(id -> !expression.getNotInMailboxes().contains(id)).collect(ImmutableSet.toImmutableSet()).flatMapMany((Function)Throwing.function(ids -> this.index.search(session, (Collection<MailboxId>)ids, expression.getSearchQuery(), limit)));
    }

    public Flux<MessageId> getThread(ThreadId threadId, MailboxSession session) {
        return this.threadIdGuessingAlgorithm.getMessageIdsInThread(threadId, session);
    }

    public Flux<MailboxId> getInMailboxIds(MultimailboxesSearchQuery expression, MailboxSession session) {
        if (expression.getInMailboxes().isEmpty()) {
            return this.accessibleMailboxIds(expression.getNamespace(), MailboxACL.Right.Read, session);
        }
        return this.filterReadable((ImmutableSet<MailboxId>)expression.getInMailboxes(), session).filter(mailbox -> expression.getNamespace().keepAccessible(mailbox)).map(Mailbox::getMailboxId);
    }

    private Flux<Mailbox> filterReadable(ImmutableSet<MailboxId> inMailboxes, MailboxSession session) {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return Flux.fromIterable(inMailboxes).concatMap(mailboxMapper::findMailboxById).filter(Throwing.predicate(mailbox -> this.storeRightManager.hasRight((Mailbox)mailbox, MailboxACL.Right.Read, session)).sneakyThrow());
    }

    public Mono<Boolean> mailboxExists(MailboxPath mailboxPath, MailboxSession session) {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mapper.pathExists(mailboxPath);
    }

    public void endProcessingRequest(MailboxSession session) {
        this.mailboxSessionMapperFactory.endProcessingRequest(session);
    }

    public void startProcessingRequest(MailboxSession session) {
    }

    public List<MailboxPath> list(MailboxSession session) throws MailboxException {
        return (List)MailboxReactorUtils.block(this.mailboxSessionMapperFactory.getMailboxMapper(session).list().map(Mailbox::generateAssociatedPath).distinct().collect(ImmutableList.toImmutableList()));
    }

    public boolean hasRight(MailboxPath mailboxPath, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.storeRightManager.hasRight(mailboxPath, right, session);
    }

    public Publisher<Boolean> hasRightReactive(MailboxPath mailboxPath, MailboxACL.Right right, MailboxSession session) {
        return this.storeRightManager.hasRightReactive(mailboxPath, right, session);
    }

    public boolean hasRight(Mailbox mailbox, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.storeRightManager.hasRight(mailbox, right, session);
    }

    public boolean hasRight(MailboxId mailboxId, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.storeRightManager.hasRight(mailboxId, right, session);
    }

    public MailboxACL.Rfc4314Rights myRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.storeRightManager.myRights(mailboxPath, session);
    }

    public Publisher<MailboxACL.Rfc4314Rights> myRightsReactive(MailboxPath mailboxPath, MailboxSession session) {
        return this.storeRightManager.myRightsReactive(mailboxPath, session);
    }

    public Mono<MailboxACL.Rfc4314Rights> myRights(MailboxId mailboxId, MailboxSession session) {
        return this.storeRightManager.myRights(mailboxId, session);
    }

    public MailboxACL.Rfc4314Rights myRights(Mailbox mailbox, MailboxSession session) {
        return this.storeRightManager.myRights(mailbox, session);
    }

    public List<MailboxACL.Rfc4314Rights> listRights(MailboxPath mailboxPath, MailboxACL.EntryKey key, MailboxSession session) throws MailboxException {
        return this.storeRightManager.listRights(mailboxPath, key, session);
    }

    public List<MailboxACL.Rfc4314Rights> listRights(Mailbox mailbox, MailboxACL.EntryKey identifier, MailboxSession session) throws MailboxException {
        return this.storeRightManager.listRights(mailbox, identifier, session);
    }

    public MailboxACL listRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.storeRightManager.listRights(mailboxPath, session);
    }

    public Publisher<MailboxACL> listRightsReactive(MailboxPath mailboxPath, MailboxSession session) {
        return this.storeRightManager.listRightsReactive(mailboxPath, session);
    }

    public MailboxACL listRights(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        return this.storeRightManager.listRights(mailboxId, session);
    }

    public Publisher<MailboxACL> listRightsReactive(MailboxId mailboxId, MailboxSession session) {
        return this.storeRightManager.listRightsReactive(mailboxId, session);
    }

    public void applyRightsCommand(MailboxPath mailboxPath, MailboxACL.ACLCommand mailboxACLCommand, MailboxSession session) throws MailboxException {
        this.storeRightManager.applyRightsCommand(mailboxPath, mailboxACLCommand, session);
    }

    public Publisher<Void> applyRightsCommandReactive(MailboxPath mailboxPath, MailboxACL.ACLCommand mailboxACLCommand, MailboxSession session) {
        return this.storeRightManager.applyRightsCommandReactive(mailboxPath, mailboxACLCommand, session);
    }

    public void applyRightsCommand(MailboxId mailboxId, MailboxACL.ACLCommand mailboxACLCommand, MailboxSession session) throws MailboxException {
        this.storeRightManager.applyRightsCommand(mailboxId, mailboxACLCommand, session);
    }

    public void setRights(MailboxPath mailboxPath, MailboxACL mailboxACL, MailboxSession session) throws MailboxException {
        this.storeRightManager.setRights(mailboxPath, mailboxACL, session);
    }

    public void setRights(MailboxId mailboxId, MailboxACL mailboxACL, MailboxSession session) throws MailboxException {
        this.storeRightManager.setRights(mailboxId, mailboxACL, session);
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.annotationManager.getAllAnnotations(mailboxPath, session);
    }

    public Publisher<MailboxAnnotation> getAllAnnotationsReactive(MailboxPath mailboxPath, MailboxSession session) {
        return this.annotationManager.getAllAnnotationsReactive(mailboxPath, session);
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeys(mailboxPath, session, keys);
    }

    public Publisher<MailboxAnnotation> getAnnotationsByKeysReactive(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) {
        return this.annotationManager.getAnnotationsByKeysReactive(mailboxPath, session, keys);
    }

    public void updateAnnotations(MailboxPath mailboxPath, MailboxSession session, List<MailboxAnnotation> mailboxAnnotations) throws MailboxException {
        this.annotationManager.updateAnnotations(mailboxPath, session, mailboxAnnotations);
    }

    public Publisher<Void> updateAnnotationsReactive(MailboxPath mailboxPath, MailboxSession session, List<MailboxAnnotation> mailboxAnnotations) {
        return this.annotationManager.updateAnnotationsReactive(mailboxPath, session, mailboxAnnotations);
    }

    public boolean hasCapability(MailboxManager.MailboxCapabilities capability) {
        return this.getSupportedMailboxCapabilities().contains(capability);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeysWithOneDepth(mailboxPath, session, keys);
    }

    public Publisher<MailboxAnnotation> getAnnotationsByKeysWithOneDepthReactive(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) {
        return this.annotationManager.getAnnotationsByKeysWithOneDepthReactive(mailboxPath, session, keys);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeysWithAllDepth(mailboxPath, session, keys);
    }

    public Publisher<MailboxAnnotation> getAnnotationsByKeysWithAllDepthReactive(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) {
        return this.annotationManager.getAnnotationsByKeysWithAllDepthReactive(mailboxPath, session, keys);
    }

    public boolean hasChildren(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return (Boolean)MailboxReactorUtils.block(mapper.findMailboxByPath(mailboxPath).flatMap(mailbox -> mapper.hasChildren((Mailbox)mailbox, session.getPathDelimiter())));
    }

    public Publisher<Boolean> hasChildrenReactive(MailboxPath mailboxPath, MailboxSession session) {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        return mapper.findMailboxByPath(mailboxPath).flatMap(mailbox -> mapper.hasChildren((Mailbox)mailbox, session.getPathDelimiter()));
    }
}

