/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.main;

import java.io.IOException;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;

public class ResponseEncoder
implements ImapProcessor.Responder {
    private final ImapEncoder encoder;
    private final ImapResponseComposer composer;
    private IOException failure;

    public ResponseEncoder(ImapEncoder encoder, ImapResponseComposer composer) {
        this.encoder = encoder;
        this.composer = composer;
    }

    @Override
    public void respond(ImapResponseMessage message) {
        try {
            this.encoder.encode(message, this.composer);
        }
        catch (IOException failure) {
            this.failure = failure;
        }
    }

    public final IOException getFailure() {
        return this.failure;
    }

    @Override
    public void flush() {
        try {
            this.composer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

