/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.security.AccessController;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.StringUtil;

public class ClassListValue
extends Value {
    private Class<?>[] _values = new Class[0];

    public void set(Class<?>[] values) {
        this.assertChangeable();
        if (values != null) {
            this._values = values;
        }
        this.valueChanged();
    }

    public Class<?>[] get() {
        return this._values;
    }

    public Class<Class[]> getValueType() {
        return Class[].class;
    }

    @Override
    protected String getInternalString() {
        return Stream.of(this._values).map(Class::getName).collect(Collectors.joining(","));
    }

    @Override
    protected void setInternalString(String val) {
        String[] vals = StringUtil.split(val, ",", 0);
        if (vals != null) {
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = vals[i].trim();
            }
        }
        ClassLoader loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        this.set(Optional.ofNullable(StringUtil.split(val, ",", 0)).map(it -> (Class[])Stream.of(it).map(v -> {
            try {
                return loader.loadClass(v.trim());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }).toArray(Class[]::new)).orElse(null));
    }

    @Override
    protected void setInternalObject(Object obj) {
        this.set((Class[])obj);
    }
}

