/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.objectstorage.aws.AwsS3AuthConfiguration;
import org.apache.james.blob.objectstorage.aws.Region;

public class S3BlobStoreConfiguration {
    public static int DEFAULT_HTTP_CONCURRENCY = 100;
    private final Region region;
    private final AwsS3AuthConfiguration specificAuthConfiguration;
    private final Optional<BucketName> namespace;
    private final Optional<String> bucketPrefix;
    private final int httpConcurrency;
    private final Optional<Long> inMemoryReadLimit;
    private Optional<Duration> readTimeout;
    private Optional<Duration> writeTimeout;
    private Optional<Duration> connectionTimeout;

    public static Builder.RequireAuthConfiguration builder() {
        return authConfiguration -> region -> new Builder.ReadyToBuild(authConfiguration, region);
    }

    @VisibleForTesting
    S3BlobStoreConfiguration(Optional<String> bucketPrefix, Optional<BucketName> namespace, Region region, AwsS3AuthConfiguration specificAuthConfiguration, int httpConcurrency, Optional<Long> inMemoryReadLimit, Optional<Duration> readTimeout, Optional<Duration> writeTimeout, Optional<Duration> connectionTimeout) {
        this.bucketPrefix = bucketPrefix;
        this.namespace = namespace;
        this.region = region;
        this.specificAuthConfiguration = specificAuthConfiguration;
        this.httpConcurrency = httpConcurrency;
        this.inMemoryReadLimit = inMemoryReadLimit;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.connectionTimeout = connectionTimeout;
    }

    public Optional<Long> getInMemoryReadLimit() {
        return this.inMemoryReadLimit;
    }

    public Optional<BucketName> getNamespace() {
        return this.namespace;
    }

    public AwsS3AuthConfiguration getSpecificAuthConfiguration() {
        return this.specificAuthConfiguration;
    }

    public Optional<String> getBucketPrefix() {
        return this.bucketPrefix;
    }

    public int getHttpConcurrency() {
        return this.httpConcurrency;
    }

    public Region getRegion() {
        return this.region;
    }

    public Optional<Duration> getReadTimeout() {
        return this.readTimeout;
    }

    public Optional<Duration> getWriteTimeout() {
        return this.writeTimeout;
    }

    public Optional<Duration> getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public final boolean equals(Object o) {
        if (o instanceof S3BlobStoreConfiguration) {
            S3BlobStoreConfiguration that = (S3BlobStoreConfiguration)o;
            return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.bucketPrefix, that.bucketPrefix) && Objects.equals(this.region, that.region) && Objects.equals(this.httpConcurrency, that.httpConcurrency) && Objects.equals(this.inMemoryReadLimit, that.inMemoryReadLimit) && Objects.equals(this.readTimeout, that.readTimeout) && Objects.equals(this.writeTimeout, that.writeTimeout) && Objects.equals(this.connectionTimeout, that.connectionTimeout) && Objects.equals(this.specificAuthConfiguration, that.specificAuthConfiguration);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.namespace, this.bucketPrefix, this.httpConcurrency, this.specificAuthConfiguration, this.readTimeout, this.writeTimeout, this.connectionTimeout);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", this.namespace).add("httpConcurrency", this.httpConcurrency).add("inMemoryReadLimit", this.inMemoryReadLimit).add("bucketPrefix", this.bucketPrefix).add("region", (Object)this.region).add("specificAuthConfiguration", (Object)this.specificAuthConfiguration).add("readTimeout", this.readTimeout).add("writeTimeout", this.writeTimeout).add("connectionTimeout", this.connectionTimeout).toString();
    }

    public static interface Builder {

        public static class ReadyToBuild {
            private final AwsS3AuthConfiguration specificAuthConfiguration;
            private Optional<BucketName> defaultBucketName;
            private Optional<String> bucketPrefix;
            private Optional<Integer> httpConcurrency;
            private Optional<Duration> readTimeout;
            private Optional<Duration> writeTimeout;
            private Optional<Duration> connectionTimeout;
            private Optional<Long> inMemoryReadLimit;
            private Region region;

            public ReadyToBuild(AwsS3AuthConfiguration specificAuthConfiguration, Region region) {
                this.specificAuthConfiguration = specificAuthConfiguration;
                this.region = region;
                this.defaultBucketName = Optional.empty();
                this.bucketPrefix = Optional.empty();
                this.httpConcurrency = Optional.empty();
                this.readTimeout = Optional.empty();
                this.writeTimeout = Optional.empty();
                this.connectionTimeout = Optional.empty();
                this.inMemoryReadLimit = Optional.empty();
            }

            public ReadyToBuild defaultBucketName(Optional<BucketName> defaultBucketName) {
                this.defaultBucketName = defaultBucketName;
                return this;
            }

            public ReadyToBuild defaultBucketName(BucketName defaultBucketName) {
                this.defaultBucketName = Optional.of(defaultBucketName);
                return this;
            }

            public ReadyToBuild bucketPrefix(Optional<String> bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            public ReadyToBuild writeTimeout(Optional<Duration> writeTimeout) {
                this.writeTimeout = writeTimeout;
                return this;
            }

            public ReadyToBuild inMemoryReadLimit(Optional<Long> inMemoryReadLimit) {
                this.inMemoryReadLimit = inMemoryReadLimit;
                return this;
            }

            public ReadyToBuild connectionTimeout(Optional<Duration> connectionTimeout) {
                this.connectionTimeout = connectionTimeout;
                return this;
            }

            public ReadyToBuild readTimeout(Optional<Duration> readTimeout) {
                this.readTimeout = readTimeout;
                return this;
            }

            public ReadyToBuild bucketPrefix(String bucketPrefix) {
                this.bucketPrefix = Optional.ofNullable(bucketPrefix);
                return this;
            }

            public ReadyToBuild httpConcurrency(Optional<Integer> httpConcurrency) {
                this.httpConcurrency = httpConcurrency;
                return this;
            }

            public S3BlobStoreConfiguration build() {
                return new S3BlobStoreConfiguration(this.bucketPrefix, this.defaultBucketName, this.region, this.specificAuthConfiguration, this.httpConcurrency.orElse(DEFAULT_HTTP_CONCURRENCY), this.inMemoryReadLimit, this.readTimeout, this.writeTimeout, this.connectionTimeout);
            }
        }

        @FunctionalInterface
        public static interface RequireRegion {
            public ReadyToBuild region(Region var1);
        }

        @FunctionalInterface
        public static interface RequireAuthConfiguration {
            public RequireRegion authConfiguration(AwsS3AuthConfiguration var1);
        }
    }
}

