/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class StemmerOverrideTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final List<String> rules;
    @Nullable
    private final String rulesPath;
    public static final JsonpDeserializer<StemmerOverrideTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StemmerOverrideTokenFilter::setupStemmerOverrideTokenFilterDeserializer);

    private StemmerOverrideTokenFilter(Builder builder) {
        super(builder);
        this.rules = ApiTypeHelper.unmodifiable(builder.rules);
        this.rulesPath = builder.rulesPath;
    }

    public static StemmerOverrideTokenFilter of(Function<Builder, ObjectBuilder<StemmerOverrideTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.StemmerOverride;
    }

    public final List<String> rules() {
        return this.rules;
    }

    @Nullable
    public final String rulesPath() {
        return this.rulesPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "stemmer_override");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.rules)) {
            generator.writeKey("rules");
            generator.writeStartArray();
            for (String item0 : this.rules) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.rulesPath != null) {
            generator.writeKey("rules_path");
            generator.write(this.rulesPath);
        }
    }

    protected static void setupStemmerOverrideTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        StemmerOverrideTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::rules, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "rules");
        op.add(Builder::rulesPath, JsonpDeserializer.stringDeserializer(), "rules_path");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StemmerOverrideTokenFilter> {
        @Nullable
        private List<String> rules;
        @Nullable
        private String rulesPath;

        public final Builder rules(List<String> list) {
            this.rules = Builder._listAddAll(this.rules, list);
            return this;
        }

        public final Builder rules(String value, String ... values) {
            this.rules = Builder._listAdd(this.rules, value, values);
            return this;
        }

        public final Builder rulesPath(@Nullable String value) {
            this.rulesPath = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StemmerOverrideTokenFilter build() {
            this._checkSingleUse();
            return new StemmerOverrideTokenFilter(this);
        }
    }
}

