/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model;

import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.store.mail.model.Message;

public interface MailboxMessage
extends Message,
Comparable<MailboxMessage> {
    public ThreadId getThreadId();

    public ComposedMessageIdWithMetaData getComposedMessageIdWithMetaData();

    public MailboxId getMailboxId();

    public MessageUid getUid();

    public void setUid(MessageUid var1);

    public void setModSeq(ModSeq var1);

    public ModSeq getModSeq();

    public boolean isAnswered();

    public boolean isDeleted();

    public boolean isDraft();

    public boolean isFlagged();

    public boolean isRecent();

    public boolean isSeen();

    public void setFlags(Flags var1);

    public Flags createFlags();

    default public MessageMetaData metaData() {
        return new MessageMetaData(this.getUid(), this.getModSeq(), this.createFlags(), this.getFullContentOctets(), this.getInternalDate(), this.getMessageId(), this.getThreadId());
    }

    @Override
    default public int compareTo(MailboxMessage other) {
        return this.getUid().compareTo(other.getUid());
    }

    public MailboxMessage copy(Mailbox var1) throws MailboxException;
}

