/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum GSSAPIChannelBindingType {
    NONE("none"),
    TLS_SERVER_END_POINT("tls-server-end-point");

    @NotNull
    private final String name;

    private GSSAPIChannelBindingType(String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public static GSSAPIChannelBindingType forName(@NotNull String name) {
        String convertedName = StaticUtils.toLowerCase(name).replace('_', '-');
        for (GSSAPIChannelBindingType t : GSSAPIChannelBindingType.values()) {
            if (!t.name.equals(convertedName)) continue;
            return t;
        }
        return null;
    }
}

