/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.message.view;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.mail.internet.SharedInputStream;
import org.apache.james.jmap.api.model.Preview;
import org.apache.james.jmap.api.projections.MessageFastViewPrecomputedProperties;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.jmap.draft.methods.BlobManager;
import org.apache.james.jmap.draft.model.Attachment;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.jmap.draft.model.Emailer;
import org.apache.james.jmap.draft.model.Keywords;
import org.apache.james.jmap.draft.model.message.view.MessageFullView;
import org.apache.james.jmap.draft.model.message.view.MessageViewFactory;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.html.HtmlTextExtractor;
import org.apache.james.util.mime.MessageContentExtractor;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class MessageFullViewFactory
implements MessageViewFactory<MessageFullView> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageFullViewFactory.class);
    private final BlobManager blobManager;
    private final MessageContentExtractor messageContentExtractor;
    private final HtmlTextExtractor htmlTextExtractor;
    private final MessageIdManager messageIdManager;
    private final MessageFastViewProjection fastViewProjection;

    @Inject
    public MessageFullViewFactory(BlobManager blobManager, MessageContentExtractor messageContentExtractor, HtmlTextExtractor htmlTextExtractor, MessageIdManager messageIdManager, MessageFastViewProjection fastViewProjection) {
        this.blobManager = blobManager;
        this.messageContentExtractor = messageContentExtractor;
        this.htmlTextExtractor = htmlTextExtractor;
        this.messageIdManager = messageIdManager;
        this.fastViewProjection = fastViewProjection;
    }

    @Override
    public Flux<MessageFullView> fromMessageIds(List<MessageId> messageIds, MailboxSession mailboxSession) {
        Flux messages = Flux.from((Publisher)this.messageIdManager.getMessagesReactive(messageIds, FetchGroup.FULL_CONTENT, mailboxSession));
        return MessageViewFactory.Helpers.toMessageViews((Flux<MessageResult>)messages, this::fromMessageResults);
    }

    public Mono<MessageFullView> fromMetaDataWithContent(MetaDataWithContent message) {
        return Mono.fromCallable(() -> MessageViewFactory.Helpers.retrieveMessage(message)).flatMap((Function)Throwing.function(mimeMessage -> this.fromMetaDataWithContent(message, (Message)mimeMessage)));
    }

    private Mono<MessageFullView> fromMetaDataWithContent(MetaDataWithContent message, Message mimeMessage) throws IOException {
        MessageContentExtractor.MessageContent messageContent = this.messageContentExtractor.extract(mimeMessage);
        Optional htmlBody = messageContent.getHtmlBody();
        Optional<String> textBody = this.computeTextBodyIfNeeded(messageContent);
        return this.retrieveProjection(messageContent, message.getMessageId(), () -> MessageFullView.hasAttachment(this.getAttachments(message.getAttachments()))).map(messageProjection -> this.instanciateMessageFullView(message, mimeMessage, htmlBody, textBody, (MessageFastViewPrecomputedProperties)messageProjection));
    }

    private MessageFullView instanciateMessageFullView(MetaDataWithContent message, Message mimeMessage, Optional<String> htmlBody, Optional<String> textBody, MessageFastViewPrecomputedProperties messageProjection) {
        return ((MessageFullView.Builder)((MessageFullView.Builder)((MessageFullView.Builder)((MessageFullView.Builder)((MessageFullView.Builder)((MessageFullView.Builder)((MessageFullView.Builder)((MessageFullView.Builder)((MessageFullView.Builder)((MessageFullView.Builder)((MessageFullView.Builder)((MessageFullView.Builder)((MessageFullView.Builder)((MessageFullView.Builder)((MessageFullView.Builder)((MessageFullView.Builder)MessageFullView.builder().id(message.getMessageId())).blobId(BlobId.of(message.getMessageId()))).threadId(message.getMessageId().serialize())).mailboxIds(message.getMailboxIds())).inReplyToMessageId(MessageViewFactory.Helpers.getHeaderValue(mimeMessage, "in-reply-to"))).keywords(message.getKeywords())).subject(Strings.nullToEmpty((String)mimeMessage.getSubject()).trim())).headers(MessageViewFactory.Helpers.toHeaderMap(mimeMessage.getHeader()))).from(Emailer.firstFromMailboxList(mimeMessage.getFrom()))).to(Emailer.fromAddressList(mimeMessage.getTo()))).cc(Emailer.fromAddressList(mimeMessage.getCc()))).bcc(Emailer.fromAddressList(mimeMessage.getBcc()))).replyTo(Emailer.fromAddressList(mimeMessage.getReplyTo()))).size(message.getSize())).date(this.getDateFromHeaderOrInternalDateOtherwise(mimeMessage, message))).textBody(textBody).htmlBody(htmlBody).preview(messageProjection.getPreview())).attachments(this.getAttachments(message.getAttachments())).build();
    }

    private Mono<MessageFastViewPrecomputedProperties> retrieveProjection(MessageContentExtractor.MessageContent messageContent, MessageId messageId, Supplier<Boolean> hasAttachments) {
        return Mono.from((Publisher)this.fastViewProjection.retrieve(messageId)).onErrorResume(throwable -> this.fallBackToCompute(messageContent, hasAttachments, (Throwable)throwable)).switchIfEmpty(this.computeThenStoreAsync(messageContent, messageId, hasAttachments));
    }

    private Mono<MessageFastViewPrecomputedProperties> fallBackToCompute(MessageContentExtractor.MessageContent messageContent, Supplier<Boolean> hasAttachments, Throwable throwable) {
        LOGGER.error("Cannot retrieve the computed preview from MessageFastViewProjection", throwable);
        return this.computeProjection(messageContent, hasAttachments);
    }

    private Mono<MessageFastViewPrecomputedProperties> computeThenStoreAsync(MessageContentExtractor.MessageContent messageContent, MessageId messageId, Supplier<Boolean> hasAttachments) {
        return this.computeProjection(messageContent, hasAttachments).doOnNext(projection -> Mono.from((Publisher)this.fastViewProjection.store(messageId, projection)).doOnError(throwable -> LOGGER.error("Cannot store the projection to MessageFastViewProjection", throwable)).subscribeOn(Schedulers.elastic()).subscribe());
    }

    private Mono<MessageFastViewPrecomputedProperties> computeProjection(MessageContentExtractor.MessageContent messageContent, Supplier<Boolean> hasAttachments) {
        return Mono.fromCallable(() -> this.mainTextContent(messageContent)).handle(ReactorUtils.publishIfPresent()).map(Preview::compute).defaultIfEmpty((Object)Preview.EMPTY).map(extractedPreview -> MessageFastViewPrecomputedProperties.builder().preview(extractedPreview).hasAttachment(((Boolean)hasAttachments.get()).booleanValue()).build());
    }

    private Instant getDateFromHeaderOrInternalDateOtherwise(Message mimeMessage, MetaDataWithContent message) {
        return Optional.ofNullable(mimeMessage.getDate()).map(Date::toInstant).orElse(message.getInternalDate());
    }

    Mono<MessageFullView> fromMessageResults(Collection<MessageResult> messageResults) {
        try {
            return this.fromMetaDataWithContent(this.toMetaDataWithContent(messageResults));
        }
        catch (MailboxException e) {
            return Mono.error((Throwable)e);
        }
    }

    private MetaDataWithContent toMetaDataWithContent(Collection<MessageResult> messageResults) throws MailboxException {
        MessageViewFactory.Helpers.assertOneMessageId(messageResults);
        MessageResult firstMessageResult = messageResults.iterator().next();
        Set<MailboxId> mailboxIds = MessageViewFactory.Helpers.getMailboxIds(messageResults);
        Keywords keywords = MessageViewFactory.Helpers.getKeywords(messageResults);
        return MetaDataWithContent.builderFromMessageResult(firstMessageResult).messageId(firstMessageResult.getMessageId()).mailboxIds(mailboxIds).keywords(keywords).build();
    }

    private Optional<String> computeTextBodyIfNeeded(MessageContentExtractor.MessageContent messageContent) {
        return messageContent.getTextBody().or(() -> messageContent.extractMainTextContent(this.htmlTextExtractor));
    }

    private Optional<String> mainTextContent(MessageContentExtractor.MessageContent messageContent) {
        return messageContent.getHtmlBody().map(arg_0 -> ((HtmlTextExtractor)this.htmlTextExtractor).toPlainText(arg_0)).filter(Predicate.not(Strings::isNullOrEmpty)).or(() -> ((MessageContentExtractor.MessageContent)messageContent).getTextBody());
    }

    private List<Attachment> getAttachments(List<MessageAttachmentMetadata> attachments) {
        return (List)attachments.stream().map(this::fromMailboxAttachment).collect(ImmutableList.toImmutableList());
    }

    private Attachment fromMailboxAttachment(MessageAttachmentMetadata attachment) {
        return Attachment.builder().blobId(BlobId.of(attachment.getAttachmentId())).type(attachment.getAttachment().getType()).size(attachment.getAttachment().getSize()).name(attachment.getName()).cid(attachment.getCid().map(Cid::getValue)).isInline(attachment.isInline()).build();
    }

    public static class MetaDataWithContent {
        private final MessageUid uid;
        private final Keywords keywords;
        private final long size;
        private final Instant internalDate;
        private final InputStream content;
        private final SharedInputStream sharedContent;
        private final List<MessageAttachmentMetadata> attachments;
        private final Set<MailboxId> mailboxIds;
        private final MessageId messageId;
        private final Optional<Message> message;

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builderFromMessageResult(MessageResult messageResult) throws MailboxException {
            Builder builder = MetaDataWithContent.builder().uid(messageResult.getUid()).size(messageResult.getSize()).internalDate(messageResult.getInternalDate().toInstant()).attachments(messageResult.getLoadedAttachments()).mailboxId(messageResult.getMailboxId());
            try {
                return builder.content(messageResult.getFullContent().getInputStream());
            }
            catch (IOException e) {
                throw new MailboxException("Can't get message full content: " + e.getMessage(), (Throwable)e);
            }
        }

        private MetaDataWithContent(MessageUid uid, Keywords keywords, long size, Instant internalDate, InputStream content, SharedInputStream sharedContent, List<MessageAttachmentMetadata> attachments, Set<MailboxId> mailboxIds, MessageId messageId, Optional<Message> message) {
            this.uid = uid;
            this.keywords = keywords;
            this.size = size;
            this.internalDate = internalDate;
            this.content = content;
            this.sharedContent = sharedContent;
            this.attachments = attachments;
            this.mailboxIds = mailboxIds;
            this.messageId = messageId;
            this.message = message;
        }

        public Optional<Message> getMessage() {
            return this.message;
        }

        public MessageUid getUid() {
            return this.uid;
        }

        public Keywords getKeywords() {
            return this.keywords;
        }

        public long getSize() {
            return this.size;
        }

        public Instant getInternalDate() {
            return this.internalDate;
        }

        public InputStream getContent() {
            if (this.sharedContent != null) {
                long begin = 0L;
                long allContent = -1L;
                return this.sharedContent.newStream(begin, allContent);
            }
            return this.content;
        }

        public List<MessageAttachmentMetadata> getAttachments() {
            return this.attachments;
        }

        public Set<MailboxId> getMailboxIds() {
            return this.mailboxIds;
        }

        public MessageId getMessageId() {
            return this.messageId;
        }

        public static class Builder {
            private MessageUid uid;
            private Keywords keywords;
            private Long size;
            private Instant internalDate;
            private InputStream content;
            private SharedInputStream sharedContent;
            private List<MessageAttachmentMetadata> attachments;
            private Set<MailboxId> mailboxIds = Sets.newHashSet();
            private MessageId messageId;
            private Optional<Message> message = Optional.empty();

            public Builder uid(MessageUid uid) {
                this.uid = uid;
                return this;
            }

            public Builder keywords(Keywords keywords) {
                this.keywords = keywords;
                return this;
            }

            public Builder size(long size) {
                this.size = size;
                return this;
            }

            public Builder internalDate(Instant internalDate) {
                this.internalDate = internalDate;
                return this;
            }

            public Builder content(InputStream content) {
                this.content = content;
                return this;
            }

            public Builder sharedContent(SharedInputStream sharedContent) {
                this.sharedContent = sharedContent;
                return this;
            }

            public Builder attachments(List<MessageAttachmentMetadata> attachments) {
                this.attachments = attachments;
                return this;
            }

            public Builder mailboxId(MailboxId mailboxId) {
                this.mailboxIds.add(mailboxId);
                return this;
            }

            public Builder message(Message message) {
                this.message = Optional.of(message);
                return this;
            }

            public Builder mailboxIds(Set<MailboxId> mailboxIds) {
                this.mailboxIds.addAll(mailboxIds);
                return this;
            }

            public Builder messageId(MessageId messageId) {
                this.messageId = messageId;
                return this;
            }

            public MetaDataWithContent build() {
                Preconditions.checkArgument((this.uid != null ? 1 : 0) != 0);
                Preconditions.checkArgument((this.keywords != null ? 1 : 0) != 0);
                Preconditions.checkArgument((this.size != null ? 1 : 0) != 0);
                Preconditions.checkArgument((this.internalDate != null ? 1 : 0) != 0);
                Preconditions.checkArgument((boolean)(this.content != null ^ this.sharedContent != null));
                Preconditions.checkArgument((this.attachments != null ? 1 : 0) != 0);
                Preconditions.checkArgument((this.mailboxIds != null ? 1 : 0) != 0);
                Preconditions.checkArgument((this.messageId != null ? 1 : 0) != 0);
                return new MetaDataWithContent(this.uid, this.keywords, this.size, this.internalDate, this.content, this.sharedContent, this.attachments, this.mailboxIds, this.messageId, this.message);
            }
        }
    }
}

