/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.extension;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.james.mailbox.MetadataWithMailboxId;
import org.reactivestreams.Publisher;

public interface PreDeletionHook {
    public static final Set<PreDeletionHook> NO_PRE_DELETION_HOOK = ImmutableSet.of();

    public Publisher<Void> notifyDelete(DeleteOperation var1);

    public static class DeleteOperation {
        private final DeletionId deletionId;
        private final List<MetadataWithMailboxId> deletionMetadataList;

        public static DeleteOperation from(List<MetadataWithMailboxId> deletionMetadataList) {
            return new DeleteOperation(DeletionId.random(), deletionMetadataList);
        }

        private DeleteOperation(DeletionId deletionId, List<MetadataWithMailboxId> deletionMetadataList) {
            this.deletionId = deletionId;
            this.deletionMetadataList = deletionMetadataList;
        }

        public DeletionId getDeletionId() {
            return this.deletionId;
        }

        public List<MetadataWithMailboxId> getDeletionMetadataList() {
            return this.deletionMetadataList;
        }

        public final boolean equals(Object o) {
            if (o instanceof DeleteOperation) {
                DeleteOperation that = (DeleteOperation)o;
                return Objects.equals(this.deletionId, that.deletionId) && Objects.equals(this.deletionMetadataList, that.deletionMetadataList);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.deletionId, this.deletionMetadataList);
        }
    }

    public static class DeletionId {
        private final UUID id;

        public static DeletionId random() {
            return new DeletionId(UUID.randomUUID());
        }

        public static DeletionId of(UUID uuid) {
            return new DeletionId(uuid);
        }

        private DeletionId(UUID id) {
            Preconditions.checkNotNull((Object)id, (Object)"id for deletion cannot be null");
            this.id = id;
        }

        public String asString() {
            return this.id.toString();
        }

        public final boolean equals(Object o) {
            if (o instanceof DeletionId) {
                DeletionId that = (DeletionId)o;
                return Objects.equals(this.id, that.id);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

