/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.BlockedCallback;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.UnblockedCallback;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.util.annotation.Nullable;

public class IdempotentClosedConnection
implements Connection {
    private final Connection delegate;
    private final AtomicBoolean closingOrClosed = new AtomicBoolean(false);

    public IdempotentClosedConnection(Connection delegate) {
        this.delegate = delegate;
    }

    public Connection getDelegate() {
        return this.delegate;
    }

    public InetAddress getAddress() {
        return this.delegate.getAddress();
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public int getChannelMax() {
        return this.delegate.getChannelMax();
    }

    public int getFrameMax() {
        return this.delegate.getFrameMax();
    }

    public int getHeartbeat() {
        return this.delegate.getHeartbeat();
    }

    public Map<String, Object> getClientProperties() {
        return this.delegate.getClientProperties();
    }

    @Nullable
    public String getClientProvidedName() {
        return this.delegate.getClientProvidedName();
    }

    public Map<String, Object> getServerProperties() {
        return this.delegate.getServerProperties();
    }

    @Nullable
    public Channel createChannel() throws IOException {
        return this.delegate.createChannel();
    }

    @Nullable
    public Channel createChannel(int channelNumber) throws IOException {
        return this.delegate.createChannel(channelNumber);
    }

    public void close() throws IOException {
        if (this.shouldCloseOrAbort()) {
            this.delegate.close();
        }
    }

    public void close(int closeCode, String closeMessage) throws IOException {
        if (this.shouldCloseOrAbort()) {
            this.delegate.close(closeCode, closeMessage);
        }
    }

    public void close(int timeout) throws IOException {
        if (this.shouldCloseOrAbort()) {
            this.delegate.close(timeout);
        }
    }

    public void close(int closeCode, String closeMessage, int timeout) throws IOException {
        if (this.shouldCloseOrAbort()) {
            this.delegate.close(closeCode, closeMessage, timeout);
        }
    }

    public void abort() {
        if (this.shouldCloseOrAbort()) {
            this.delegate.abort();
        }
    }

    public void abort(int closeCode, String closeMessage) {
        if (this.shouldCloseOrAbort()) {
            this.delegate.abort(closeCode, closeMessage);
        }
    }

    public void abort(int timeout) {
        if (this.shouldCloseOrAbort()) {
            this.delegate.abort(timeout);
        }
    }

    public void abort(int closeCode, String closeMessage, int timeout) {
        if (this.shouldCloseOrAbort()) {
            this.delegate.abort(closeCode, closeMessage, timeout);
        }
    }

    private boolean shouldCloseOrAbort() {
        return this.closingOrClosed.compareAndSet(false, true);
    }

    public void addBlockedListener(BlockedListener listener) {
        this.delegate.addBlockedListener(listener);
    }

    public BlockedListener addBlockedListener(BlockedCallback blockedCallback, UnblockedCallback unblockedCallback) {
        return this.delegate.addBlockedListener(blockedCallback, unblockedCallback);
    }

    public boolean removeBlockedListener(BlockedListener listener) {
        return this.delegate.removeBlockedListener(listener);
    }

    public void clearBlockedListeners() {
        this.delegate.clearBlockedListeners();
    }

    public ExceptionHandler getExceptionHandler() {
        return this.delegate.getExceptionHandler();
    }

    public String getId() {
        return this.delegate.getId();
    }

    public void setId(String id) {
        this.delegate.setId(id);
    }

    public void addShutdownListener(ShutdownListener listener) {
        this.delegate.addShutdownListener(listener);
    }

    public void removeShutdownListener(ShutdownListener listener) {
        this.delegate.removeShutdownListener(listener);
    }

    @Nullable
    public ShutdownSignalException getCloseReason() {
        return this.delegate.getCloseReason();
    }

    public void notifyListeners() {
        this.delegate.notifyListeners();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }
}

