/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPBindException;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.ResultCode;
import org.apache.james.core.Username;
import org.apache.james.user.api.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyLDAPUser
implements User {
    public static final Logger LOGGER = LoggerFactory.getLogger(ReadOnlyLDAPUser.class);
    private final Username userName;
    private final DN userDN;
    private final LDAPConnectionPool connectionPool;

    public ReadOnlyLDAPUser(Username userName, DN userDN, LDAPConnectionPool connectionPool) {
        this.userName = userName;
        this.userDN = userDN;
        this.connectionPool = connectionPool;
    }

    public Username getUserName() {
        return this.userName;
    }

    public boolean setPassword(String newPass) {
        return false;
    }

    public boolean verifyPassword(String password) {
        try {
            BindResult bindResult = this.connectionPool.bindAndRevertAuthentication(this.userDN.toString(), password, new Control[0]);
            return bindResult.getResultCode() == ResultCode.SUCCESS;
        }
        catch (Exception e) {
            if (e instanceof LDAPBindException) {
                LOGGER.info("Error binding LDAP for {}: {}", (Object)this.userName.asString(), (Object)e.getMessage());
            }
            LOGGER.error("Unexpected error upon authentication", (Throwable)e);
            return false;
        }
    }
}

